define("discovery/exceptions",[],function(){"use strict";var a=function(a,b){var c=function(){var c=Error.apply(this,arguments);return c.name=this.name=a,this.disqusCode=b||"uncaught",this.message=c.message,this.stack=c.stack,this},d=function(){};return d.prototype=Error.prototype,c.prototype=new d,c};return{NoAds:a("NoAds","no_ads"),NoBinError:a("NoBinError","no_bin"),AdsExhaustedError:a("AdsExhaustedError","ads_exhausted"),RenderError:a("RenderError","render_error"),FetchError:a("FetchError","fetch_error"),TimeoutError:a("TimeoutError","timeout"),ValidationError:a("ValidationError","validation_error")}}),define("discovery/models",["underscore","backbone","moment","core/analytics/identity","core/time","shared/corefuncs"],function(a,b,c,d,e,f){"use strict";var g=function(b){var c=b.prototype;return b.extend({defaults:{redirectUrl:null,signedUrl:null,userId:null,sourceThreadId:null,forumId:null,forum:null,majorVersion:null,requestBin:null},redirectPayload:function(){var b={url:this.get("signedUrl"),imp:d.impression.impId,prev_imp:d.impression.prevImp,forum_id:this.get("forumId"),forum:this.get("forum"),thread_id:this.get("sourceThreadId")};return a.extend(b,this.get("service")),this.has("requestBin")&&(b.bin=this.get("requestBin")),this.has("userId")&&(b.user_id=this.get("userId")),b},redirectUrl:function(){var a=this.get("redirectUrl"),b=this.redirectPayload();return f.serialize(a,b)},toJSON:function(){var a=c.toJSON.call(this);return a.redirectUrl=this.redirectUrl(),a},toString:function(){return this.get("title")+" "+this.get("link")+" (id = "+this.id+")"}})}(b.Model),h=function(b){var d=b.prototype;return b.extend({defaults:a.defaults({createdAgo:!1},d.defaults),initialize:function(a,b){if(b&&b.humanFriendlyTimestamp){var d=e.assureTzOffset(this.get("createdAt"));d=c(d,e.ISO_8601),this.set("createdAgo",d.fromNow())}},redirectPayload:function(){var b=d.redirectPayload.call(this);return a.extend(b,{thread:this.id,zone:"thread",area:"discovery"}),b},toJSON:function(){var a=d.toJSON.call(this);return a.thumbnailUrl=a.thumbnail,a.preview&&(a.preview=a.preview.toJSON()),a},toString:function(){return"organic link: "+d.toString.call(this)}})}(g),i=function(b){var c=b.prototype;return b.extend({idAttribute:"advertisement_id",defaults:a.defaults({brand:null,headline:null,text:null,url:null,signedUrl:null,advertisement_id:null,tracking_pixels_onview:null},c.defaults),parse:function(a){return a.signedUrl=a.signed_url,a.thumbnailUrl=a.thumbnail_url,delete a.signed_url,a},get:function(a){return{title:this.attributes.headline,link:this.attributes.url}[a]||c.get.call(this,a)},redirectPayload:function(){var b=c.redirectPayload.call(this);return a.extend(b,{zone:"thread",area:"discovery",advertisement_id:this.get("advertisement_id"),brand:this.get("brand"),headline:this.get("headline"),ad_product_name:"sponsored_links"}),b},toJSON:function(){var a=c.toJSON.call(this);return a.title=a.headline,a.link=a.url,a},toString:function(){return"promoted link: "+c.toString.call(this)}})}(g),j={RelatedThread:h,Advertisement:i};return DISQUS.testing&&(j.BaseContentModel=g),j}),define("discovery/custom-comments",["jquery","underscore","when","core/models/Media","core/utils","shared/urls","shared/corefuncs","common/urls","common/templates","discovery/exceptions","exports"],function(a,b,c,d,e,f,g,h,i,j,k){"use strict";k.getProtocol=function(a){var b=(a||"").match(/^\s*(\w+:)?\/\//);return b?(b[1]||"").toLowerCase():null},k.getPageProtocol=function(){return window.location.protocol},k.forceWebProtocol=function(a,b){var c=k.getProtocol(a);if(null===c)return"";var d=k.getPageProtocol();return c||(c=d),"http:"===d&&(b=!0),"http:"===c&&b||(c="https:"),f.ensureHttpBasedProtocol(a,c)};var l=/<(\S+)[^<]+$/;k.extractTrackingTags=function(a){if(b.isArray(a))return b.map(a,function(a){return{tag:"img",url:a}});for(var c=e.bleachFindUrls(a),d=[],f=0;f<c.length;++f){var g=c[f],h=g.index,i=0;f>0&&(i=c[f-1].endIndex);var j=a.substr(i,h-i),m=l.exec(j);if(m){var n=m[1].toLowerCase();if("img"===n||"iframe"===n){var o=k.forceWebProtocol(g.url);o&&d.push({tag:n,url:o})}}}return d},k.ajax=function(b){var d=c.defer(),e=d.promise;return a.ajax(b).done(function(){d.resolve.apply(d,arguments)}).fail(function(a,b,c){d.reject(new j.FetchError(c))}),e},k.handlers={};var m=function(a){var b=(a.main_media&&a.main_media[0]||{}).url,c=(a.custom||{}).brand_name,d=k.forceWebProtocol(decodeURIComponent(a.click_url));return{title:a.title,summary:a.description,target_url:d,brand_name:c,thumbnail_url:k.forceWebProtocol(b),layout:"image_target",tracking_pixels_onload:k.extractTrackingTags(a.impression_trackers),tracking_pixels_onclick:k.extractTrackingTags(a.click_trackers)}},n=function(a){var b=(a.main_media&&a.main_media[0]||{}).url;return{media_url:k.forceWebProtocol(b),target_url:k.forceWebProtocol(a.click_url,!0),brand_name:(a.custom||{}).brand_name||a.title,brand_image_url:k.forceWebProtocol(a.icon_img_url),summary:a.description,layout:"iframe",tracking_pixels_onload:k.extractTrackingTags(a.impression_trackers),tracking_pixels_onclick:k.extractTrackingTags(a.click_trackers)}};k.handlers.appnexus=function(a,b){return a.get("placement_id")?k.ajax({url:"https://mobile.adnxs.com/mob",data:{id:a.get("placement_id"),size:"1x1",st:"web",version:1,referrer:b}}).then(function(b){if(!b)throw new j.NoAds("Provider response had no data.");var c=(b["native"]||b.ads||[null])[0];if(!c)throw new j.NoAds("Neither 'native' nor 'ads' fields were found in response.");var d=!1;try{d=JSON.parse(c.custom.object).is_video}catch(e){}return a.set(d?n(c):m(c)),a}):c.reject(new j.ValidationError("No placement_id specified."))},k.handlers.criteo_dr=function(a){return k.ajax({url:"https://cas.criteo.com/delivery/0.1/napi.jsonp",data:{zoneid:a.get("zoneid")||254525,bannerid:a.get("bannerid")||4088067},dataType:"jsonp",timeout:1e4}).then(function(c){if(0!==c.response_status)throw new j.NoAds(c.status_message||"No offer from Criteo.");var d=c.advertiser,e=c.products&&c.products[0];if(!e||!d)throw new j.NoAds("No ad found.");return b.each(c.impression_pixels,function(a){a.tag="img"}),a.set({title:e.title,summary:e.description,target_url:e.click_url,brand_name:d.description,layout:"image_target",tracking_pixels_onload:c.impression_pixels,privacy_click_url:c.privacy.optout_click_url,thumbnail_url:k.forceWebProtocol(e.image.url),privacy_image_url:k.forceWebProtocol(c.privacy.optout_image_url)}),a})},k.handlers.appnexus_dr=function(a,b){return a.get("placement_id")?k.ajax({url:"https://ib.adnxs.com/mob",data:{id:a.get("placement_id"),st:"web",referrer:b,format:"json",psa:0}}).then(function(b){if(!(b&&b.ads&&b.ads.length))throw new j.NoAds("No data in response found.");var c=b.ads[0];if(!(c.content&&c.width&&c.height))throw new j.ValidationError("Ad is missing some of the required fields.");return a.set({content:c.content,width:c.width,height:c.height}),a}):c.reject(new j.ValidationError("No placement_id specified."))}}),define("discovery/helpers",["underscore","jquery","loglevel","raven","remote/config","core/switches"],function(a,b,c,d,e,f){"use strict";var g=function(b,c,d){var g=e.discovery||{},h=f.isFeatureActive("discovery_override")&&c.get("discoveryOverride"),i=h||b.discoveryVariant,j=g.variantSpecific||{};if(i)i=a.extend(a.omit(g,"variantSpecific"),{name:i,thumbnailsEnabled:b.discoveryThumbnailsEnabled},j[i]);else{if(!b.adsVideoEnabled&&!b.adsDRNativeEnabled)return;i={organicEnabled:!1,promotedEnabled:!1}}return d.disable_promoted&&!b.discoveryLocked&&(i.promotedEnabled=!1,i.thumbnailsEnabled=!1),i},h=function(d,e){function f(){return j.scrollHeight-j.offsetHeight>.2*k}function g(){i.lastChild&&!a.contains(["...","…"],i.lastChild.nodeValue)&&(l=i.appendChild(window.document.createTextNode(" "+n)),f()&&(i.removeChild(l),i.removeChild(i.lastChild),g()))}if(!d.closest("body").length)return void c.info("lineTruncate called on el not on DOM");if(d.text().length<1)return void c.info("lineTruncated called on empty el");var h=function(a){return 3!==a.nodeType};if(a.any(d.children(),h))return void c.info("lineTruncate called on non-flat el");var i=d[0],j=i;if("block"!==d.css("display"))for(;j.parentNode&&(j=j.parentNode,"block"!==b(j).css("display")););var k=parseFloat(d.css("font-size"),10);if(f()){e=e||{};var l,m=e.lines||1,n=e.ellipsis,o=d.text();if(o.length){var p=d.width()/k,q=parseInt(p*m,10),r=o.split(/\s/),s=0;d.empty();var t,u=r.length;for(t=0;u>t&&(s+=r[t].length+1,!(s>=q));t++)i.appendChild(document.createTextNode(" "+r[t]));if(f()){do l=i.removeChild(i.lastChild);while(f())}else{do l=i.appendChild(document.createTextNode(" "+r[t++]));while(!f()&&u>t);i.removeChild(l)}n&&(a.isString(n)||(n="…"),g())}}},i=function(b){function c(a,b){return a+b}var d,e,f=a.keys(b),g=Math.floor(a.reduce(b,c,0)/2),h=f.length+1,i=g+1,j=new Array(h);for(d=0;h>d;d++)j[d]=new Array(i),j[d][0]={};for(e=1;i>e;e++)j[0][e]=!1;var k,l,m,n={};for(e=1;i>e;e++)for(d=1;h>d;d++)k=f[d-1],l=b[k],m=a.clone(j[d-1][e]),!m&&e>=l&&(m=a.clone(j[d-1][e-l]),m&&(m[k]=l,n=m)),j[d][e]=m;return[n,a.omit(b,a.keys(n))]},j=["product","zone","service","experiment","variant"],k=function(b){b=b||"";var c=a.object(j,b.split(":"));return{bin:b,experiment:c.experiment||"",variant:c.variant||""}},l=function(a,b){a&&(c.debug(a),a.disqusCode||d.captureException(a),b&&a.disqusCode&&b.reportError(a))};return{generateVariantConfig:g,lineTruncate:h,balancedPartition:i,binToEventParams:k,reportError:l}}),define("discovery/models/BaseAd",["underscore","backbone","when","loglevel","discovery/custom-comments","discovery/helpers","core/analytics/jester","common/utils"],function(a,b,c,d,e,f,g,h){"use strict";var i={iframe:"video",image_target:"native_dr",video_vast:"video",video_iframe:"video"};return b.Model.extend({idAttribute:"advertisement_id",getProvider:function(){return this.get("provider")||this.get("ad_provider")},toLogString:function(){return"["+this.getProvider()+":"+this.get("layout")+"]"},fetch:function(b){b=b||{};var d=this.getProvider(),f=e.handlers[d],g=a.isFunction(f)?f(this,b.sourceThreadUrl):c.resolve(this);return g},reportRequest:function(){this._report({verb:"call",object_type:"provider",object_id:this.getProvider(),adjective:1})},reportLoad:function(){d.debug(this.toLogString()+": Unit is ready."),this._fireLoadPixels(),this._report({verb:"load"})},reportError:function(a){this._report({verb:"fail",object_type:"provider",object_id:this.getProvider(),adverb:a.disqusCode})},reportIABView:function(){this._fireViewPixels(),this._report({verb:"view",adverb:"iab-scroll"})},reportView:function(){this._report({verb:"view",adverb:"0ms-no50perc"})},reportPlayStart:function(){d.debug(this.toLogString()+": Video player reported play started."),this._report({verb:"start-playing"})},reportPlayEnd:function(){d.debug(this.toLogString()+": Video player reported play ended."),this._report({verb:"finish-playing"})},_report:function(b){var c=this.get("layout");return g.client.emit(a.defaults(b,{object_type:"advertisement",object_id:"["+this.id+"]",advertisement_id:this.id,ad_product_name:i[c]||c,ad_product_layout:c,zone:"thread",area:"sponsored_comment"},f.binToEventParams(this.get("bin"))))},fireClickPixels:function(){var a=this.get("tracking_pixels_onclick");h.loadPixels(a)},_fireViewPixels:function(){var a=this.get("tracking_pixels_onview")||[],b=this.get("tracking_pixel_url");b&&a.push({tag:"img",url:b}),h.loadPixels(a)},_fireLoadPixels:function(){var a=this.get("tracking_pixels_onload")||[];h.loadPixels(a)}})}),define("discovery/models/SponsoredLinkAd",["underscore","backbone","when","loglevel","core/analytics/jester","discovery/helpers","discovery/models/BaseAd","discovery/exceptions"],function(a,b,c,d,e,f,g,h){"use strict";return g.extend({defaults:{provider:"Disqus"},initialize:function(b,c){var d=this;d.sponsoredLinks=c.sponsoredLinks,d.threads=c.threads,d.collections=[],d.app=c.app,a.bindAll(d,"validateCollectionMin","prepareData"),d.set("sectionNames",["col-organic","col-promoted"]),d.set("sectionIds",a.map(d.get("sectionNames"),function(a){return a+"-"+d.cid})),d.sequenceDataCollections()},sequenceDataCollections:function(){var b=this.app;this.collections=[this.threads],b.get("promotedEnabled")&&this.collections.push(this.sponsoredLinks),this.collections=a.compact(this.collections);var c=b.get("promotedEnabled")&&1===this.collections.length,d=b.get("promotedEnabled")&&"left"===b.get("promotedSide");(d||c)&&(this.get("sectionNames")&&this.get("sectionNames").reverse(),this.get("sectionIds")&&this.get("sectionIds").reverse(),this.collections.reverse())},hasData:function(){return a.some(this.collections,function(a){return a.length})},validateCollectionMin:function(){for(var b,c,d=this.collections,e=this.get("sectionNames").slice(0),f=this.get("sectionIds").slice(0),g=d.length;g>0;)b=d[--g],c=b.minLength,b.length<c&&(d.splice(g,1),e.splice(g,1),f.splice(g,1),g=d.length);if(a.isNumber(this.app.get("numColumns"))&&a.isNumber(this.app.get("minPerColumn"))){var h=this.app.get("numColumns")*this.app.get("minPerColumn"),i=a.reduce(d,function(a,b){return a+b.length},0);h>i&&(d.splice(0,d.length),e.splice(0,e.length),f.splice(0,f.length))}this.set("sectionNames",e),this.set("sectionIds",f)},prepareData:function(){var a=this.commonClickMetadata();this.sponsoredLinks.addClickMetadata(a),this.threads.addClickMetadata(a),this.trimCollections()},trimCollections:function(){for(var a,b,c=this.collections,d=c.length,e=0;d>e;e++)a=c[e],b=a.maxLength,a.length>b&&a.reset(a.slice(0,b))},validateData:function(){var a=this;if(a.threads.maxLength=a.app.getCollectionMax("Organic"),1===a.collections.length&&a.deactivateThumbnails(),this.sponsoredLinks.validate(),this.validateCollectionMin(),this.prepareData(),!a.hasData())throw new h.ValidationError("Not enough data")},deactivateThumbnails:function(){this.app.set({contentPreviews:!0})},commonClickMetadata:function(){var a=this.app,b=a.get("sourceForum"),c={redirectUrl:a.get("redirectUrl"),sourceThreadId:a.get("sourceThread").id,forumId:b.pk,forum:b.id,requestBin:a.get("requestBin"),service:a.get("service")};return a.session.isLoggedIn()&&(c.userId=a.session.user.id),c},report:function(b){a.isEmpty(b)||e.client.emit(a.extend(this.snapshot(),b))},snapshot:function(){var b=this.threads,c=this.app,d=f.binToEventParams(c.get("requestBin")),e=c.session,g=e&&e.isLoggedIn()?{userId:e.user.id}:{},h=a.extend({internal_organic:b&&b.length,external_organic:0,promoted:0,display:!0,placement:this.get("placement"),zone:"thread",area:"discovery",thread_id:c.get("sourceThread").id,forum_id:c.get("sourceForum").pk},g,d,this.getAdData());return h},getAdData:function(){var a=this.app;if(!a.get("promotedEnabled"))return{object_type:"link"};var b=JSON.stringify(this.sponsoredLinks.pluck("advertisement_id")),c=this.areThumbnailsEnabled();return{promoted:this.sponsoredLinks.length,promoted_ids:b,object_type:"advertisement",object_id:b,advertisement_id:b,ad_product_name:"sponsored_links",ad_product_layout:c?"thumbnails":"headlines"}},areThumbnailsEnabled:function(){return this.app.get("maxPromotedThumbnailLinks")}})}),define("discovery/collections",["jquery","backbone","underscore","when","loglevel","core/api","core/utils","core/utils/html","discovery/exceptions","discovery/models","discovery/models/BaseAd","discovery/models/SponsoredLinkAd"],function(a,b,c,d,e,f,g,h,i,j,k,l){"use strict";var m=b.Collection.extend({url:function(a){return f.getURL(a)}}),n=function(a){var b=a.prototype;return a.extend({url:function(){return b.url.call(this,"discovery/listTopPost.json")},parse:function(a){for(var c=b.parse.call(this,a),d=0,e=c.length;e>d;d++)c[d].plaintext=h.stripTags(c[d].message);return c}})}(m),o=m.extend({initialize:function(a,b){this.model=j[this.modelName],this.name=b.name,this.minLength=b.minLength,this.maxLength=b.maxLength},addClickMetadata:function(a){this.invoke("set",a)}}),p=o.extend({modelName:"RelatedThread",initialize:function(a,b){o.prototype.initialize.call(this,a,b),this.previews=new n},url:function(){return o.prototype.url.call(this,"discovery/listRelated.json")},fetch:function(a,b){a.data.limit=2*this.maxLength;var c=d(o.prototype.fetch.call(this,a)),f=this;return b&&(c=c.then(function(){return f.getContentPreviews().otherwise(function(a){e.info("There was a problem getting snippets: ",a)})})),c},getContentPreviews:function(){var a=this.map(function(a){return parseInt(a.get("id"),10)});if(a.length<this.minLength)return d.resolve();a.sort(function(a,b){return a-b});var b=d(this.previews.fetch({data:{thread:a},timeout:p.CONTENT_PREVIEWS_FETCH_TIMEOUT}));return b.then(c.bind(this.attachPreviews,this))},attachPreviews:function(){this.previews.each(function(a){var b=a.get("thread"),c=this.get(b);c&&c.set("preview",a)},this)}},{CONTENT_PREVIEWS_FETCH_TIMEOUT:5e3}),q=o.extend({modelName:"Advertisement",initialize:function(a,b){b=c.extend({name:"Promoted",minLength:1},b),o.prototype.initialize.call(this,a,b)},parse:function(a){return a},validate:function(){g.isMobileUserAgent()&&this.length>0&&this.remove(this.where({mobile:!1}))}}),r=m.extend({url:"//tempest.services.disqus.com/listPromoted",initialize:function(a,c){c=c||{},this._top=new b.Collection,this._bottom=new b.Collection},fetch:function(a){return d(m.prototype.fetch.call(this,a))},getTopAds:function(){return this._top},getBottomAds:function(){return this._bottom},parse:function(a,b){function d(a){switch(a.bin=e,a.layout){case"links":return new l(a,{sponsoredLinks:new q(a.ads,{parse:!0,maxLength:b.sponsoredLinksMaxLength}),threads:b.threads,app:b.app});default:return new k(a)}}var e=a.bin;this._top.reset(c.map(a.top_placement||a.big_unit,d,this)),this._bottom.reset(c.map(a.bottom_placement,d,this))}}),s={PostCollection:n,RelatedThreadCollection:p,AdvertisementCollection:r,SponsoredLinksCollection:q};return DISQUS.testing&&(s.BaseCollection=m,s.BaseContentCollection=o),s}),define("discovery/variants",[],function(){"use strict";return{"default":{maxPerColumn:2,inlineMeta:!1,contentPreviews:!0,promotedEnabled:!1,topPlacementEnabled:!1},promoted:{maxPerColumn:4,inlineMeta:!0,contentPreviews:!1,promotedEnabled:!0,topPlacementEnabled:!1,promotedSide:"right"},max:{maxPerColumn:4,inlineMeta:!0,contentPreviews:!1,promotedEnabled:!0,topPlacementEnabled:!0,promotedSide:"left"},thumbnails:{maxPromotedThumbnailLinks:4,promotedSide:"left",numLinesHeadline:4}}}),define("discovery/views/BaseUnit",["backbone","underscore","stance","stance/utils","when","discovery/exceptions"],function(a,b,c,d,e,f){"use strict";var g=function(a,b){var c=null,d=!1;this.start=function(){d||(c=window.setTimeout(function(){d=!0,a()},b))},this.clear=function(){window.clearTimeout(c)}};return a.View.extend({className:"generic-ad__wrapper",initialize:function(){this._isReady=e.defer(),this._isReady.promise.then(b.bind(this._onResolve,this))},isReady:function(){return this._isReady.promise},_onResolve:function(){this.listenTo(this,{"view:iab":b.bind(this.model.reportIABView,this.model)}),this._setupViewEvents(),this.model.reportLoad()},_rejectReadyPromise:function(a){this._isReady.reject(a)},handleReady:function(){this._isReady.resolve()},handleRenderError:function(a){this._rejectReadyPromise(new f.RenderError(a))},handleTimeoutError:function(a){this._rejectReadyPromise(new f.TimeoutError(a))},handleNoOfferError:function(a){this._rejectReadyPromise(new f.NoAds(a))},_setupViewEvents:function(){var a=this,e=!1,f=new g(b.bind(this.trigger,this,"view:iab"),1e3);a.on("view:50in",f.start,f),a.on("view:50out",f.clear,f),a.listenTo(c({el:a.el}),{enter:function(){a.trigger("view:enter",a)},exit:function(){a.trigger("view:exit",a),e&&(e=!1,a.trigger("view:50out",a))},visible:function(b,c){var f=d.visiblePercent(c,b.offset());f>=50&&!e?(e=!0,a.trigger("view:50in",a)):50>f&&e&&(e=!1,a.trigger("view:50out",a)),a.trigger("view",a,{percentViewable:f})}})}})}),define("discovery/views/HostUnit",["discovery/views/BaseUnit"],function(a){"use strict";return a.extend({injectable:function(){return this.model.get("content")},render:function(){return this.handleReady(),this}})}),define("discovery/views/Iframe",["jquery","underscore","backbone","core/utils/urls"],function(a,b,c,d){"use strict";var e=c.View.extend({tagName:"iframe",initialize:function(c){var e=c.src||this.el.src;this._source=e,this._origin=d.getOrigin(e),this._onMessage=b.bind(this._onMessage,this),a(window).on("message",this._onMessage),this._ready=!1,this._buffer=[],this.once("message",this._onLoad)},_onLoad:function(){this._ready=!0,b.each(this._buffer,this.postMessage,this)},_onMessage:function(a){a=a.originalEvent,a&&a.origin===this._origin&&this.trigger("message",a.data,this)},render:function(){return this.$el.attr("src",this._source),this},postMessage:function(a){if(this._ready)try{this.el.contentWindow.postMessage(a,this._origin)}catch(b){}else this._buffer.push(a)},remove:function(){return a(window).off("message",this._onMessage),c.View.prototype.remove.apply(this,arguments)}});return e}),define("discovery/views/IframeUnit",["jquery","underscore","backbone","core/bus","core/strings","common/templates","discovery/views/BaseUnit","discovery/views/Iframe"],function(a,b,c,d,e,f,g,h){"use strict";var i=1e4,j=g.extend({proxyEvents:{"view:iab":1,"view:50in":1,"view:50out":1,"view:enter":1,"view:exit":1,view:1},templateName:"videoAd",initialize:function(){g.prototype.initialize.apply(this,arguments),this.listenTo(this,"all",this._proxyEvents),this.listenTo(d.frame,"embed.resized",b.debounce(b.bind(this.render,this),100))},isEmbedHidden:function(){return!a("body").width()},_proxyEvents:function(a,b,c){this.proxyEvents[a]&&("view"===a?this._postMessage({event:"view",percentViewable:c.percentViewable}):(this._postMessage("disqus."+a),this._postMessage({event:a}),"view:iab"===a&&this._postMessage("disqus.inView")))},startTimeout:function(a,c){this.cancelTimeout(),this._timeout=b.delay(b.bind(this.handleTimeoutError,this,c||"Unit timed out."),a)},cancelTimeout:function(){window.clearTimeout(this._timeout)},remove:function(){return this.cancelTimeout(),this._removeFrame(),g.prototype.remove.apply(this,arguments)},_removeFrame:function(){this.frame&&(this.stopListening(this.frame),this.frame.remove())},render:function(){if(this.isEmbedHidden())return this;this.stopListening(d.frame,"embed.resized"),this._removeFrame();var a=this.serializeData();return this.$el.html(f.render(this.templateName,a)),this.frame=new h({el:this.$("iframe")[0],src:a.iframeUrl}),this.listenTo(this.frame,"message",this.handleMessage),this.model.reportRequest(),this.frame.render(),this.startTimeout(i,"Provider timed out."),this},_postMessage:function(a){this.frame.postMessage(b.isString(a)?a:JSON.stringify(a))},serializeData:function(){return this.model.toJSON()},handleMessage:function(){}});return j}),define("discovery/views/IABDisplayUnit",["jquery","underscore","remote/config","discovery/views/IframeUnit"],function(a,b,c,d){"use strict";var e=/(%|px)$/,f=function(a){if("auto"===a)return a;var b=(""+a).match(e);return a=parseFloat(a,10)||0,b?a+b[1]:a},g=d.extend({className:"iab-ad__wrapper",templateName:"iabAd",getIframeUrl:function(){return c.discovery.iabDisplayUrl||""},serializeData:function(){var a=this.getIframeUrl();return{iframeUrl:a}},handleMessage:function(a){switch(a.eventName){case"iframeLoaded":this.initAd();break;case"ready":this.cancelTimeout(),this.handleReady();break;case"resize":this.handleResize(a)}},handleResize:function(a){var b=f(a.width),c=f(a.height);b&&this._currentWidth!==b&&(this._currentWidth=b,this.$("[data-role=iab-ad]").css("width",b)),c&&this._currentHeight!==c&&(this._currentHeight=c,this.frame.$el.css("height",c))},initAd:function(){var a=this.model.get("height");this.handleResize({width:this.model.get("width"),height:a}),this._postMessage({method:"initAd",content:this.model.get("content"),autoResize:"auto"===a})}},{cleanStyleValues:f});return g}),define("discovery/views/ImageUnit",["underscore","loglevel","discovery/views/BaseUnit","common/templates"],function(a,b,c,d){"use strict";var e=c.extend({className:"style-variant-default",events:{"click a":"handleLinkClick"},handleLinkClick:function(){this.model.fireClickPixels()},serializeData:function(){var a=this.model;return{title:a.get("title"),summary:a.get("summary"),targetUrl:a.get("target_url"),brandName:a.get("brand_name"),thumbnailUrl:a.get("thumbnail_url"),privacyClickUrl:a.get("privacy_click_url"),privacyImageUrl:a.get("privacy_image_url")}},render:function(){return this.$el.html(d.render("imageAd",this.serializeData())),this.handleReady(),this}});return e}),define("discovery/views/VastUnit",["jquery","underscore","stance","loglevel","remote/config","discovery/exceptions","discovery/helpers","discovery/views/IframeUnit"],function(a,b,c,d,e,f,g,h){"use strict";var i=2e3,j=1e4,k=h.extend({events:{"mouseenter [data-role=iframe-wrapper]":"turnSoundOn","mouseleave [data-role=iframe-wrapper]":"turnSoundOff"},templateName:"videoAd",supportedSizes:[{width:320,height:180},{width:480,height:352},{width:640,height:360}],initialize:function(){this.listenTo(this,{"view:50in":this.startAd,"view:50out":this.pauseAd}),this.hasFlash()||h.prototype._rejectReadyPromise.call(this,"Flash is not available"),h.prototype.initialize.apply(this,arguments)},hasFlash:function(){var a=!1;try{a=Boolean(new ActiveXObject("ShockwaveFlash.ShockwaveFlash"))}catch(b){a="undefined"!=typeof navigator.mimeTypes["application/x-shockwave-flash"]}return a},getIframeUrl:function(){return e.discovery.videoPlayerUrl||""},handleAlmostReady:function(){var a=c({el:this.el});this.listenToOnce(a,"enter",function(){this.model.reportView(),this.startAd()})},handleMessage:function(a){switch(a.eventName){case"iframeLoaded":this.initVideoPlayer();break;case"ready":this.cancelTimeout(),this.handleAlmostReady(),d.debug(this.model.toLogString()+': Got "ready" event from '+(a.isVast?"VAST":"VPAID")+" player.");break;case"play":this.cancelTimeout(),this.handleReady(),this.hasStarted=!0,this.model.reportPlayStart();break;case"error":this.handleRenderError("Cannot play video.");break;case"ended":this.hasStarted&&this.model.reportPlayEnd()}},_rejectReadyPromise:function(a){this.cancelTimeout();var b=this.model.toLogString();if(d.debug(b+": "+a),!this._rejectTimeout){var c=this;d.debug(b+": Waiting "+i+"ms before removing player from DOM."),c._rejectTimeout=window.setTimeout(function(){h.prototype._rejectReadyPromise.call(c,a)},i)}},getSize:function(){var a=Math.min(b.last(this.supportedSizes).width,this.getBodyWidth()),c=a/1.6;return{width:a,height:c}},serializeData:function(){var a=this.getIframeUrl(),c=this.getSize();if(!a)throw new f.ValidationError("Video player url is not specified");return{iframeUrl:b.template(a)({width:c.width,height:c.height}),height:c.height,width:c.width}},getBodyWidth:function(){return a("body").width()},initVideoPlayer:function(){var a=this.getSize();this._postMessage({method:"initPlayer",url:this.model.get("media_url"),width:a.width,height:a.height})},startAd:function(){d.debug(this.model.toLogString()+": Starting to play."),this.hasStarted||this.startTimeout(j,"Player took too long to play video."),this._postMessage({method:"playVideo"})},pauseAd:function(){this._postMessage({method:"pauseVideo"})},turnSoundOn:function(){this._postMessage({method:"turnSoundOn"})},turnSoundOff:function(){this._postMessage({method:"turnSoundOff"})}});return k}),define("discovery/views/VideoIframeUnit",["jquery","underscore","backbone","loglevel","core/bus","core/analytics/jester","core/strings","common/templates","discovery/views/IframeUnit"],function(a,b,c,d,e,f,g,h,i){"use strict";var j="ready",k="noOffer",l={ready:j,noOffer:k,"viroolWidget.playerReady":j,"viroolWidget.noOffers":k,"viroolWidget.offerConfigLoaded":j,vrl_not_found:k,ad_ready:j,ad_failed:k},m=i.extend({templateName:"videoAd",getIframeUrl:function(){return this.model.get("media_url")},serializeData:function(){var c,d=this.getIframeUrl(),e=this.model.get("width")||640;return e=Math.min(e,a("body").width()),c=e/1.6,{iframeUrl:b.template(d)({width:e,height:c}),height:c,width:"100%",title:this.model.get("title"),summary:this.model.get("summary"),targetUrl:this.model.get("target_url"),brandName:this.model.get("brand_name"),brandImageUrl:this.model.get("brand_image_url")}},handleMessage:function(a){try{a=JSON.parse(a).event}catch(b){}switch(l[a]){case j:this.cancelTimeout(),this.handleReady();break;case k:this.handleNoOfferError("No offer from the provider")}}});return m}),define("discovery/views/links/TwoColumn",["jquery","underscore","discovery/helpers"],function(a,b,c){"use strict";var d=function(b,c){this.modelIds=b||[],this.$elements=a(c||[])};b.extend(d.prototype,{height:function(){var c=this;c.heights=[];var d=a(c.$elements),e=d.first().offset().top,f=function(){var a=d.last();return a.offset().top+a.height()}(),g=f-e,h=0;return b.each(d,function(b){var d=a(b).height();c.heights.push(d),h+=d}),this.interstice=(g-h)/(d.length-1),g}});var e=function(){this.divideIntoColumns=function(){var a=this,b=a.subviews[0];a.left=new d,a.right=new d;var c=0;b.collection.each(function(d,e){var f=c++%2===0?"left":"right";a[f].modelIds.push(d.id),Array.prototype.push.call(a[f].$elements,b.$elements[e])})},this.removeOneFromColumn=function(a,c){var d,e=b.chain(a.modelIds).map(function(b,c){return[b,a.heights[c]]}).sortBy(function(a){return-1*a[1]}).find(function(a){return a[1]<=c}).value()[0],f=this.subviews[0].collection,g=f.models,h=f.get(e),i=g.indexOf(h),j=[],k=[],l=[k,j],m=g.length;for(d=0;m>d;d++)l[d%2].push(g[d]);var n=l[i%2];n.splice(b.indexOf(n,h),1),g=[];var o=(i+1)%2;for(d=0;m-1>d;d++)g.push(l[(d+o)%2].shift());f.reset(g)},this.balanceColumns=function(){var a=this.subviews[0],d=a.collection,e={};d.each(function(b,c){e[c]=a.$elements[c]});var f=c.balancedPartition(e);f=b.sortBy(f,"length");var g=f[1],h=f[0],i=d.models,j=new Array(i.length);b.each(g,function(a,b){j[2*b]=i[b]}),b.each(h,function(a,b){j[2*b+1]=i[b]}),d.reset(i)},this.shortenColumn=function(a,b){var c=this.subviews[0].collection;c.length%2!==0&&a===this.left?this.removeOneFromColumn(a,this.fudge*b):this.balanceColumns()}},f=function(){this.divideIntoColumns=function(){var a=this,b=a.subviews,c=b[0],e=b[1],f=c.collection.model.prototype.idAttribute;a.left=new d(c.collection.pluck(f),c.$elements);var g=e.collection.model.prototype.idAttribute;a.right=new d(e.collection.pluck(g),e.$elements)},this.shortenColumn=function(a,c){for(var d=a===this.left?this.subviews[0]:this.subviews[1],e=a===this.left?this.right:this.left,f=e,g=c/f.$elements.length,h=d.collection,i=b.chain(a.modelIds).map(function(b,c){return[b,a.heights[c]]}).sortBy(function(a){return a[1]}).value(),j=[],k=0,l=c,m=g;i.length;){var n=i.pop(),o=n[0],p=n[1],q=p+a.interstice;if(k+q>c&&(f=a),l=Math.abs(c-(k+q)),m=l/f.$elements.length,!(m>=g)){g=m;var r=a.modelIds.indexOf(o);a.modelIds.splice(r,1),Array.prototype.splice.call(a.$elements,r,1),k+=q,j.push(o)}}h.remove(j)}},g=function(a){this.fudge=a.fudge,this.subviews=a.views.slice(0,2),1===this.subviews.length?e.call(this):f.call(this)};return b.extend(g.prototype,{ascendingByHeight:function(){var a=this.left,c=this.right,d=[[a,a.height()],[c,c.height()]];return b.sortBy(d,function(a){return a[1]})},evenColumns:function(a){var c=this.ascendingByHeight(),d=c[0][0],e=c[0][1],f=c[1][0],g=c[1][1];if(e!==g){var h=g-e,i=this.fudge*h,j=b.find(f.heights,function(a){return a+f.interstice<i});return!a&&j?(this.shortenColumn(f,h),this.divideIntoColumns(),this.evenColumns("do not recurse again")):void this.increaseMargins(d,h)}},increaseMargins:function(c,d){var e=c.$elements.length;if(!(2>e)){var f=d/e;b.each(c.$elements,function(b){var c=a(b),d=parseInt(c.css("margin-bottom"),10),e=d+f;c.css("margin-bottom",e+"px")});var g=c===this.left?this.right:this.left,h=c===this.right?"left":"right";g.$elements.css("clear",h)}},render:function(){return this.divideIntoColumns(),this.evenColumns(),this}}),g}),define("discovery/views/links/BaseView",["underscore","backbone","when","common/templates"],function(a,b,c,d){"use strict";return b.View.extend({initialize:function(){this._isReady=c.defer()
},isReady:function(){return this._isReady.promise},getTemplateContext:function(){return this.appContext||(this.appContext=this.model.app.toJSON()),{variant:this.appContext}},template:function(a,b){return b=b||this.templateName,d.render(b,a)},_rejectReadyPromise:function(a){this._isReady.reject(a)},handleReady:function(){this._isReady.resolve()}})}),define("discovery/views/links/BaseCollectionView",["underscore","jquery","stance","common/utils","discovery/helpers","discovery/views/links/BaseView"],function(a,b,c,d,e,f){"use strict";var g=f.extend({events:{"click [data-redirect]":"handleClick"},templateName:"discoveryCollection",handleClick:function(a){this.swapHref(a.currentTarget)},swapHref:function(b){b.setAttribute("data-href",b.getAttribute("href")),b.setAttribute("href",b.getAttribute("data-redirect")),a.delay(function(){b.setAttribute("href",b.getAttribute("data-href"))},100)},initialize:function(a){this.elementsSelector="li.discovery-post",this.$elements=this.$el.find(this.elementsSelector),this.initContext=a.context;var b=this.collection;this.listenTo(b,{remove:this.remove,reset:this.render}),this.visibilityTrackers={},this.queueViewEvents()},queueViewEvents:function(){if(this.model.app.get("promotedEnabled")){var d=function(){return b(this.el).height()/2};a.each(this.visibilityTrackers,function(a,b){a&&(this.collection.get(b)||(this.stopListening(a),this.visibilityTrackers[b]=null))},this),a.each(this.$elements,function(b){var e=b.getAttribute("data-id");if(!this.visibilityTrackers[e]){var f=this.collection.get(e);if(f){var g=c({el:b,timer:null,topEdgeOffset:d,bottomEdgeOffset:d});this.visibilityTrackers[e]=g;var h=a.bind(function(){this.reportIABView(e),this.stopListening(g)},this);this.listenTo(g,{enter:function(){g.timer=a.delay(h,1e3)},exit:function(){clearTimeout(g.timer)}})}}},this)}},reportIABView:function(a){var b=this.collection.get(a),c=b.get("tracking_pixels_onview")||[];d.loadPixels(c)},loadOnLoadPixels:function(){this.collection.each(function(a){var b=a.get("tracking_pixels_onload")||[];d.loadPixels(b)},this)},truncate:function(){var c=this.$el.find(".line-truncate");a.each(c,function(a){var c=b(a);e.lineTruncate(c,{lines:parseInt(c.attr("data-line-truncate"),10),ellipsis:!0})})},getTemplateContext:function(){var b=f.prototype.getTemplateContext.call(this);a.extend(b,this.initContext),b.collection=this.collection.toJSON();var c=this.collection.at(0);if(c){var d=c.has("id")?"organic-":"promoted-",e=c.idAttribute;a.each(b.collection,function(a){a.advertisement_id=a[e],a.domIdSuffix=a[e],a.domIdSuffix=d+a.domIdSuffix})}return b},render:function(){var a=this.getTemplateContext();return this.$el.html(this.template(a)),this.$elements=this.$el.find(this.elementsSelector),this.truncate(),this.loadOnLoadPixels(),this.queueViewEvents(),this},remove:function(c,d,e){if(0===arguments.length)return f.prototype.remove.call(this);var g=a.toArray(this.$elements),h=g.splice(e.index,1)[0];return b(h).remove(),this.$elements=b(g),this.queueViewEvents(),this}});return g}),define("discovery/views/links/MainView",["jquery","underscore","when","stance","core/strings","core/analytics/jester","discovery/helpers","discovery/views/links/TwoColumn","discovery/views/links/BaseView","discovery/views/links/BaseCollectionView"],function(a,b,c,d,e,f,g,h,i,j){"use strict";var k=440,l=i.extend({templateName:"discoveryMain",topEdgeOffset:0,bottomEdgeOffset:1/0,events:{"click [data-action=discovery-help]":function(a){a.preventDefault(),this.model.app.set("help",!0)},"click [data-action=discovery-help-close]":function(a){a.preventDefault(),this.model.app.set("help",!1)}},toggleHelp:function(){var a=this;a.$el.find("#discovery-note").toggle()},rerenderHelp:function(){var a=this.$el.find("#discovery-note");a.length&&a.html(this.template(this.getTemplateContext(),"discoveryNote"))},initialize:function(){i.prototype.initialize.apply(this,arguments);var a=this.model.app;this.listenTo(a,{"change:help":this.toggleHelp}),this.listenTo(a.session,"change",this.rerenderHelp),this.$el.css({display:"block",width:"100%"}),b.bindAll(this,"reportIfVisible")},createSections:function(){var a=this.model,c=this.model.app,d=a.get("sectionNames"),e=a.get("sectionIds");return b.map(a.collections,function(b,f){var g;return b===a.threads?g="organic":b===a.sponsoredLinks&&(g="promoted"),{id:e[f],className:d[f],showThumbnailsInRows:"promoted"===g&&c.getThumbnailLinksMobile("Promoted"),collection:b,type:g}})},getTemplateContext:function(){var a=this.model.app,b=this.createSections();return{id:a.get("innerContainerId"),sections:b,styleVariant:a.get("styleVariant"),forum:a.get("sourceForum"),discoverySettingsUrl:a.get("promotedEnabled")&&a.get("discoverySettingsUrl"),session:a.session.toJSON(),thumbnailsEnabled:this.model.areThumbnailsEnabled()}},render:function(){var a=this;a.model.validateData(),a.model.app.get("trackAdVisibility")&&a.trackVisibility(),a.renderViews(),a.handleReady()},renderViews:function(){var c=this.getTemplateContext(),d=this.model.app,e=this;this.$el.html(this.template(c));var f=b.map(c.sections,function(b){var c=!!d.get("max"+b.collection.name+"ThumbnailLinks");return new j({model:e.model,collection:b.collection,el:a("#"+b.id+"> [data-role=discovery-posts]"),context:{thumbnailsEnabled:c}})});d.get("maxPromotedThumbnailLinks")?this.$el.find("#"+d.get("innerContainerId")).addClass("doublethumbnails"):2===f.length&&this.$el.find("#"+d.get("innerContainerId")).addClass("doublesection");var g=this.$el.width();this.$el.width(g-20),b.invoke(f,"render"),this.$el.width("100%"),this.views=f,this.evenColumns(),d.get("promotedEnabled")&&e.model.sponsoredLinks.length&&e.model.report({event:"activity.load_advertisement",verb:"load"})},remove:function(a){var b;return a&&a.cloneContainer&&(b=this.el.cloneNode(!1),this.$el.attr("id",""),this.$el.after(b)),i.prototype.remove.apply(this,arguments)},getWidth:function(){return this.$el.width()},evenColumns:function(){if(!(this.model.areThumbnailsEnabled()||this.getWidth()<k)){var a=new h({views:this.views,fudge:1.2});a.render()}},reportIfVisible:function(){this.visibilityTracker&&this.visibilityTracker.isVisible()&&this.model.sponsoredLinks&&this.model.sponsoredLinks.length&&(this.stopListening(this.visibilityTracker),this.visibilityTracker=null,this.model.report({verb:"view"}))},trackVisibility:function(){var a=this.model.app;this.debouncedReportIfVisible=b.debounce(this.reportIfVisible,a.get("seenByUserThresholdTime")),this.visibilityTracker=d(this),this.listenTo(this.visibilityTracker,"enter",this.debouncedReportIfVisible)}});return l}),define("discovery/views/Placement",["jquery","underscore","backbone","when","core/bus","discovery/exceptions","discovery/views/HostUnit","discovery/views/IABDisplayUnit","discovery/views/ImageUnit","discovery/views/VastUnit","discovery/views/VideoIframeUnit","discovery/views/links/MainView"],function(a,b,c,d,e,f,g,h,i,j,k,l){"use strict";var m=c.View.extend({className:"post-list",LAYOUT_TO_CLASS:{on_host:g,iab_display:h,iframe:k,image_target:i,video_iframe:k,video_vast:j,links:l},initialize:function(a){a=a||{},this.placement=a.placement,this._enabled=!0,this._collapse()},setRequestBin:function(a){this._bin=a},_inject:function(a){e.frame.sendHostMessage("ads.inject",{placement:this.placement,html:a})},tryAd:function(a){this._unsetAd();var c=a.get("layout"),e=this.LAYOUT_TO_CLASS[c];if(!e)return d.reject(new f.ValidationError('Specified ad layout "'+c+'" was not found.'));a.set("placement",this.placement),this._adView=new e({model:a}),this.$el.html(this._adView.el),this._adView.render();var g=b.result(this._adView,"injectable");return g&&this._inject(g),this._adView.isReady().then(b.bind(this._expand,this)),this._adView.isReady()},getCurrentUnit:function(){return this._adView},disable:function(){this._enabled=!1,this._collapse()},enable:function(){this._enabled=!0,this._expand()},remove:function(){return this._unsetAd(),c.View.prototype.remove.apply(this,arguments)},_unsetAd:function(){this._adView&&(this._adView.model.unset("placement"),this._adView.remove(),this._adView=null)},_expand:function(){this._enabled&&this.$el.css({height:"auto",visibility:"visible"})},_collapse:function(){this.$el.css({height:0,visibility:"hidden"})}});return m}),define("templates/discovery",["handlebars"],function(a){return a.template({1:function(a,b,c,d){var e,f='<div class="follow-btn-wrap">\n';return e=b["if"].call(a,null!=(e=null!=a?a.user:a)?e.isSession:e,{name:"if",hash:{},fn:this.program(2,d),inverse:this.program(5,d),data:d}),null!=e&&(f+=e),f+"</div>\n"},2:function(a,b,c,d){var e,f="";return e=b["if"].call(a,null!=(e=null!=a?a.user:a)?e.isEditable:e,{name:"if",hash:{},fn:this.program(3,d),inverse:this.noop,data:d}),null!=e&&(f+=e),f+"\n"},3:function(a,b,c,d){var e,f=this.lambda,g=this.escapeExpression;return'<a href="'+g(f(null!=(e=null!=a?a.user:a)?e.profileUrl:e,a))+'" data-action="edit-profile" target="_blank" class="btn follow-btn edit-profile">'+g(b.gettext.call(a,"Edit profile",{name:"gettext",hash:{},data:d}))+"</a>\n"},5:function(a,b,c,d){var e,f="";return e=b["if"].call(a,null!=(e=null!=a?a.user:a)?e.isPrivate:e,{name:"if",hash:{},fn:this.program(6,d),inverse:this.program(8,d),data:d}),null!=e&&(f+=e),f},6:function(a,b,c,d){var e=this.escapeExpression;return'<span class="btn follow-btn private">\n<i aria-hidden="true" class="icon-lock"></i>\n<span class="btn-text">'+e(b.gettext.call(a,"Private",{name:"gettext",hash:{},data:d}))+"</span>\n</span>\n"},8:function(a,b,c,d){var e,f=this.lambda,g=this.escapeExpression,h='<a href="'+g(f(null!=(e=null!=a?a.user:a)?e.profileUrl:e,a))+'" class="btn follow-btn ';return e=b["if"].call(a,null!=(e=null!=a?a.user:a)?e.isFollowing:e,{name:"if",hash:{},fn:this.program(9,d),inverse:this.noop,data:d}),null!=e&&(h+=e),h+'" data-action="follow-user" data-user="'+g(f(null!=(e=null!=a?a.user:a)?e.id:e,a))+'">\n<span class="btn-text following-text">'+g(b.gettext.call(a,"Following",{name:"gettext",hash:{},data:d}))+'</span>\n<span class="btn-text follow-text">'+g(b.gettext.call(a,"Follow",{name:"gettext",hash:{},data:d}))+'</span>\n<i aria-hidden="true" class="icon-plus"></i> \n<i aria-hidden="true" class="icon-checkmark"></i>\n</a>\n'},9:function(){return"following"},11:function(a,b,c,d,e){var f,g="";return f=b.each.call(a,null!=a?a.collection:a,{name:"each",hash:{},fn:this.program(12,d,e),inverse:this.noop,data:d}),null!=f&&(g+=f),g},12:function(a,b,c,d,e){var f,g=this.lambda,h=this.escapeExpression,i='<li class="discovery-post';return f=b["if"].call(a,null!=e[1]?e[1].thumbnailsEnabled:e[1],{name:"if",hash:{},fn:this.program(13,d,e),inverse:this.noop,data:d}),null!=f&&(i+=f),i+=" post-"+h(g(d&&d.index,a))+'" id="discovery-link-'+h(g(null!=a?a.domIdSuffix:a,a))+'" data-id="'+h(g(null!=a?a.advertisement_id:a,a))+'">\n<a ',f=this.invokePartial(c.linkAttributes,"","linkAttributes",a,void 0,b,c,d),null!=f&&(i+=f),i+=' class="publisher-anchor-color">\n',f=b["if"].call(a,null!=e[1]?e[1].thumbnailsEnabled:e[1],{name:"if",hash:{},fn:this.program(15,d,e),inverse:this.noop,data:d}),null!=f&&(i+=f),i+='\n<header class="discovery-post-header">\n<h3 title="'+h(g(null!=a?a.title:a,a))+'">\n<span data-role="discovery-thread-title" class="title line-truncate" data-line-truncate="'+h(g(null!=(f=null!=e[1]?e[1].variant:e[1])?f.numLinesHeadline:f,a))+'">\n'+h(b.html.call(a,null!=a?a.title:a,{name:"html",hash:{},data:d}))+"\n</span>\n\n",f=b["if"].call(a,null!=(f=null!=e[1]?e[1].variant:e[1])?f.inlineMeta:f,{name:"if",hash:{},fn:this.program(17,d,e),inverse:this.noop,data:d}),null!=f&&(i+=f),i+="\n</h3>\n\n",f=b.unless.call(a,null!=(f=null!=e[1]?e[1].variant:e[1])?f.inlineMeta:f,{name:"unless",hash:{},fn:this.program(25,d,e),inverse:this.noop,data:d}),null!=f&&(i+=f),i+="</header>\n\n",f=b.if_all.call(a,null!=(f=null!=e[1]?e[1].variant:e[1])?f.contentPreviews:f,null!=a?a.preview:a,{name:"if_all",hash:{},fn:this.program(30,d,e),inverse:this.noop,data:d}),null!=f&&(i+=f),i+"</a>\n</li>\n"},13:function(){return" hasthumbnail"},15:function(a){var b=this.lambda,c=this.escapeExpression;return'<div class="thumbnail"\nstyle="background-image: url('+c(b(null!=a?a.thumbnailUrl:a,a))+');">\n</div>\n'},17:function(a,b,c,d){var e,f="";return e=b["if"].call(a,b.gt.call(a,null!=a?a.posts:a,0,{name:"gt",hash:{},data:d}),{name:"if",hash:{},fn:this.program(18,d),inverse:this.program(20,d),data:d}),null!=e&&(f+=e),e=b["if"].call(a,null!=a?a.brand:a,{name:"if",hash:{},fn:this.program(23,d),inverse:this.noop,data:d}),null!=e&&(f+=e),f},18:function(a,b,c,d){var e,f='<span class="inline-meta">\n';return e=this.invokePartial(c.discoveryPostCount,"","discoveryPostCount",a,void 0,b,c,d),null!=e&&(f+=e),f+"</span>\n"},20:function(a,b,c,d){var e,f="";return e=b["if"].call(a,null!=a?a.createdAgo:a,{name:"if",hash:{},fn:this.program(21,d),inverse:this.noop,data:d}),null!=e&&(f+=e),f},21:function(a){var b=this.lambda,c=this.escapeExpression;return'<span class="inline-meta">'+c(b(null!=a?a.createdAgo:a,a))+"</span>\n"},23:function(a){var b=this.lambda,c=this.escapeExpression;return'<span class="inline-meta">\n'+c(b(null!=a?a.brand:a,a))+"\n</span>\n"},25:function(a,b,c,d){var e,f='<ul class="meta">\n';return e=b["if"].call(a,b.gt.call(a,null!=a?a.posts:a,0,{name:"gt",hash:{},data:d}),{name:"if",hash:{},fn:this.program(26,d),inverse:this.noop,data:d}),null!=e&&(f+=e),e=b["if"].call(a,null!=a?a.createdAgo:a,{name:"if",hash:{},fn:this.program(28,d),inverse:this.noop,data:d}),null!=e&&(f+=e),f+"</ul>\n"},26:function(a,b,c,d){var e,f='<li class="comments">\n';return e=this.invokePartial(c.discoveryPostCount,"","discoveryPostCount",a,void 0,b,c,d),null!=e&&(f+=e),f+"</li>\n"},28:function(a){var b=this.lambda,c=this.escapeExpression;return'<li class="time">'+c(b(null!=a?a.createdAgo:a,a))+"</li>\n"},30:function(a,b,c,d){var e,f="";return e=this.invokePartial(c.discoveryContentPreview,"","discoveryContentPreview",a,void 0,b,c,d),null!=e&&(f+=e),f},32:function(a,b,c,d){var e,f=this.lambda,g=this.escapeExpression,h='href="'+g(f(null!=a?a.redirectUrl:a,a))+'" ';return e=b["if"].call(a,null!=a?a.brand:a,{name:"if",hash:{},fn:this.program(33,d),inverse:this.noop,data:d}),null!=e&&(h+=e),h+"\n"},33:function(){return'target="_blank" rel="nofollow norewrite"'},35:function(a,b,c,d){var e,f=this.lambda,g=this.escapeExpression,h="<a ";return e=this.invokePartial(c.linkAttributes,"","linkAttributes",a,void 0,b,c,d),null!=e&&(h+=e),h+' class="top-comment" data-role="discovery-top-comment">\n<img data-src="'+g(f(null!=(e=null!=(e=null!=(e=null!=a?a.preview:a)?e.author:e)?e.avatar:e)?e.cache:e,a))+'" alt="'+g(b.gettext.call(a,"Avatar",{name:"gettext",hash:{},data:d}))+'" data-role="discovery-avatar">\n<p><span class="user" data-role="discovery-top-comment-author">'+g(f(null!=(e=null!=(e=null!=a?a.preview:a)?e.author:e)?e.name:e,a))+'</span> &#8212; <span data-role="discovery-top-comment-snippet" class="line-truncate" data-line-truncate="3">'+g(f(null!=(e=null!=a?a.preview:a)?e.plaintext:e,a))+"</span></p>\n</a>\n"},37:function(a,b,c,d){var e,f="";return e=b["if"].call(a,b.eq.call(a,null!=a?a.posts:a,1,{name:"eq",hash:{},data:d}),{name:"if",hash:{},fn:this.program(38,d),inverse:this.program(40,d),data:d}),null!=e&&(f+=e),f},38:function(a,b,c,d){var e=this.escapeExpression;return e(b.gettext.call(a,"1 comment",{name:"gettext",hash:{},data:d}))+"\n"},40:function(a,b,c,d){var e=this.escapeExpression;return e(b.gettext.call(a,"%(numPosts)s comments",{name:"gettext",hash:{numPosts:null!=a?a.posts:a},data:d}))+"\n"},42:function(a,b,c,d,e){var f,g=this.lambda,h=this.escapeExpression,i='<div id="'+h(g(null!=a?a.id:a,a))+'" class="discovery-main';return f=b["if"].call(a,null!=a?a.thumbnailsEnabled:a,{name:"if",hash:{},fn:this.program(43,d,e),inverse:this.noop,data:d}),null!=f&&(i+=f),i+=" ",f=b["if"].call(a,null!=a?a.styleVariant:a,{name:"if",hash:{},fn:this.program(45,d,e),inverse:this.noop,data:d}),null!=f&&(i+=f),i+='">\n<div id="discovery-note" class="discovery-note">\n',f=this.invokePartial(c.discoveryNote,"","discoveryNote",a,void 0,b,c,d),null!=f&&(i+=f),i+='</div>\n\n<div class="discovery-options">\n<button class="discovery-help" data-action="discovery-help">\n'+h(b.gettext.call(a,"What's this?",{name:"gettext",hash:{},data:d}))+"\n</button>\n</div>\n\n",f=b.each.call(a,null!=a?a.sections:a,{name:"each",hash:{},fn:this.program(47,d,e),inverse:this.noop,data:d}),null!=f&&(i+=f),i+"\n</div>\n"},43:function(){return" discovery-thumbnails"},45:function(a){var b=this.lambda,c=this.escapeExpression;return"style-variant-"+c(b(null!=a?a.styleVariant:a,a))},47:function(a,b,c,d,e){var f,g=this.lambda,h=this.escapeExpression,i='<section id="'+h(g(null!=a?a.id:a,a))+'" class="'+h(g(null!=a?a.className:a,a))+" discovery-col-"+h(g(d&&d.index,a))+" ";return f=b["if"].call(a,null!=a?a.showThumbnailsInRows:a,{name:"if",hash:{},fn:this.program(48,d,e),inverse:this.noop,data:d}),null!=f&&(i+=f),i+='" >\n<header class="discovery-col-header">\n\n',f=b["if"].call(a,b.eq.call(a,null!=a?a.type:a,"organic",{name:"eq",hash:{},data:d}),{name:"if",hash:{},fn:this.program(50,d,e),inverse:this.noop,data:d}),null!=f&&(i+=f),i+="\n",f=b["if"].call(a,b.eq.call(a,null!=a?a.type:a,"promoted",{name:"eq",hash:{},data:d}),{name:"if",hash:{},fn:this.program(52,d,e),inverse:this.noop,data:d}),null!=f&&(i+=f),i+'\n</header>\n<ul class="discovery-posts" data-role="discovery-posts">\n</ul>\n</section>\n'},48:function(){return" thumbnails-rows"},50:function(a,b,c,d,e){var f=this.escapeExpression;return"<h2>"+f(b.gettext.call(a,"Also on %(forumName)s",{name:"gettext",hash:{forumName:b.getPartial.call(a,"forumName",null!=e[2]?e[2].forum:e[2],{name:"getPartial",hash:{},data:d})},data:d}))+"</h2>\n"},52:function(a,b,c,d){var e=this.escapeExpression;return"<h2>"+e(b.gettext.call(a,"Around The Web",{name:"gettext",hash:{},data:d}))+"</h2>\n"},54:function(a,b,c,d){var e=this.escapeExpression;return'<a href="https://help.disqus.com/customer/portal/articles/666278-introducing-promoted-discovery-and-f-a-q-"\ntarget="_blank">'+e(b.gettext.call(a,"Learn more",{name:"gettext",hash:{},data:d}))+"</a>\n"},56:function(a,b,c,d){var e=this.escapeExpression;return'<a href="https://www.surveymonkey.com/s/GHK872T" target="_blank">\n'+e(b.gettext.call(a,"give us feedback",{name:"gettext",hash:{},data:d}))+"</a>"},58:function(a){var b=this.lambda,c=this.escapeExpression;return"<strong>"+c(b(null!=a?a.name:a,a))+"</strong>\n"},60:function(a,b,c,d){var e,f=this.escapeExpression,g='<div class="alert">\n<button class="close" data-action="discovery-help-close" title="'+f(b.gettext.call(a,"Close this box",{name:"gettext",hash:{},data:d}))+'">×</button>\n'+f(b.gettext.call(a,"Disqus helps you find new and interesting content, discussions and products. Some sponsors and ecommerce sites may pay us for these recommendations and links. %(learnMore)s or %(feedback)s.",{name:"gettext",hash:{feedback:b.getPartial.call(a,"feedback",{name:"getPartial",hash:{},data:d}),learnMore:b.getPartial.call(a,"learnMore",{name:"getPartial",hash:{},data:d})},data:d}))+"\n";return e=b.if_all.call(a,null!=(e=null!=(e=null!=a?a.session:a)?e.thread:e)?e.canModerate:e,null!=a?a.discoverySettingsUrl:a,{name:"if_all",hash:{},fn:this.program(61,d),inverse:this.noop,data:d}),null!=e&&(g+=e),g+"</div>\n"},61:function(a,b,c,d){var e,f=this.lambda,g=this.escapeExpression;return'<br/>\n<a href="'+g(f(null!=a?a.discoverySettingsUrl:a,a))+'" target="_blank" class="btn">'+g(b.gettext.call(a,"Change %(Discovery)s settings for %(forumName)s",{name:"gettext",hash:{forumName:null!=(e=null!=a?a.forum:a)?e.name:e,Discovery:"Discovery"},data:d}))+"</a>\n"},63:function(a,b,c,d){var e,f=this.escapeExpression,g='<div class="generic-ad__block">\n<div class="icon__block text-subheading">\n<span class="icon-trophy icon"></span> '+f(b.gettext.call(a,"Sponsored",{name:"gettext",hash:{},data:d}))+'\n</div>\n<div data-role="iframe-wrapper" class="iframe-ad__wrapper">\n<iframe class="iframe-ad" frameborder="0" allowfullscreen overflow="hidden" scrolling="no" data-role="iframe-ad"></iframe>\n</div>\n<div class="sponsored">\n';return e=b.if_all.call(a,null!=a?a.targetUrl:a,null!=a?a.brandName:a,null!=a?a.summary:a,{name:"if_all",hash:{},fn:this.program(64,d),inverse:this.noop,data:d}),null!=e&&(g+=e),g+"</div>\n</div>\n"},64:function(a,b,c,d){var e,f=this.lambda,g=this.escapeExpression,h='<div class="footer clickable-footer ';return e=b["if"].call(a,null!=a?a.brandImageUrl:a,{name:"if",hash:{},fn:this.program(65,d),inverse:this.noop,data:d}),null!=e&&(h+=e),h+='">\n',e=b["if"].call(a,null!=a?a.brandImageUrl:a,{name:"if",hash:{},fn:this.program(67,d),inverse:this.noop,data:d}),null!=e&&(h+=e),h+'<div class="brand-content">\n<a href="'+g(f(null!=a?a.targetUrl:a,a))+'" target="_blank" class="text-default">\n<small class="text-subheading">\n'+g(b.gettext.call(a,"Sponsored By %(name)s",{name:"gettext",hash:{name:b.tag.call(a,"strong",{name:"tag",hash:{text:null!=a?a.brandName:a},data:d})},data:d}))+'\n</small>\n<p class="brand-summary">\n'+g(f(null!=a?a.summary:a,a))+'\n</p>\n</a>\n</div>\n<div class="learn-more">\n<a href="'+g(f(null!=a?a.targetUrl:a,a))+'" target="_blank" class="learn-more-btn" data-role="learn-more">\n'+g(b.gettext.call(a,"Learn More",{name:"gettext",hash:{},data:d}))+' <i class="icon-arrow-forward"></i>\n</a>\n</div>\n</div>\n'},65:function(){return"has-brand-logo"},67:function(a){var b=this.lambda,c=this.escapeExpression;return'<div class="brand-logo avatar">\n<a href="'+c(b(null!=a?a.targetUrl:a,a))+'" target="_blank">\n<img src="'+c(b(null!=a?a.brandImageUrl:a,a))+'" />\n</a>\n</div>\n'},69:function(a,b,c,d){var e=this.escapeExpression;return'<div data-role="iab-ad" class="iab-ad">\n<div class="icon__block text-subheading">\n<span class="icon-trophy icon"></span> '+e(b.gettext.call(a,"Sponsored",{name:"gettext",hash:{},data:d}))+'\n</div>\n<iframe width="100%" frameborder="0" allowfullscreen overflow="hidden" scrolling="no"></iframe>\n</div>\n'},71:function(a,b,c,d){var e,f=this.lambda,g=this.escapeExpression,h="";return e=b.if_all.call(a,null!=a?a.privacyClickUrl:a,null!=a?a.privacyImageUrl:a,{name:"if_all",hash:{},fn:this.program(72,d),inverse:this.noop,data:d}),null!=e&&(h+=e),h+'<a href="'+g(f(null!=a?a.targetUrl:a,a))+'" target="_blank"><img src="'+g(f(null!=a?a.thumbnailUrl:a,a))+'"></a>\n'},72:function(a,b,c,d){var e=this.lambda,f=this.escapeExpression;return'<a class="ad-dr__thumb-privacy-link" href="'+f(e(null!=a?a.privacyClickUrl:a,a))+'"><img src="'+f(e(null!=a?a.privacyImageUrl:a,a))+'" alt="'+f(b.gettext.call(a,"Privacy",{name:"gettext",hash:{},data:d}))+'" /></a>\n'},74:function(a,b,c,d){var e,f=this.escapeExpression,g=this.lambda,h='<div class="ad-dr -thumb-right clearfix">\n<div class="ad-dr__thumb">\n';return e=this.invokePartial(c.adThumbnail,"","adThumbnail",a,void 0,b,c,d),null!=e&&(h+=e),h+='</div>\n<div class="ad-dr__content">\n<div class="ad-dr__company">\n',e=b["if"].call(a,null!=a?a.brandName:a,{name:"if",hash:{},fn:this.program(75,d),inverse:this.noop,data:d}),null!=e&&(h+=e),h+='<span class="icon-trophy" aria-hidden="true"></span><span>'+f(b.gettext.call(a,"Sponsored",{name:"gettext",hash:{},data:d}))+'</span>\n</div>\n<div class="ad-dr__thumb--mobile">\n',e=this.invokePartial(c.adThumbnail,"","adThumbnail",a,void 0,b,c,d),null!=e&&(h+=e),h+'</div>\n<h2 class="ad-dr__title">\n<a class="publisher-anchor-color" href="'+f(g(null!=a?a.targetUrl:a,a))+'" target="_blank">'+f(g(null!=a?a.title:a,a))+'</a>\n</h2>\n<div class="ad-dr__message">\n'+f(g(null!=a?a.summary:a,a))+'\n</div>\n<div class="ad-dr__cta">\n<a class="btn" href="'+f(g(null!=a?a.targetUrl:a,a))+'" target="_blank">'+f(b.gettext.call(a,"Learn More",{name:"gettext",hash:{},data:d}))+"</a>\n</div>\n</div>\n</div>\n"},75:function(a){var b=this.lambda,c=this.escapeExpression;return'<a class="publisher-anchor-color" href="'+c(b(null!=a?a.targetUrl:a,a))+'" target="_blank">\n'+c(b(null!=a?a.brandName:a,a))+'\n</a><span class="bullet" aria-hidden="true">•</span>\n'},compiler:[6,">= 2.0.0-beta.1"],main:function(a,b,c,d,e){var f,g="";return f=b.partial.call(a,"followButton",{name:"partial",hash:{},fn:this.program(1,d,e),inverse:this.noop,data:d}),null!=f&&(g+=f),g+="\n",f=b.partial.call(a,"discoveryCollection",{name:"partial",hash:{},fn:this.program(11,d,e),inverse:this.noop,data:d}),null!=f&&(g+=f),g+="\n",f=b.partial.call(a,"linkAttributes",{name:"partial",hash:{},fn:this.program(32,d,e),inverse:this.noop,data:d}),null!=f&&(g+=f),g+="\n",f=b.partial.call(a,"discoveryContentPreview",{name:"partial",hash:{},fn:this.program(35,d,e),inverse:this.noop,data:d}),null!=f&&(g+=f),g+="\n",f=b.partial.call(a,"discoveryPostCount",{name:"partial",hash:{},fn:this.program(37,d,e),inverse:this.noop,data:d}),null!=f&&(g+=f),g+="\n",f=b.partial.call(a,"discoveryMain",{name:"partial",hash:{},fn:this.program(42,d,e),inverse:this.noop,data:d}),null!=f&&(g+=f),g+="\n",f=b.partial.call(a,"learnMore",{name:"partial",hash:{},fn:this.program(54,d,e),inverse:this.noop,data:d}),null!=f&&(g+=f),g+="\n",f=b.partial.call(a,"feedback",{name:"partial",hash:{},fn:this.program(56,d,e),inverse:this.noop,data:d}),null!=f&&(g+=f),g+="\n\n",f=b.partial.call(a,"forumName",{name:"partial",hash:{},fn:this.program(58,d,e),inverse:this.noop,data:d}),null!=f&&(g+=f),g+="\n\n",f=b.partial.call(a,"discoveryNote",{name:"partial",hash:{},fn:this.program(60,d,e),inverse:this.noop,data:d}),null!=f&&(g+=f),g+="\n",f=b.partial.call(a,"videoAd",{name:"partial",hash:{},fn:this.program(63,d,e),inverse:this.noop,data:d}),null!=f&&(g+=f),g+="\n",f=b.partial.call(a,"iabAd",{name:"partial",hash:{},fn:this.program(69,d,e),inverse:this.noop,data:d}),null!=f&&(g+=f),g+="\n",f=b.partial.call(a,"adThumbnail",{name:"partial",hash:{},fn:this.program(71,d,e),inverse:this.noop,data:d}),null!=f&&(g+=f),g+="\n",f=b.partial.call(a,"imageAd",{name:"partial",hash:{},fn:this.program(74,d,e),inverse:this.noop,data:d}),null!=f&&(g+=f),g},usePartial:!0,useData:!0,useDepths:!0})}),define("discovery/main",["backbone","underscore","jquery","loglevel","stance","when","core/switches","core/analytics/jester","core/utils","core/utils/storage","core/utils/urls","common/utils","common/Session","remote/config","discovery/collections","discovery/helpers","discovery/variants","discovery/exceptions","discovery/views/Placement","discovery/models/SponsoredLinkAd","templates/discovery"],function(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u){"use strict";u();var v={},w=1e4;return v.DiscoveryApp=a.Model.extend({defaults:{name:"promoted",inlineMeta:!0,contentPreviews:!1,organicEnabled:!0,promotedEnabled:!0,topPlacementEnabled:!1,redirectUrl:"http://disq.us/url",sourceThread:null,sourceForum:null,sourceThreadUrl:null,discoverySettingsUrl:null,numColumns:2,maxPerColumn:null,maxOrganicTextLinks:null,maxPromotedTextLinks:null,maxPromotedThumbnailLinks:null,maxPromotedThumbnailLinksMobile:null,innerContainerName:"discovery-main",promotedSide:"right",styleVariant:"default",sponsoredCommentStyleVariant:"default",hasHighlightedPost:!0,lineTruncationEnabled:!0,session:null,numLinesHeadline:2,requestBinOverride:null,js:null,css:null,seenByUserThresholdTime:2e3,trackAdVisibility:null,pageUrl:null,pageReferrer:null},get:function(c){return b.has(this.constructor.loggedinOverrides,c)&&this.session.isLoggedIn()?this.constructor.loggedinOverrides[c]:a.Model.prototype.get.apply(this,arguments)},initialize:function(a){var b=this;b.session=m.get(),b.topPlacement=new s({placement:"top"}),c("#placement-top").html(b.topPlacement.$el),b.listenTo(b,"change:hasHighlightedPost",function(a,c){c?b.topPlacement.disable():b.topPlacement.enable()}),b.bottomPlacement=new s({placement:"bottom"}),c("#placement-bottom").html(b.bottomPlacement.$el),b.configure(a),b.createDataCollections()},createDataCollections:function(){this.ads=new o.AdvertisementCollection;var a="Organic";this.threads=new o.RelatedThreadCollection([],{name:a,minLength:this.get("promotedEnabled")?1:2,maxLength:this.getCollectionMax(a)})},configure:function(a){a=a||{};var c=this,d=q[c.get("name")]||{};if(c.get("thumbnailsEnabled")&&b.extend(d,q.thumbnails),c.set(b.defaults(a,d)),c.has("maxPerColumn")){var e=c.get("promotedEnabled")?1:2;c.set("maxOrganicTextLinks",e*c.get("maxPerColumn")),c.set("maxPromotedTextLinks",c.get("maxPerColumn"))}else c.has("maxOrganicTextLinks")&&c.set("maxPerColumn",c.get("maxOrganicTextLinks"));c.set("innerContainerId",c.get("innerContainerName")+"-"+c.cid)},getViewportWidth:function(){return c(document).width()},getThumbnailLinksMobile:function(a){return this.getViewportWidth()<=480&&this.get("max"+a+"ThumbnailLinksMobile")},getCollectionMax:function(a){return this.getThumbnailLinksMobile(a)||this.get("max"+a+"ThumbnailLinks")||this.get("max"+a+"TextLinks")},run:function(){function a(a){return a instanceof t}function b(b){return b.any(a)}var c=this;return this.getData().always(function(){var d=c.ads.getTopAds(),e=c.ads.getBottomAds(),f=d.find(a)||e.find(a)||new t({layout:"links"},{sponsoredLinks:new o.SponsoredLinksCollection([],{maxLength:c.getCollectionMax("Promoted")}),threads:c.threads,app:c});f.hasData()&&(c.get("topPlacementEnabled")&&!b(d)&&d.push(f),b(e)||e.push(f))}).then(function(){c.topPlacement.setRequestBin(c.get("requestBin"));var a=c.ads.getTopAds();return c.chainAds(a,0)}).otherwise(p.reportError).then(function(){c.bottomPlacement.setRequestBin(c.get("requestBin"));var a=c.ads.getBottomAds();return a.length&&!a.first().get("placement")?c.bottomPlacement.tryAd(a.first()).otherwise(function(b){return p.reportError(b,a.first()),a.length>1&&!a.last().get("placement")?c.bottomPlacement.tryAd(a.last()).otherwise(function(b){p.reportError(b,a.last())}):void 0}):void 0})},getAllowedTopUnits:function(){var a=[];return this.get("hasHighlightedPost")||(this.get("adsVideoEnabled")&&a.push("video"),this.get("adsDRNativeEnabled")&&a.push("native_dr")),this.get("topPlacementEnabled")&&a.push("sponsored_links"),a},getAllowedBottomUnits:function(){return this.get("promotedEnabled")?["sponsored_links"]:[]},getDataOrganic:function(){var a={timeout:w,data:{thread:this.get("sourceThread").id},reset:!0,humanFriendlyTimestamp:!0};return this.threads.fetch(a,this.get("contentPreviews"))},getDataPromoted:function(){var a=this;a.get("preview")&&a.has("previewQueryParam")&&(a.ads.url="//tempest.services.disqus.com/preview/serve/"+a.get("previewQueryParam"));var c={timeout:w,data:{doc_width:this.getViewportWidth(),is_logged_out:this.session.isKnownToBeLoggedOut(),has_highlighted_post:this.get("hasHighlightedPost"),page_url:this.get("pageUrl"),page_referrer:this.get("pageReferrer"),forum:this.get("sourceForum").id,thread:this.get("sourceThread").id,top_placement:this.getAllowedTopUnits(),bottom_placement:this.getAllowedBottomUnits(),color_scheme:this.get("colorScheme"),typeface:this.get("typeface")},dataType:"jsonp",omitDisqusApiKey:!0,reset:!0,sponsoredLinksMaxLength:this.getCollectionMax("Promoted"),threads:this.threads,app:this},e=j.get("lp:headers");return b.isEmpty(e)||(c.data.HTTP_X_DEBUG=1,b.each(e,function(a){c.data["HTTP_X_"+a.name]=a.value})),a.has("gutterSwitch")&&(c.data.HTTP_X_DEBUG=1,c.data["HTTP_X_GUTTER_"+a.get("gutterSwitch").replace(":","__")]=1),null!==a.get("requestBinOverride")&&(c.data.HTTP_X_DEBUG=1,c.data.HTTP_X_DEBUG_BIN=a.get("requestBinOverride")),this.get("adsFixture")&&(c.data.ads_fixture=this.get("adsFixture"),c.data.top_placement=c.data.top_placement.concat(["video","native_dr"])),this.get("pdFixture")&&(c.data.pd_fixture=this.get("pdFixture")),this.ads.fetch(c).then(function(c){d.debug("Response from listPromoted:",c);var e=c.bin;if(!e)throw new r.NoBinError("No bin specified");a.set("requestBin",e);var f,g=c.extra;g&&g.service&&g.service_version&&(f=b.pick(g,"service","service_version"),h.client.set(f),a.set("service",f))})},chainAds:function(a,b){if(b>=a.length)throw new r.AdsExhaustedError("No more ads available.");var c=a.at(b),e=this;return d.debug(c.toLogString()+": Processing ad "+(b+1)+" ad out of "+a.length+" ads"),c.fetch({sourceThreadUrl:this.get("sourceThreadUrl")}).then(function(){return e.topPlacement.tryAd(c)
}).otherwise(function(d){return p.reportError(d,c),e.chainAds(a,b+1)})},getData:function(){var a=f();if(this.get("organicEnabled")){var b=this.getDataOrganic();a=a.always(function(){return b})}if(this.get("promotedEnabled")||this.get("adsVideoEnabled")||this.get("adsDRNativeEnabled")){var c=this.getDataPromoted();a=a.always(function(){return c})}return a}},{loggedinOverrides:{topPlacementEnabled:!1,promotedSide:"right"}}),v.init=function(a,c,d,e){var f=a.forum.get("settings"),h=p.generateVariantConfig(f,c,d);if(h){var i=b.extend({},h,{sourceThread:a.toJSON(),sourceForum:a.forum.toJSON(),sourceThreadUrl:a.currentUrl||document.referrer,discoverySettingsUrl:f.discoverySettingsUrl,adsDRNativeEnabled:f.adsDRNativeEnabled,adsVideoEnabled:f.adsVideoEnabled,organicEnabled:f.organicDiscoveryEnabled,topPlacementEnabled:h.topPlacementEnabled&&!e.hasHighlightedPost,hasHighlightedPost:e.hasHighlightedPost,pageUrl:e.pageUrl,pageReferrer:e.pageReferrer,colorScheme:e.colorScheme,typeface:e.typeface});if(d.preview){var j=document.createElement("a");j.href=i.sourceThreadUrl,i.previewQueryParam=j.search,i.preview=!0}var l=c.get("discoveryRequestBin");l&&(i.requestBinOverride=l),c.get("gutterSwitch")&&(i.gutterSwitch=c.get("gutterSwitch"));var m=g.isFeatureActive("list_promoted_fixtures",{domain:k.getHostName(i.sourceThreadUrl)});(d.adsFixture||d.pdFixture)&&m&&(i.adsFixture=d.adsFixture,i.pdFixture=d.pdFixture);var n=new v.DiscoveryApp(i);return n.run(),n}},v}),define("discovery.bundle",function(){});