<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Icons_Manager;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Humani_Hanner extends Elementor\Widget_Base {

    public function get_name() {
        return 'humani-banner';
    }

    public function get_title() {
        return esc_html__('Humani Banner', 'humani');
    }

    public function get_icon() {
        return 'eicon-image-rollover';
    }

    public function get_script_depends() {
        return ['humani-elementor-banner'];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_main_layout',
            [
                'label' => esc_html__('Layout', 'humani'),
            ]
        );

        $this->add_control(
            'layout_style',
            [
                'label'   => esc_html__('Layout Style', 'humani'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    '1' => esc_html__('Style 1', 'humani'),
                    '2'  => esc_html__('Style 2', 'humani'),
                ],
                'default' => '1'
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_main_image',
            [
                'label' => esc_html__('Image', 'humani'),
            ]
        );

        $this->add_control(
            'image',
            [
                'label'      => esc_html__('Choose Image', 'humani'),
                'default'    => [
                    'url' => Elementor\Utils::get_placeholder_image_src(),
                ],
                'type'       => Controls_Manager::MEDIA,
                'show_label' => false,
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'      => 'thumbnail', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
                'default'   => 'full',
                'separator' => 'none',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Content', 'humani'),
            ]
        );

        $this->add_control(
            'subtitle',
            [
                'label'       => esc_html__('Sub title', 'humani'),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__('', 'humani'),
                'label_block' => true,
                'separator'   => 'before',
            ]
        );

        $this->add_control(
            'title',
            [
                'label'       => esc_html__('Title & Description', 'humani'),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__('', 'humani'),
                'label_block' => true,
                'separator'   => 'before',
            ]
        );

        $this->add_control(
            'description',
            [
                'label'      => esc_html__('Description', 'humani'),
                'type'       => Controls_Manager::TEXTAREA,
                'separator'  => 'none',
                'rows'       => 5,
                'show_label' => false,
            ]
        );

        $this->add_control(
            'button',
            [
                'label'     => esc_html__('Button Text', 'humani'),
                'type'      => Controls_Manager::TEXT,
                'default'   => esc_html__('Click Here', 'humani'),
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'link',
            [
                'label'       => esc_html__('Link', 'humani'),
                'type'        => Controls_Manager::URL,
                'dynamic'     => [
                    'active' => true,
                ],
                'placeholder' => esc_html__('https://your-link.com', 'humani'),
                'default' => [
                    'url' => '#',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_main_box',
            [
                'label' => esc_html__('Box', 'humani'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'box_alignment',
            [
                'label'        => esc_html__('Alignment', 'humani'),
                'type'         => Controls_Manager::CHOOSE,
                'options'      => [
                    'left'   => [
                        'title' => esc_html__('Left', 'humani'),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'humani'),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'  => [
                        'title' => esc_html__('Right', 'humani'),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'label_block'  => false,
                'selectors'    => [
                    '{{WRAPPER}} .banner-content' => 'text-align: {{VALUE}};',
                    '{{WRAPPER}} .banner-top' => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'box_background_color',
            [
                'label'     => esc_html__('Background Color', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .layout-style-1 .banner-content' => 'background-color: {{VALUE}}'
                ],
            ]
        );
        $this->add_responsive_control(
            'box_padding',
            [
                'label'      => esc_html__('Padding', 'humani'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .banner-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .banner-top' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_margin',
            [
                'label'      => esc_html__('Margin', 'humani'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .banner-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .banner-top' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'image_style',
            [
                'label' => esc_html__('Image', 'humani'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'image_width',
            [
                'label'          => esc_html__('Width', 'humani'),
                'type'           => Controls_Manager::SLIDER,
                'default'        => [
                    'unit' => '%',
                ],
                'tablet_default' => [
                    'unit' => '%',
                ],
                'mobile_default' => [
                    'unit' => '%',
                ],
                'size_units'     => ['%', 'px', 'vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .banner-image img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'min-height',
            [
                'label'      => esc_html__('Height', 'humani'),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 100,
                        'max' => 1000,
                    ],
                    'vh' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['px', 'vh'],
                'selectors'  => [
                    '{{WRAPPER}} .banner-image img' => 'height: {{SIZE}}{{UNIT}}',
                    '{{WRAPPER}} .banner-image'     => 'height: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->start_controls_tabs( 'tabs_img_style' );
        $this->start_controls_tab(
            'tab_img_normal',
            [
                'label' => esc_html__( 'Normal', 'humani' ),
            ]
        );

        $this->add_control(
            'img_bacground',
            [
                'label'     => esc_html__( 'Background Color', 'humani' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-image:before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'img_opacity',
            [
                'label' => __( 'Opacity', 'humani' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .banner-image:before' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_img_hover',
            [
                'label' => esc_html__( 'Hover', 'humani' ),
            ]
        );

        $this->add_control(
            'img_bacground_hover',
            [
                'label'     => esc_html__( 'Background Color', 'humani' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-humani-banner-wrapper:hover .banner-image:before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'img_opacity_hover',
            [
                'label' => __( 'Opacity', 'humani' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-humani-banner-wrapper:hover .banner-image:before' => 'opacity: {{SIZE}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'img_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'humani'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .banner-image:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                    '{{WRAPPER}} .banner-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_content_style',
            [
                'label' => esc_html__('Content', 'humani'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_control(
            'heading_style_sub_title',
            [
                'type'  => Controls_Manager::HEADING,
                'label' => esc_html__('Sub Title', 'humani'),
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'sub_title_typography',
                'selector' => '{{WRAPPER}} .banner-top .sub-title',
            ]
        );

        $this->add_responsive_control(
            'sub_title_spacing',
            [
                'label'     => esc_html__('Spacing', 'humani'),
                'type'      => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .banner-top .sub-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'sub_title_color',
            [
                'label'     => esc_html__('Text Color', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-top .sub-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'sub_title_color_hover',
            [
                'label'     => esc_html__('Text Color Hover', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-humani-banner-wrapper:hover .banner-top .sub-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'sub_title_color_line',
            [
                'label'     => esc_html__('Line Color', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .layout-style-2 .sub-title .line' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'sub_title_color_line_hover',
            [
                'label'     => esc_html__('Line Color Hover', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .layout-style-2:hover .sub-title .line' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'heading_style_title',
            [
                'type'      => Controls_Manager::HEADING,
                'label'     => esc_html__('Title', 'humani'),
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} .banner-content .title',
                'condition' => [
                    'layout_style' => '1',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_top_typography',
                'selector' => '{{WRAPPER}} .banner-top .title',
                'condition' => [
                    'layout_style' => '2',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_spacing',
            [
                'label'     => esc_html__('Spacing', 'humani'),
                'type'      => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .layout-style-1 .banner-content .content' => 'margin-top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .banner-top .title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__('Color', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-content .title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .banner-top .title' => 'color: {{VALUE}}'
                ],
            ]
        );
        $this->add_control(
            'title_color_hover',
            [
                'label'     => esc_html__('Color Hover', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-humani-banner-wrapper:hover .banner-content .title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .elementor-humani-banner-wrapper:hover .banner-top .title' => 'color: {{VALUE}}'
                ],
            ]
        );

        $this->add_control(
            'heading_style_description',
            [
                'type'      => Controls_Manager::HEADING,
                'label'     => esc_html__('Description', 'humani'),
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'description_typography',
                'selector' => '{{WRAPPER}} .banner-content .description',
                'condition' => [
                    'layout_style' => '1',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'description_top_typography',
                'selector' => '{{WRAPPER}} .banner-top .description',
                'condition' => [
                    'layout_style' => '2',
                ],
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label'     => esc_html__('Color', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-content .description' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .banner-top .description' => 'color: {{VALUE}}; border-top-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'description_spacing',
            [
                'label'     => esc_html__('Spacing', 'humani'),
                'type'      => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .banner-content .description' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Button
        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button', 'humani'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'button_typography',
                'selector' => '{{WRAPPER}} .banner-content .button-banner span',
            ]
        );

        $this->start_controls_tabs( 'tabs_button_style' );
        $this->start_controls_tab(
            'tab_button_normal',
            [
                'label' => esc_html__( 'Normal', 'humani' ),
            ]
        );
        $this->add_control(
            'button_color',
            [
                'label'     => esc_html__('Color', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-content .button-banner span' => 'color: {{VALUE}}'
                ],
            ]
        );
        $this->add_control(
            'button_bacground',
            [
                'label'     => esc_html__( 'Background Color', 'humani' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-content .button-banner' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_button_hover',
            [
                'label' => esc_html__( 'Hover', 'humani' ),
            ]
        );
        $this->add_control(
            'button_color_hover',
            [
                'label'     => esc_html__('Color Hover', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-content .button-banner:hover span' => 'color: {{VALUE}}'
                ],
            ]
        );
        $this->add_control(
            'button_bacground_hover',
            [
                'label'     => esc_html__( 'Background Color', 'humani' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-content .button-banner:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'button_border_hover',
            [
                'label'     => esc_html__( 'Border Color', 'humani' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-content .button-banner:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'        => 'border_button',
                'placeholder' => '1px',
                'default'     => '1px',
                'selector'    => '{{WRAPPER}} .banner-content .button-banner',
                'separator'   => 'before',
            ]
        );
        $this->add_responsive_control(
            'button_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'humani' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .banner-content .button-banner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'button_padding',
            [
                'label'      => __( 'Padding', 'humani' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors'  => [
                    '{{WRAPPER}} .banner-content .button-banner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'button_margin',
            [
                'label'      => __( 'Margin', 'humani' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors'  => [
                    '{{WRAPPER}} .banner-content .button-banner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $this->add_render_attribute('wrapper', 'class', 'elementor-humani-banner-wrapper js-banner-content-hover');
        $this->add_render_attribute('wrapper', 'class', 'layout-style-'. $settings['layout_style']);
        ?>
        <div <?php echo humani_elementor_get_render_attribute_string('wrapper', $this); ?>>
            <?php if ($settings['layout_style'] == '2'): ?>
                <div class="banner-top">
                    <?php if (!empty($settings['subtitle'])) { ?>
                        <div class="sub-title">
                            <span class="line"></span>
                            <span><?php printf('%s', $settings['subtitle']); ?></span>
                        </div>
                    <?php } ?>
                    <?php if (!empty($settings['title'])) { ?>
                        <div class="title"><?php printf('%s', $settings['title']); ?></div>
                    <?php } ?>
                    <?php if (!empty($settings['description'])) { ?>
                        <div class="description"><?php printf('%s', $settings['description']); ?></div>
                    <?php } ?>
                </div>
            <?php endif; ?>
            <div class="banner-image">
                <?php
                if (!empty($settings['image']['url'])) :
                    echo Group_Control_Image_Size::get_attachment_image_html($settings, 'thumbnail', 'image');
                endif;
                ?>
            </div>
            <div class="banner-content">
                <?php if ($settings['layout_style'] == '1'): ?>
                    <?php if (!empty($settings['title'])) { ?>
                        <div class="title"><?php printf('%s', $settings['title']); ?></div>
                    <?php } ?>
                <?php endif; ?>
                <?php if (!empty($settings['button']) || !empty($settings['title']) || !empty($settings['description'])) { ?>
                    <div class="content js-banner-content">
                        <?php if ($settings['layout_style'] == '1'): ?>
                            <?php if (!empty($settings['description'])) { ?>
                                <div class="description"><?php printf('%s', $settings['description']); ?></div>
                            <?php } ?>
                        <?php endif; ?>
                        <?php if (!empty($settings['button'])) { ?>
                            <a class="button-banner" href="<?php echo esc_url($settings['link']['url']); ?>">
                                <span><?php echo esc_html($settings['button']); ?></span>
                            </a>
                        <?php } ?>
                    </div>
                <?php } ?>
            </div>
        </div>
        <?php
    }
}

$widgets_manager->register(new Humani_Hanner());
