<?php
if (!defined('ABSPATH')) {
    exit;
}
if (!class_exists('Humani_Customize')) {

    class Humani_Customize {


        public function __construct() {
            add_action('customize_register', array($this, 'customize_register'));
        }

        /**
         * @param $wp_customize WP_Customize_Manager
         */
        public function customize_register($wp_customize) {

            /**
             * Theme options.
             */
            require_once get_theme_file_path('inc/customize-control/editor.php');
            $this->init_humani_blog($wp_customize);

            $this->init_humani_social($wp_customize);

            if (class_exists('Give')) {
                $this->init_humani_donations($wp_customize);
            }

            do_action('humani_customize_register', $wp_customize);
        }


        /**
         * @param $wp_customize WP_Customize_Manager
         *
         * @return void
         */
        public function init_humani_blog($wp_customize) {

            $wp_customize->add_section('humani_blog_archive', array(
                'title' => esc_html__('Blog', 'humani'),
            ));

            // =========================================
            // Select Style
            // =========================================

            $wp_customize->add_setting('humani_options_blog_style', array(
                'type'              => 'option',
                'default'           => 'standard',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('humani_options_blog_style', array(
                'section' => 'humani_blog_archive',
                'label'   => esc_html__('Blog style', 'humani'),
                'type'    => 'select',
                'choices' => array(
                    'standard' => esc_html__('Blog Standard', 'humani'),
                    'grid'     => esc_html__('Blog Grid', 'humani'),
                    'overlay'  => esc_html__('Blog Overlay', 'humani'),
                ),
            ));

            $wp_customize->add_setting('humani_options_blog_sidebar', array(
                'type'              => 'option',
                'default'           => 'right',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('humani_options_blog_sidebar', array(
                'section' => 'humani_blog_archive',
                'label'   => esc_html__('Sidebar Position', 'humani'),
                'type'    => 'select',
                'choices' => array(
                    'left'  => esc_html__('Left', 'humani'),
                    'right' => esc_html__('Right', 'humani'),
                ),
            ));

        }

        public function init_humani_donations($wp_customize) {
            $wp_customize->add_section('humani_give_archive', array(
                'title' => esc_html__('GiveWP Archive', 'humani'),
            ));

            $wp_customize->add_setting('humani_options_give_archive_column', array(
                'type'              => 'option',
                'default'           => 3,
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('humani_options_give_archive_column', array(
                'section' => 'humani_give_archive',
                'label'   => esc_html__('Columns', 'humani'),
                'type'    => 'select',
                'choices' => array(
                    1 => esc_html__('1', 'humani'),
                    2 => esc_html__('2', 'humani'),
                    3 => esc_html__('3', 'humani'),
                ),
            ));

            $wp_customize->add_setting('humani_options_give_forms_per_page', array(
                'type'              => 'option',
                'default'           => 12,
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('humani_options_give_forms_per_page', array(
                'section' => 'humani_give_archive',
                'label'   => esc_html__('Forms Per Page', 'humani'),
                'type'    => 'number',
            ));
        }

        /**
         * @param $wp_customize WP_Customize_Manager
         *
         * @return void
         */
        public function init_humani_social($wp_customize) {

            $wp_customize->add_section('humani_social', array(
                'title' => esc_html__('Socials', 'humani'),
            ));
            $wp_customize->add_setting('humani_options_social_share', array(
                'type'              => 'option',
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('humani_options_social_share', array(
                'type'    => 'checkbox',
                'section' => 'humani_social',
                'label'   => esc_html__('Show Social Share', 'humani'),
            ));
            $wp_customize->add_setting('humani_options_social_share_facebook', array(
                'type'              => 'option',
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('humani_options_social_share_facebook', array(
                'type'    => 'checkbox',
                'section' => 'humani_social',
                'label'   => esc_html__('Share on Facebook', 'humani'),
            ));
            $wp_customize->add_setting('humani_options_social_share_twitter', array(
                'type'              => 'option',
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('humani_options_social_share_twitter', array(
                'type'    => 'checkbox',
                'section' => 'humani_social',
                'label'   => esc_html__('Share on Twitter', 'humani'),
            ));
            $wp_customize->add_setting('humani_options_social_share_linkedin', array(
                'type'              => 'option',
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('humani_options_social_share_linkedin', array(
                'type'    => 'checkbox',
                'section' => 'humani_social',
                'label'   => esc_html__('Share on Linkedin', 'humani'),
            ));
            $wp_customize->add_setting('humani_options_social_share_google-plus', array(
                'type'              => 'option',
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('humani_options_social_share_google-plus', array(
                'type'    => 'checkbox',
                'section' => 'humani_social',
                'label'   => esc_html__('Share on Google+', 'humani'),
            ));

            $wp_customize->add_setting('humani_options_social_share_pinterest', array(
                'type'              => 'option',
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('humani_options_social_share_pinterest', array(
                'type'    => 'checkbox',
                'section' => 'humani_social',
                'label'   => esc_html__('Share on Pinterest', 'humani'),
            ));
            $wp_customize->add_setting('humani_options_social_share_email', array(
                'type'              => 'option',
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('humani_options_social_share_email', array(
                'type'    => 'checkbox',
                'section' => 'humani_social',
                'label'   => esc_html__('Share on Email', 'humani'),
            ));
        }

    }
}
return new Humani_Customize();
