<?php 
	
	function safeguard_customize_footer_tab($wp_customize, $theme_name){

		$wp_customize->add_section( 'safeguard_footer_settings' , array(
		    'title'      => esc_html__( 'Footer', 'safeguard' ),
		    'priority'   => 75,
		) );

		

		
        $wp_customize->add_setting( 'safeguard_footer_el' , array(
            'default'     => 'default',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field'
        ) );
        $wp_customize->add_control(
            'safeguard_footer_el',
            array(
                'label'         => esc_html__( 'Elementor', 'safeguard' ),
                'section'       => 'safeguard_footer_settings',
                'settings'      => 'safeguard_footer_el',
                'type'          => 'select',
                'choices'       => array(
                    'default' => esc_html__( 'Default', 'safeguard' ),
                    'elementor'  => esc_html__( 'Elementor', 'safeguard' ),
                ),
                'priority'   => 10
            )
        );
        $form_args = array(
            'post_type' => 'elementor_library',
            'status' => 'publish',
            'posts_per_page' => -1,
        );
        $templates = get_posts($form_args);
        $templates_arr = array();
        $default_form = 'disable';
        foreach ($templates as $t) {
            $templates_arr[$t->ID] = $t->post_title;
        }
        $wp_customize->add_setting('safeguard_footer_el_template', array(
            'default' => 'default',
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control(
            'safeguard_footer_el_template',
            array(
                'label' => esc_html__('Elementor Template', 'safeguard'),
                'section' => 'safeguard_footer_settings',
                'settings' => 'safeguard_footer_el_template',
                'type' => 'select',
                'choices' => $templates_arr,
                'priority' => 10
            )
        );




		$wp_customize->add_setting( 'safeguard_footer_fixed' , array(
            'default'     => '0',
            'transport'   => 'refresh',
		    'sanitize_callback' => 'esc_html'
        ) );
        
		$wp_customize->add_control(
            'safeguard_footer_fixed',
            array(
                'label'    => esc_html__( 'Fixed', 'safeguard' ),
                'section'  => 'safeguard_footer_settings',
                'settings' => 'safeguard_footer_fixed',
                'type'     => 'select',
                'choices'  => array(
                    '1'  => esc_html__( 'On', 'safeguard' ),
                    '0' => esc_html__( 'Off', 'safeguard' ),
                ),
            )
        );

	}
		
?>