<?php
if (!function_exists('give_gallery_metabox_output')) {
    function give_gallery_metabox_output($post) {
        ?>
        <div id="give_images_container">
            <ul class="give_images">
                <?php
                $give_image_gallery = array();

                if (metadata_exists('post', $post->ID, '_give_image_gallery')) {
                    $give_image_gallery = get_post_meta($post->ID, '_give_image_gallery', true);
                } else {
                    // Backwards compat
                    $attachment_ids     = get_posts('post_parent=' . $post->ID . '&numberposts=-1&post_type=attachment&orderby=menu_order&order=ASC&post_mime_type=image&fields=ids&meta_key=_woocommerce_360_image&meta_value=1');
                    $attachment_ids     = array_diff($attachment_ids, array(get_post_thumbnail_id()));
                    $give_image_gallery = implode(',', $attachment_ids);
                }

                $attachments         = array_filter(explode(',', $give_image_gallery));
                $update_meta         = false;
                $updated_gallery_ids = array();

                if (!empty($attachments)) {
                    foreach ($attachments as $attachment_id) {
                        $attachment = wp_get_attachment_image($attachment_id, 'thumbnail');

                        // if attachment is empty skip
                        if (empty($attachment)) {
                            $update_meta = true;
                            continue;
                        }

                        echo '<li class="image" data-attachment_id="' . esc_attr($attachment_id) . '">
								' . $attachment . '
								<ul class="actions">
									<li><a href="#" class="delete tips" data-tip="' . esc_html__('Delete image', 'humani') . '">' . esc_html__('Delete', 'humani') . '</a></li>
								</ul>
							</li>';

                        // rebuild ids to be saved
                        $updated_gallery_ids[] = $attachment_id;
                    }

                    // need to update give meta to set new gallery ids
                    if ($update_meta) {
                        update_post_meta($post->ID, '_give_image_gallery', implode(',', $updated_gallery_ids));
                    }
                }
                ?>
            </ul>

            <input type="hidden" id="give_image_gallery" name="give_image_gallery" value="<?php echo esc_attr($give_image_gallery); ?>"/>

        </div>
        <p class="add_give_images hide-if-no-js">
            <a class="button" href="#" data-choose="<?php esc_attr_e('Add Gallery', 'humani'); ?>" data-update="<?php esc_attr_e('Add to gallery', 'humani'); ?>" data-delete="<?php esc_attr_e('Delete image', 'humani'); ?>" data-text="<?php esc_attr_e('Delete', 'humani'); ?>"><?php esc_html_e('Add gallery images', 'humani'); ?></a>
        </p>
        <?php

    }
}

function humani_give_view_meta() {
    add_meta_box('humani-give-gallery-images',
        esc_html__('Gallery images', 'humani'),
        'give_gallery_metabox_output',
        'give_forms', 'normal', 'high');
}

add_action('add_meta_boxes', 'humani_give_view_meta', 50);

/**
 * ------------------------------------------------------------------------------------------------
 * Save metaboxes
 * ------------------------------------------------------------------------------------------------
 */
if (!function_exists('humani_save_gallery_metabox')) {
    function humani_save_gallery_metabox($post_id, $post) {
        $attachment_ids = isset($_POST['give_image_gallery']) ? array_filter(explode(',', $_POST['give_image_gallery'])) : array();
        update_post_meta($post_id, '_give_image_gallery', implode(',', $attachment_ids));
    }
}

add_action('save_post_give_forms', 'humani_save_gallery_metabox', 50, 2);


add_action('admin_init', function () {
    global $humani_version;
    wp_enqueue_script('humani-give-gallery-admin-scripts', get_theme_file_uri('assets/js/admin/give-gallery.js'), array(), $humani_version, true);
    wp_enqueue_style('humani-give-gallery-admin-style', get_theme_file_uri('assets/css/admin/give-gallery.css'), '', $humani_version);
}, 100);

