<?php
/**
 * Give Settings Page/Tab
 *
 * @package     Give
 * @subpackage  Classes/Humani_Give_Settings_Display
 * @copyright   Copyright (c) 2016, GiveWP
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       1.8
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!class_exists('Humani_Give_Settings_Display')) :

    /**
     * Humani_Give_Settings_Display.
     *
     * @sine 1.8
     */
    class Humani_Give_Settings_Display extends Give_Settings_Page {

        /**
         * Constructor.
         */
        public function __construct() {
            $this->id          = 'humanil_display';
            $this->label       = __('Humani Options', 'humani');
            $this->default_tab = 'display-settings';

            parent::__construct();
        }

        /**
         * Get settings array.
         *
         * @return array
         * @since  1.8
         */
        public function get_settings() {
            $settings        = [];
            $current_section = give_get_current_setting_section();

            switch ($current_section) {
                case 'display-settings':
                    $settings = [
                        [
                            'id'   => 'humani_give_title_display_settings',
                            'type' => 'title',
                        ],
                        [
                            'name'    => __('Give Block Style', 'humani'),
                            'id'      => 'block_style',
                            'type'    => 'select',
                            'default' => 'block-1',
                            'options' => [
                                'block-1' => __('Style 1', 'humani'),
                                'block-2' => __('Style 2', 'humani'),
                                'block-3' => __('Style 3', 'humani'),
                                'block-4' => __('Style 4', 'humani'),
                            ],
                        ],
                        [
                            'id'   => 'humani_give_title_display_settings',
                            'type' => 'sectionend',
                        ],
                    ];
                    break;
            }
            /**
             * Filter the settings.
             *
             * @param array $settings
             * @since  1.8
             *
             */
            $settings = apply_filters('give_get_settings_' . $this->id, $settings);

            // Output.
            return $settings;
        }

        public function get_sections() {
            $sections = [
                'display-settings' => __('Display', 'humani'),
            ];

            return apply_filters('give_get_sections_' . $this->id, $sections);
        }
    }

endif;

return new Humani_Give_Settings_Display();
