<?php

if (!function_exists('humani_single_give_content_start')) {
    function humani_single_give_content_start() {
        echo '<div class="single-give-content-wrap">';
    }
}

if (!function_exists('humani_single_give_content_end')) {
    function humani_single_give_content_end() {
        echo '</div>';
    }
}

if (!function_exists('humani_single_give_summary_tab')) {
    function humani_single_give_summary_tab() {
        wp_enqueue_script("jquery-ui-tabs");
        $gallery       = humani_get_post_meta(get_the_ID(), '_give_image_gallery');
        $content_check = give_is_setting_enabled(give_get_meta(get_the_ID(), '_give_display_content', true));
        $form        = new Give_Donate_Form( get_the_ID() );
        ?>
        <div id="give-form-single-tab" class="give-form-tabs">
            <ul>
                <?php if ($content_check): ?>
                    <li><a href="#tabs-1"><?php echo esc_html__('description', 'humani'); ?></a></li>
                <?php endif;
                if ($gallery) {
                    echo '<li><a href="#tabs-2">' . esc_html__('gallery', 'humani') . '</a></li>';
                } ?>
                <li><a href="#tabs-3"><?php echo esc_html__('donors', 'humani'); ?><span>(<?php printf('%s',$form->get_sales()); ?>)</span></a></li>

            </ul>
            <?php if ($content_check): ?>
                <div id="tabs-1">
                    <?php give_form_display_content(get_the_ID(), []); ?>
                </div>
            <?php endif;
            if ($gallery) {
                echo '<div id="tabs-2">' . do_shortcode('[gallery link="file" columns="3"  size="givelove-featured-image-small" ids="' . $gallery . '"]') . '</div>';
            }
            ?>
            <div id="tabs-3">
                <?php echo do_shortcode('[give_donor_wall form_id="' . get_the_ID() . '"]');
                ?>
            </div>
        </div>
        <?php
    }
}

if (!function_exists('humani_give_meta')) {

    function humani_give_meta() {
        $form_id         = get_the_ID();
        $enable_category = give_is_setting_enabled(give_get_option('categories', 'disabled'));
        if ($enable_category) {
            $term_list = wp_get_post_terms($form_id, 'give_forms_category', array('fields' => 'id=>name'));
        }
        ?>
        <div class="give-grid-meta">
            <?php
            if (!empty($term_list)): ?>
                <div class="give-card__category"><?php if (is_array($term_list)):
                        foreach ($term_list as $key => $value) {
                            echo '<span style="background-color:' . get_term_meta($key, '_color', true) . '">' . esc_html($value) . '</span>';
                        }
                    endif; ?>
                </div>
            <?php endif;

            $time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time>';

            if (get_the_time('U') !== get_the_modified_time('U')) {
                $time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
            }

            $time_string = sprintf(
                $time_string,
                esc_attr(get_the_date('c')),
                esc_html(get_the_date()),
                esc_attr(get_the_modified_date('c')),
                esc_html(get_the_modified_date())
            );

            $posted_on = '<span class="posted-on">' . sprintf('<a href="%1$s" rel="bookmark">%2$s</a>', esc_url(get_permalink()), $time_string) . '</span>';

            // Author.
            $author = sprintf(
                '<span class="post-author">%1$s<a href="%2$s" class="url fn" rel="author">%3$s</a></span>',
                esc_html__('by ', 'humani'),
                esc_url(get_author_posts_url(get_the_author_meta('ID'))),
                esc_html(get_the_author())
            );


            echo wp_kses(
                sprintf('%1$s - %2$s', $author, $posted_on), array(
                    'span' => array(
                        'class' => array(),
                    ),
                    'a'    => array(
                        'href'  => array(),
                        'title' => array(),
                        'rel'   => array(),
                    ),
                    'time' => array(
                        'datetime' => array(),
                        'class'    => array(),
                    ),
                )
            );
            ?>

        </div>
        <?php
    }
}

function humani_give_sidebar($arg) {
    $arg['before_title'] = '<h3 class="widgettitle widget-title"><span>';
    $arg['after_title']  = '</span></h3>';
    return $arg;
}