<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

if (!class_exists('Give')) {
    return;
}


class Humani_Elementor_Give_Form extends Widget_Base {

    public function get_name() {
        return 'humani-give-form';
    }

    public function get_title() {
        return esc_html__('humani Give Single Form', 'humani');
    }

    public function get_categories() {
        return array('humani-addons');
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_give_form',
            [
                'label' => esc_html__('Give Form Grid', 'humani'),
            ]
        );

        $this->add_control(
            'form_id',
            [
                'label'   => esc_html__('Form', 'humani'),
                'type'    => Controls_Manager::SELECT,
                'options' => $this->get_form_ids(),
            ]
        );

        $this->add_control(
            'show_title',
            [
                'label'     => esc_html__('Show Title', 'humani'),
                'type'      => Controls_Manager::SWITCHER,
                'label_on'  => 'Hide',
                'label_off' => 'Show',
                'default'   => 'yes',
            ]
        );

        $this->add_control(
            'show_goal',
            [
                'label'       => esc_html__('Show Goal', 'humani'),
                'type'        => Controls_Manager::SWITCHER,
                'label_on'    => 'Hide',
                'label_off'   => 'Show',
                'default'     => 'yes',
                'description' => esc_html__('Do you want to display the goal\'s progress bar?', 'humani'),
            ]
        );
        $this->add_control(
            'show_content',
            [
                'label'   => esc_html__('Show Content', 'humani'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'above' => esc_html__('Above', 'humani'),
                    'below' => esc_html__('Below', 'humani'),
                    'none'  => esc_html__('None', 'humani'),
                ],
                'default' => 'none'
            ]
        );

        $this->add_control(
            'display_style',
            [
                'label'   => esc_html__('Display Style', 'humani'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'onpage' => esc_html__('Onpage', 'humani'),
                    'modal'  => esc_html__('Modal', 'humani'),
                    'reveal' => esc_html__('Reveal', 'humani'),
                    'button' => esc_html__('Button', 'humani'),
                ],
                'default' => 'onpage'
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_total_wrap',
            [
                'label' => esc_html__('Total Wrap', 'humani'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'show_notice',
            [
                'label'        => esc_html__('Show Notice', 'humani'),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => 'Hide',
                'label_off'    => 'Show',
                'default'      => 'yes',
                'prefix_class' => 'give-form-style-show-notice-',
            ]
        );

        $this->add_control(
            'total_wrap_currency',
            [
                'label'     => esc_html__('Currency', 'humani'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'color_currency',
            [
                'label'     => esc_html__('Color', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} form[id*=give-form] .give-donation-amount .give-currency-symbol.give-currency-position-before' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'background_color_currency',
            [
                'label'     => esc_html__('Background Color', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} form[id*=give-form] .give-donation-amount .give-currency-symbol.give-currency-position-before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'total_wrap_amount',
            [
                'label'     => esc_html__('Amount', 'humani'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'color_amount',
            [
                'label'     => esc_html__('Color', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} form[id*=give-form] .give-donation-amount #give-amount' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'background_color_amount',
            [
                'label'     => esc_html__('Background Color', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} form[id*=give-form] .give-donation-amount #give-amount' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'border_color_amount',
            [
                'label'     => esc_html__('Border Color', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} form[id*=give-form] .give-donation-amount #give-amount'                                        => 'border-color: {{VALUE}};',
                    '{{WRAPPER}} form[id*=give-form] .give-donation-amount .give-currency-symbol.give-currency-position-before' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_button_total_wrap',
            [
                'label' => esc_html__('Button Total', 'humani'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('tabs_button_total_wrap');

        $this->start_controls_tab(
            'tab_button_total_wrap_normal',
            [
                'label' => esc_html__('Normal', 'humani'),
            ]
        );

        $this->add_control(
            'color_button_total',
            [
                'label'     => esc_html__('Color', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .give-btn.give-donation-level-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'background_color_button_total',
            [
                'label'     => esc_html__('Background Color', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .give-btn.give-donation-level-btn' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'border_color_button_total',
            [
                'label'     => esc_html__('Border Color', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .give-btn.give-donation-level-btn' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_button_total_wrap_hover',
            [
                'label' => esc_html__('Hover', 'humani'),
            ]
        );
        $this->add_control(
            'color_hover_button_total',
            [
                'label'     => esc_html__('Color', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .give-btn.give-donation-level-btn:hover' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .give-btn.give-donation-level-btn:focus' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'background_color_hover_button_total',
            [
                'label'     => esc_html__('Background Color', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .give-btn.give-donation-level-btn:hover' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .give-btn.give-donation-level-btn:focus' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'border_color_hover_button_total',
            [
                'label'     => esc_html__('Border Color', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .give-btn.give-donation-level-btn:hover' => 'border-color: {{VALUE}};',
                    '{{WRAPPER}} .give-btn.give-donation-level-btn:focus' => 'border-color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_button_give_wrap',
            [
                'label' => esc_html__('Button', 'humani'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'button_give_typography',
                'selector' => '{{WRAPPER}} .give-btn.give-btn-modal',
            ]
        );

        $this->start_controls_tabs('tabs_button_style');
        $this->start_controls_tab(
            'tab_button_give_normal',
            [
                'label' => esc_html__('Normal', 'humani'),
            ]
        );
        $this->add_control(
            'button_give_color',
            [
                'label'     => esc_html__('Color', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .give-btn.give-btn-modal' => 'color: {{VALUE}}'
                ],
            ]
        );
        $this->add_control(
            'button_give_bacground',
            [
                'label'     => esc_html__('Background Color', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .give-btn.give-btn-modal' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_button_give_hover',
            [
                'label' => esc_html__('Hover', 'humani'),
            ]
        );
        $this->add_control(
            'button_give_color_hover',
            [
                'label'     => esc_html__('Color Hover', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .give-btn.give-btn-modal:hover' => 'color: {{VALUE}}'
                ],
            ]
        );
        $this->add_control(
            'button_give_bacground_hover',
            [
                'label'     => esc_html__('Background Color', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .give-btn.give-btn-modal:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'button_give_border_hover',
            [
                'label'     => esc_html__('Border Color', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .give-btn.give-btn-modal:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'        => 'border_give_button',
                'placeholder' => '1px',
                'default'     => '1px',
                'selector'    => '{{WRAPPER}} .give-btn.give-btn-modal',
                'separator'   => 'before',
            ]
        );
        $this->add_responsive_control(
            'button_give_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'humani'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .give-btn.give-btn-modal' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'button_give_padding',
            [
                'label'      => __('Padding', 'humani'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .give-btn.give-btn-modal' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'button_give_margin',
            [
                'label'      => __('Margin', 'humani'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .give-btn.give-btn-modal' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    private function get_form_ids() {
        $args          = array(
            'post_type'      => 'give_forms',
            'posts_per_page' => -1,
            'post_status'    => 'publish',
        );
        $give_form_ids = array();
        $give_forms    = get_posts($args);
        foreach ($give_forms as $give_form) {
            $form_title                    = empty($give_form->post_title) ? sprintf(__('Untitled (#%s)', 'humani'), $give_form->ID) : $give_form->post_title;
            $give_form_ids[$give_form->ID] = $form_title;
        }
        return $give_form_ids;
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        if (empty($settings['form_id'])) {
            return;
        }
        $atts = [
            'id'            => $settings['form_id'],
            'show_title'    => $settings['show_title'],
            'show_goal'     => $settings['show_goal'],
            'show_content'  => $settings['show_content'],
            'display_style' => $settings['display_style'],
        ];

        $code = '';
        foreach ($atts as $key => $value) {
            $code .= $key . '="' . (empty($value) ? 'false' : $value) . '" ';
        }

        add_action('give_goal_closed_output', [$this, 'give_goal_closed_output'], 10, 1);

        echo do_shortcode('[give_form ' . $code . ' ]');

        remove_action('give_goal_closed_output', [$this, 'give_goal_closed_output'], 10);

    }

    public function give_goal_closed_output($goal_achieved_message) {
        return '';
    }
}

$widgets_manager->register(new Humani_Elementor_Give_Form());