<?php

if (!defined('ABSPATH')) {
    exit;
}

if (!class_exists('Humani_Elementor')) :

    /**
     * The Humani Elementor Integration class
     */
    class Humani_Elementor {
        private $suffix = '';

        public function __construct() {
            $this->suffix = (defined('SCRIPT_DEBUG') && SCRIPT_DEBUG) ? '' : '.min';

            add_action('elementor/frontend/after_enqueue_scripts', [$this, 'register_auto_scripts_frontend']);
            add_action('elementor/init', array($this, 'add_category'));
            add_action('wp_enqueue_scripts', [$this, 'add_scripts'], 15);
            add_action('elementor/widgets/register', array($this, 'customs_widgets'));
            add_action('elementor/widgets/register', array($this, 'include_widgets'));
            add_action('elementor/frontend/after_enqueue_scripts', [$this, 'add_js']);

            // Custom Animation Scroll
            add_filter('elementor/controls/animations/additional_animations', [$this, 'add_animations_scroll']);

            // Backend
            add_action('elementor/editor/after_enqueue_styles', [$this, 'add_style_editor'], 99);

            // Add Icon Custom
            add_action('elementor/icons_manager/native', [$this, 'add_icons_native']);
            add_action('elementor/controls/controls_registered', [$this, 'add_icons']);

            if (!humani_is_elementor_pro_activated()) {
                require trailingslashit(get_template_directory()) . 'inc/elementor/custom-css.php';
                require trailingslashit(get_template_directory()) . 'inc/elementor/sticky-section.php';
                if (is_admin()) {
                    add_action('manage_elementor_library_posts_columns', [$this, 'admin_columns_headers']);
                    add_action('manage_elementor_library_posts_custom_column', [$this, 'admin_columns_content'], 10, 2);
                }
            }

            add_filter('elementor/fonts/additional_fonts', [$this, 'additional_fonts']);
            add_action('wp_enqueue_scripts', [$this, 'elementor_kit']);
        }

        public function elementor_kit() {
            $active_kit_id = Elementor\Plugin::$instance->kits_manager->get_active_id();
            Elementor\Plugin::$instance->kits_manager->frontend_before_enqueue_styles();
            $myvals = get_post_meta($active_kit_id, '_elementor_page_settings', true);
            if (!empty($myvals)) {
                $css = '';
                foreach ($myvals['system_colors'] as $key => $value) {
                    $css .= $value['color'] !== '' ? '--' . $value['_id'] . ':' . $value['color'] . ';' : '';
                }

                $var = "body{{$css}}";
                wp_add_inline_style('humani-style', $var);
            }
        }

        public function additional_fonts($fonts) {
            $fonts["Red Rose"] = 'googlefonts';
            $fonts["Humanii"] = 'system';
            return $fonts;
        }

        public function admin_columns_headers($defaults) {
            $defaults['shortcode'] = __('Shortcode', 'humani');

            return $defaults;
        }

        public function admin_columns_content($column_name, $post_id) {
            if ('shortcode' === $column_name) {
                ob_start();
                ?>
                <input class="elementor-shortcode-input" type="text" readonly onfocus="this.select()" value="[hfe_template id='<?php echo esc_attr($post_id); ?>']"/>
                <?php
                ob_get_contents();
            }
        }

        public function add_js() {
            global $humani_version;
            wp_enqueue_script('humani-elementor-frontend', get_theme_file_uri('/assets/js/elementor-frontend.js'), [], $humani_version);
        }

        public function add_style_editor() {
            global $humani_version;
            wp_enqueue_style('humani-elementor-editor-icon', get_theme_file_uri('/assets/css/admin/elementor/icons.css'), [], $humani_version);
        }

        public function add_scripts() {
            global $humani_version;
            $suffix = (defined('SCRIPT_DEBUG') && SCRIPT_DEBUG) ? '' : '.min';
            wp_enqueue_style('humani-elementor', get_template_directory_uri() . '/assets/css/base/elementor.css', '', $humani_version);
            wp_style_add_data('humani-elementor', 'rtl', 'replace');

            // Add Scripts
            wp_register_script('tweenmax', get_theme_file_uri('/assets/js/vendor/TweenMax.min.js'), array('jquery'), '1.11.1');
            wp_register_script('parallaxmouse', get_theme_file_uri('/assets/js/vendor/jquery-parallax.js'), array('jquery'), $humani_version);

            if (humani_elementor_check_type('animated-bg-parallax')) {
                wp_enqueue_script('tweenmax');
                wp_enqueue_script('jquery-panr', get_theme_file_uri('/assets/js/vendor/jquery-panr' . $suffix . '.js'), array('jquery'), '0.0.1');
            }
        }


        public function register_auto_scripts_frontend() {
            global $humani_version;
            wp_register_script('humani-elementor-banner', get_theme_file_uri('/assets/js/elementor/banner.js'), array('jquery','elementor-frontend'), $humani_version, true);
            wp_register_script('humani-elementor-brand', get_theme_file_uri('/assets/js/elementor/brand.js'), array('jquery','elementor-frontend'), $humani_version, true);
            wp_register_script('humani-elementor-countdown', get_theme_file_uri('/assets/js/elementor/countdown.js'), array('jquery','elementor-frontend'), $humani_version, true);
            wp_register_script('humani-elementor-give-form-grid', get_theme_file_uri('/assets/js/elementor/give-form-grid.js'), array('jquery','elementor-frontend'), $humani_version, true);
            wp_register_script('humani-elementor-image-gallery', get_theme_file_uri('/assets/js/elementor/image-gallery.js'), array('jquery','elementor-frontend'), $humani_version, true);
            wp_register_script('humani-elementor-posts-grid', get_theme_file_uri('/assets/js/elementor/posts-grid.js'), array('jquery','elementor-frontend'), $humani_version, true);
            wp_register_script('humani-elementor-progress', get_theme_file_uri('/assets/js/elementor/progress.js'), array('jquery','elementor-frontend'), $humani_version, true);
            wp_register_script('humani-elementor-tabs', get_theme_file_uri('/assets/js/elementor/tabs.js'), array('jquery','elementor-frontend'), $humani_version, true);
            wp_register_script('humani-elementor-team-box', get_theme_file_uri('/assets/js/elementor/team-box.js'), array('jquery','elementor-frontend'), $humani_version, true);
            wp_register_script('humani-elementor-testimonial', get_theme_file_uri('/assets/js/elementor/testimonial.js'), array('jquery','elementor-frontend'), $humani_version, true);
            wp_register_script('humani-elementor-video', get_theme_file_uri('/assets/js/elementor/video.js'), array('jquery','elementor-frontend'), $humani_version, true);
           
        }

        public function add_category() {
            Elementor\Plugin::instance()->elements_manager->add_category(
                'humani-addons',
                array(
                    'title' => esc_html__('Humani Addons', 'humani'),
                    'icon'  => 'fa fa-plug',
                ),
                1);
        }

        public function add_animations_scroll($animations) {
            $animations['Humani Animation'] = [
                'opal-move-up'    => 'Move Up',
                'opal-move-down'  => 'Move Down',
                'opal-move-left'  => 'Move Left',
                'opal-move-right' => 'Move Right',
                'opal-flip'       => 'Flip',
                'opal-helix'      => 'Helix',
                'opal-scale-up'   => 'Scale',
                'opal-am-popup'   => 'Popup',
            ];

            return $animations;
        }

        public function animations_scroll_style_src() {
            global $humani_version;
            $animations = [
                'opal-move-up',
                'opal-move-down',
                'opal-move-left',
                'opal-move-right',
                'opal-flip',
                'opal-helix',
                'opal-scale-up',
                'opal-am-popup',
            ];
            foreach ($animations as $animation) {
                wp_deregister_style('e-animation-' . $animation);
                wp_register_style('e-animation-' . $animation, get_theme_file_uri('/assets/css/base/animations/'.$animation.'.css'), [], $humani_version);
            }
        }

        public function customs_widgets() {
            $files = glob(get_theme_file_path('/inc/elementor/custom-widgets/*.php'));
            foreach ($files as $file) {
                if (file_exists($file)) {
                    require_once $file;
                }
            }
        }

        /**
         * @param $widgets_manager Elementor\Widgets_Manager
         */
        public function include_widgets($widgets_manager) {
            $files = glob(get_theme_file_path('/inc/elementor/widgets/*.php'));
            foreach ($files as $file) {
                if (file_exists($file)) {
                    require_once $file;
                }
            }
        }

        public function add_icons( $manager ) {
            $new_icons = json_decode( '{"humani-icon-address":"address","humani-icon-arow_line":"arow_line","humani-icon-campaign":"campaign","humani-icon-cancer-2":"cancer-2","humani-icon-cancer":"cancer","humani-icon-certificate":"certificate","humani-icon-chat":"chat","humani-icon-check-2":"check-2","humani-icon-check":"check","humani-icon-collaboration":"collaboration","humani-icon-comments-alt":"comments-alt","humani-icon-community":"community","humani-icon-countries-2":"countries-2","humani-icon-countries":"countries","humani-icon-courage":"courage","humani-icon-donate-2":"donate-2","humani-icon-donate-3":"donate-3","humani-icon-donate-4":"donate-4","humani-icon-donate":"donate","humani-icon-earth":"earth","humani-icon-eco":"eco","humani-icon-economics":"economics","humani-icon-edu":"edu","humani-icon-empathy":"empathy","humani-icon-ethics":"ethics","humani-icon-flower":"flower","humani-icon-forum":"forum","humani-icon-fundraise":"fundraise","humani-icon-give-money":"give-money","humani-icon-give":"give","humani-icon-heart-1":"heart-1","humani-icon-help":"help","humani-icon-hospital":"hospital","humani-icon-information":"information","humani-icon-innovation-2":"innovation-2","humani-icon-long-arrow-right":"long-arrow-right","humani-icon-mail-1":"mail-1","humani-icon-megaphone":"megaphone","humani-icon-money-2":"money-2","humani-icon-partnership":"partnership","humani-icon-pet-2":"pet-2","humani-icon-pet-badge":"pet-badge","humani-icon-pet-foot":"pet-foot","humani-icon-pet-home":"pet-home","humani-icon-pet-phone":"pet-phone","humani-icon-pet":"pet","humani-icon-phone-2":"phone-2","humani-icon-phone":"phone","humani-icon-placement":"placement","humani-icon-policy":"policy","humani-icon-potential":"potential","humani-icon-protection":"protection","humani-icon-quote-2":"quote-2","humani-icon-representation":"representation","humani-icon-rescue":"rescue","humani-icon-responsibilities":"responsibilities","humani-icon-responsibility":"responsibility","humani-icon-risk":"risk","humani-icon-science":"science","humani-icon-search-1":"search-1","humani-icon-search":"search","humani-icon-shield-check":"shield-check","humani-icon-support":"support","humani-icon-symptons":"symptons","humani-icon-user-2":"user-2","humani-icon-volunteer-2":"volunteer-2","humani-icon-volunteer-3":"volunteer-3","humani-icon-volunteer":"volunteer","humani-icon-voting":"voting","humani-icon-water-2":"water-2","humani-icon-water":"water","humani-icon-youtube-play":"youtube-play","humani-icon-angle-down":"angle-down","humani-icon-angle-left":"angle-left","humani-icon-angle-right":"angle-right","humani-icon-angle-up":"angle-up","humani-icon-arrow-circle-down":"arrow-circle-down","humani-icon-arrow-circle-left":"arrow-circle-left","humani-icon-arrow-circle-right":"arrow-circle-right","humani-icon-arrow-circle-up":"arrow-circle-up","humani-icon-bars":"bars","humani-icon-calendar":"calendar","humani-icon-caret-down":"caret-down","humani-icon-caret-left":"caret-left","humani-icon-caret-right":"caret-right","humani-icon-caret-square-left":"caret-square-left","humani-icon-caret-square-right":"caret-square-right","humani-icon-caret-up":"caret-up","humani-icon-cart-empty":"cart-empty","humani-icon-check-square":"check-square","humani-icon-chevron-circle-left":"chevron-circle-left","humani-icon-chevron-circle-right":"chevron-circle-right","humani-icon-chevron-down":"chevron-down","humani-icon-chevron-left":"chevron-left","humani-icon-chevron-right":"chevron-right","humani-icon-chevron-up":"chevron-up","humani-icon-circle":"circle","humani-icon-clock":"clock","humani-icon-cloud-download-alt":"cloud-download-alt","humani-icon-comment":"comment","humani-icon-comments":"comments","humani-icon-contact":"contact","humani-icon-credit-card":"credit-card","humani-icon-dot-circle":"dot-circle","humani-icon-edit":"edit","humani-icon-envelope":"envelope","humani-icon-exclamation-circle":"exclamation-circle","humani-icon-external-link-alt":"external-link-alt","humani-icon-eye":"eye","humani-icon-file-alt":"file-alt","humani-icon-file-archive":"file-archive","humani-icon-folder-open":"folder-open","humani-icon-folder":"folder","humani-icon-free_ship":"free_ship","humani-icon-heart-fill":"heart-fill","humani-icon-heart":"heart","humani-icon-history":"history","humani-icon-home":"home","humani-icon-info-circle":"info-circle","humani-icon-instagram":"instagram","humani-icon-level-up-alt":"level-up-alt","humani-icon-long-arrow-alt-down":"long-arrow-alt-down","humani-icon-long-arrow-alt-left":"long-arrow-alt-left","humani-icon-long-arrow-alt-right":"long-arrow-alt-right","humani-icon-long-arrow-alt-up":"long-arrow-alt-up","humani-icon-map-marker-check":"map-marker-check","humani-icon-meh":"meh","humani-icon-minus-circle":"minus-circle","humani-icon-minus":"minus","humani-icon-pen-square":"pen-square","humani-icon-pencil-alt":"pencil-alt","humani-icon-play-circle":"play-circle","humani-icon-plus-circle":"plus-circle","humani-icon-plus":"plus","humani-icon-quote":"quote","humani-icon-reply-all":"reply-all","humani-icon-reply":"reply","humani-icon-search-plus":"search-plus","humani-icon-smile":"smile","humani-icon-spinner":"spinner","humani-icon-star-fill":"star-fill","humani-icon-star":"star","humani-icon-sync":"sync","humani-icon-thumbtack":"thumbtack","humani-icon-times-circle":"times-circle","humani-icon-times":"times","humani-icon-truck":"truck","humani-icon-user":"user","humani-icon-adobe":"adobe","humani-icon-amazon":"amazon","humani-icon-android":"android","humani-icon-angular":"angular","humani-icon-apper":"apper","humani-icon-apple":"apple","humani-icon-atlassian":"atlassian","humani-icon-behance":"behance","humani-icon-bitbucket":"bitbucket","humani-icon-bitcoin":"bitcoin","humani-icon-bity":"bity","humani-icon-bluetooth":"bluetooth","humani-icon-btc":"btc","humani-icon-centos":"centos","humani-icon-chrome":"chrome","humani-icon-codepen":"codepen","humani-icon-cpanel":"cpanel","humani-icon-discord":"discord","humani-icon-dochub":"dochub","humani-icon-docker":"docker","humani-icon-dribbble":"dribbble","humani-icon-dropbox":"dropbox","humani-icon-drupal":"drupal","humani-icon-ebay":"ebay","humani-icon-facebook":"facebook","humani-icon-figma":"figma","humani-icon-firefox":"firefox","humani-icon-google-plus":"google-plus","humani-icon-google":"google","humani-icon-grunt":"grunt","humani-icon-gulp":"gulp","humani-icon-html5":"html5","humani-icon-jenkins":"jenkins","humani-icon-joomla":"joomla","humani-icon-link-brand":"link-brand","humani-icon-linkedin":"linkedin","humani-icon-mailchimp":"mailchimp","humani-icon-opencart":"opencart","humani-icon-paypal":"paypal","humani-icon-pinterest-p":"pinterest-p","humani-icon-reddit":"reddit","humani-icon-skype":"skype","humani-icon-slack":"slack","humani-icon-snapchat":"snapchat","humani-icon-spotify":"spotify","humani-icon-trello":"trello","humani-icon-twitter":"twitter","humani-icon-vimeo":"vimeo","humani-icon-whatsapp":"whatsapp","humani-icon-wordpress":"wordpress","humani-icon-yoast":"yoast","humani-icon-youtube":"youtube"}', true );
			$icons     = $manager->get_control( 'icon' )->get_settings( 'options' );
			$new_icons = array_merge(
				$new_icons,
				$icons
			);
			// Then we set a new list of icons as the options of the icon control
			$manager->get_control( 'icon' )->set_settings( 'options', $new_icons ); 
        }

        public function add_icons_native($tabs) {
            global $humani_version;
            $tabs['opal-custom'] = [
                'name'          => 'humani-icon',
                'label'         => esc_html__('Humani Icon', 'humani'),
                'prefix'        => 'humani-icon-',
                'displayPrefix' => 'humani-icon-',
                'labelIcon'     => 'fab fa-font-awesome-alt',
                'ver'           => $humani_version,
                'fetchJson'     => get_theme_file_uri('/inc/elementor/icons.json'),
                'native'        => true,
            ];

            return $tabs;
        }
    }

endif;

return new Humani_Elementor();
