(function ($) {
    $.fn.process_loading = function () {
        var DEFAULTS = {
            backgroundColor: '#e9e9e9',
            progressColor: '#8ccc57',
            percent: 75,
            duration: 2000
        };

        $(this).each(function () {
            var $target  = $(this);

            var opts = {
                backgroundColor: $target.data('color') ? $target.data('color').split(',')[0] : DEFAULTS.backgroundColor,
                progressColor: $target.data('color') ? $target.data('color').split(',')[1] : DEFAULTS.progressColor,
                percent: $target.data('percent') ? $target.data('percent') : DEFAULTS.percent,
                duration: $target.data('duration') ? $target.data('duration') : DEFAULTS.duration
            };

            $target.append('<div class="process-background"></div><div class="process-rotate"></div><div class="process-left"></div><div class="process-right"></div><div class=""><span>' + opts.percent + '<sup>%</sup></span></div>');

            $target.find('.process-background').css('border-color', opts.backgroundColor);
            $target.find('.process-left').css('border-color', opts.backgroundColor);
            $target.find('.process-rotate').css('border-color', opts.progressColor);
            $target.find('.process-right').css('border-color', opts.progressColor);

            var $rotate = $target.find('.process-rotate');
            setTimeout(function () {
                $rotate.css({
                    'transition': 'transform ' + opts.duration + 'ms linear',
                    'transform': 'rotate(' + opts.percent * 3.6 + 'deg)'
                });
            },1);

            if (opts.percent > 50) {
                var animationRight = 'toggle ' + (opts.duration / opts.percent * 50) + 'ms step-end';
                var animationLeft = 'toggle ' + (opts.duration / opts.percent * 50) + 'ms step-start';
                $target.find('.process-right').css({
                    animation: animationRight,
                    opacity: 1
                });
                $target.find('.process-left').css({
                    animation: animationLeft,
                    opacity: 0
                });
            }
        });
    }
    $(".progress-bar-circle").process_loading();
})(jQuery);