<?php
/**
 * The template part for selected header
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>

<section class="page_toplogo table_section table_section_md ds section_padding_top_25 section_padding_bottom_25">
	<div class="container">
		<div class="row">
			<div class="col-md-3 text-center text-md-left">
				<?php get_template_part( 'template-parts/header/header-logo' ); ?>
			</div>
			<div class="col-md-9 text-center text-md-right">
				<?php
				$toplogo_teasers = function_exists( 'fw_get_db_customizer_option' ) ? fw_get_db_customizer_option( 'toplogo_teasers' ) : '';
				if ( ! empty( $toplogo_teasers ) ) : ?>
					<div class="inline-teasers-wrap">
						<?php
						foreach ( $toplogo_teasers as $teaser ) :
							?>

							<div class="teaser small-teaser media">
								<div class="media-left media-middle">
									<div class="teaser_icon size_small border_icon highlight2 rounded"> <i class="<?php echo esc_attr( $teaser['teaser_icon'] ) ?>"></i> </div>
								</div>
								<div class="media-body media-middle">
									<h4><?php echo esc_html( $teaser['teaser_text_top'] ) ?></h4>
									<p class="greylinks fontsize_12">
										<?php if ( !empty ( $teaser['teaser_text_bottom_link'] ) ) : ?>
										<a href="<?php echo esc_url( $teaser['teaser_text_bottom_link'] ) ?>">
											<?php endif; ?>
											<?php echo esc_html( $teaser['teaser_text_bottom'] ) ?>
											<?php if ( !empty ( $teaser['teaser_text_bottom_link'] ) ) : ?>
										</a>
									<?php endif; ?>
									</p>
								</div>
							</div>
							<?php
						endforeach;
						?>
					</div>
				<?php endif; //social icons?>
			</div>
		</div>
	</div>
</section>