<?php
/**
 * The template part for selected header
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$left_teaser = function_exists( 'fw_get_db_customizer_option' ) ? fw_get_db_customizer_option( 'tl_left_teaser' ) : '';

$right_teaser1 = function_exists( 'fw_get_db_customizer_option' ) ? fw_get_db_customizer_option( 'tl_right_teaser1' ) : '';

$right_teaser2 = function_exists( 'fw_get_db_customizer_option' ) ? fw_get_db_customizer_option( 'tl_right_teaser2' ) : '';

?>

<section class="page_topline ls table_section section_padding_top_5 section_padding_bottom_5">
	<div class="container-fluid">
		<div class="row">
			<div class="col-sm-6 text-center text-sm-left">
				<p class="greylinks">
					<i class="<?php echo esc_html( $left_teaser['icon'] ) ?> grey rightpadding_5" aria-hidden="true"></i>
					<?php echo esc_html( $left_teaser['text'] ); ?>
				</p>
			</div>
			<div class="col-sm-6 text-center text-sm-right">
				<div class="inline-content">
					<?php if ( $right_teaser1['text'] ) : ?>
						<p class="greylinks">
							<i class="<?php echo esc_html( $right_teaser1['icon'] ) ?> grey rightpadding_5" aria-hidden="true"></i>
							<?php echo esc_html( $right_teaser1['text'] ); ?>
						</p>
					<?php endif; ?>
					<?php if ( $right_teaser2['text'] ) : ?>
						<p class="greylinks">
							<i class="<?php echo esc_html( $right_teaser2['icon'] ) ?> grey rightpadding_5" aria-hidden="true"></i>
							<?php if ( ! empty ( $right_teaser2['link'] ) ) : ?>
							<a href="<?php echo esc_url( $right_teaser2['link'] ) ?>">
								<?php endif; ?>
								<?php echo esc_html( $right_teaser2['text'] ); ?>
								<?php if ( ! empty ( $right_teaser2['link'] ) ) : ?>
							</a>
						<?php endif; ?>
						</p>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
</section>