<?php
/**
 * The template part for selected header
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
$social_icons = function_exists( 'fw_get_db_customizer_option' ) ? fw_get_db_customizer_option( 'social_icons' ) : '';
$header_phone = function_exists( 'fw_get_db_customizer_option' ) ? fw_get_db_customizer_option( 'header_phone' ) : '';
$header_email = function_exists( 'fw_get_db_customizer_option' ) ? fw_get_db_customizer_option( 'header_email' ) : '';

if ( ( ! empty( $social_icons ) ) || ( ! empty( $header_phone ) ) || ( ! empty( $header_email ) ) ) : ?>
<section class="page_topline ls section_padding_top_5 section_padding_bottom_5 table_section table_section_md">
	<div class="container">
		<div class="row">
			<div class="col-md-3 text-center text-md-left">
			<?php if ( ! empty( $social_icons ) ) : ?>
				<div class="page_social_icons darklinks">
					<?php
					//get icons-social shortcode to render icons in team member item
					$shortcodes_extension = fw()->extensions->get( 'shortcodes' );
					if ( ! empty( $shortcodes_extension ) ) {
						echo fw_ext( 'shortcodes' )->get_shortcode( 'icons_social' )->render( array( 'social_icons' => $social_icons ) );
					}
					?>
				</div><!-- eof social icons -->
			<?php endif; //social icons ?>
			</div><!-- eof .col- -->
			<div class="col-md-9 text-center text-md-right">
                <div class="inline-content small-text">
			<?php

				if ( $header_phone ) : ?>
					<span>
						<i class="rt-icon2-printer2 highlight rightpadding_5"></i> <?php echo esc_html( $header_phone ); ?>
					</span>
				<?php endif; //header_phone
				if ( $header_email ) : ?>
					<span>
						<i class="rt-icon2-mail highlight rightpadding_5"></i> <?php echo esc_html( $header_email ); ?>
					</span>
				<?php endif; //header_phone ?>
                </div>
			</div><!-- eof .col- -->
		</div>
	</div>
</section><!-- .page_topline -->
<?php endif; ?>
<header class="page_header header_white toggler_right">
    <div class="container">
        <div class="row">
            <div class="col-sm-12">
                <div class="display_table_md">
                    <div class="display_table_cell_md">
                        <?php
                        get_template_part( 'template-parts/header/header-logo' );
                        ?>
                    </div>
                    <div class="display_table_cell_md">
                        <nav class="mainmenu_wrapper primary-navigation text-md-right">
							<?php wp_nav_menu( array (
								'theme_location' => 'primary',
								'menu_class'     => 'sf-menu nav-menu nav',
								'container'      => 'ul'
							) ); ?>
                        </nav>
                        <span class="toggle_menu"><span></span></span>
                    </div>
                </div>
            </div><!--	eof .col-sm-* -->
        </div><!--	eof .row-->
    </div> <!--	eof .container-->
</header><!-- eof .page_header -->