<?php
/**
 * The default template for displaying content
 *
 * Used for both single and index/archive/search.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

//single item layout
if ( ! is_single() ) :
	$ext_team_settings = fw()->extensions->get( 'team' )->get_settings();
	$taxonomy_name = $ext_team_settings['taxonomy_name'];

	$pID = get_the_ID();
	$atts = fw_get_db_post_option($pID);
    ?>
    <article <?php post_class('vertical-item content-padding with_background bottom_color_border rounded text-center'); ?> >

		<?php if ( has_post_thumbnail() ) : ?>
            <div class="item-media">
				<?php
				$full_image_src = wp_get_attachment_url( get_post_thumbnail_id( $pID ) );
				the_post_thumbnail( 'acebeat-square-width' );
				?>
            </div>
		<?php endif; //has_post_thumbnail ?>
        <div class="item-content">

            <h4 class="bottommargin_0">
                <a href="<?php the_permalink(); ?>">
					<?php the_title(); ?>
                </a>
            </h4>
			<?php if ( ! empty( $atts['position'] ) ) : ?>
                <p class="small-text highlight"><?php echo wp_kses_post( $atts['position'] ); ?></p>
			<?php endif; //position ?>

			<?php if ( ! empty( $atts['social_icons'] ) ) : ?>
                <div>
					<?php
					//get icons-social shortcode to render icons in team member item
					$shortcodes_extension = fw()->extensions->get( 'shortcodes' );
					if ( ! empty( $shortcodes_extension ) ) {
						echo fw_ext( 'shortcodes' )->get_shortcode( 'icons_social' )->render( array( 'social_icons' => $atts['social_icons'], 'container_type' => 'divided-content' ) );
					}
					?>
                </div><!-- eof social icons -->
			<?php endif; //social icons ?>

        </div>
    </article><!-- eof .vertical-item -->
<?php endif;  //is singular ?>