<?php
/**
 * The default template for displaying content
 *
 * Used for both single and index/archive/search.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$show_post_thumbnail = ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) ? false : true;

$post_thumbnail = get_the_post_thumbnail( get_the_ID() );
$additional_post_class = ( $post_thumbnail ) ? 'bg_teaser after_cover darkgrey_bg' : '';

//single item layout
if ( is_singular() ) : ?>
    <article id="post-<?php the_ID(); ?>" <?php post_class( 'vertical-item content-padding big-padding with_background rounded overflow_hidden ' ); ?>>
		<?php acebeat_post_thumbnail(); ?>

        <div class="item-content">
            <header class="entry-header">

                <div class="entry-meta small-text content-justify">
				    <?php if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) ) : ?>

                        <span class="categories-links highlightlinks"><?php echo get_the_category_list( esc_html_x( ' ', 'Used between list items, there is a space after the comma.', 'acebeat' ) ); ?></span>

				    <?php endif; ?>

				    <?php
				    if ( 'post' == get_post_type() ) {
					    acebeat_posted_on( true );
				    } ?>
                </div>

                <h1 class="entry-title"><?php the_title(); ?></h1>

            </header><!-- .entry-header -->

	        <?php if ( !empty( $post->post_content ) ) : ?>
                <div class="entry-content">
			        <?php
			        the_content( esc_html__( 'Read More', 'acebeat' ) );
			        ?>
                </div><!-- .entry-content -->
	        <?php endif; // content check ?>

		    <?php
		    the_tags( '<div class="tag-links topmargin_30">', ' ', '</div>' );

		    wp_link_pages( array(
			    'before'      => '<div class="page-links highlightlinks topmargin_30"><span class="page-links-title">' . esc_html__( 'Pages:', 'acebeat' ) . '</span>',
			    'after'       => '</div>',
			    'link_before' => '<span>',
			    'link_after'  => '</span>',
		    ) );
		    ?>
        </div>

	    <?php if ( function_exists( 'mwt_share_this' ) ) : ?>
            <footer class="entry-meta small-text greylinks bottom_color_border">
                <div class="content-justify">
                    <div>
                        <span>Share:</span>
                        <span>
                            <?php acebeat_share_this( true ); ?>
                        </span>
                    </div>

				    <?php if ( function_exists( 'mwt_show_post_views_count' ) ) : ?>
                        <span>
                        <i class="fa fa-eye rightpadding_5" aria-hidden="true"></i>
                        <span class="value"><?php acebeat_show_post_views_count(); ?></span>
                    </span>
				    <?php endif; ?>
                </div>
            </footer>
	    <?php endif; ?>

    </article><!-- #post-## -->
	<?php acebeat_list_authors(); ?>
<?php
//eof single page layout
//blog feed layout
else: ?>
	<article id="post-<?php the_ID(); ?>" <?php post_class( 'ds vertical-item content-padding big-padding with_background rounded overflow_hidden text-center ' . $additional_post_class ); ?>>
		<?php
		echo wp_kses_post ( $post_thumbnail );
		?>

		<div class="item-content entry-content">
			<header class="entry-header">

                <?php
                global $post;
                //fw_print( $post );
                echo get_avatar( $post->post_author ); ?>
                <div class="topmargin_20">
	                <?php if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) ) : ?>

                        <span class="categories-links highlightlinks"><?php echo get_the_category_list( esc_html_x( ' ', 'Used between list items, there is a space after the comma.', 'acebeat' ) ); ?></span>

	                <?php endif; ?>
                </div>

                <div class="small-text darklinks">
                    <a href="<?php echo esc_url( get_permalink() ); ?>">
                        <time datetime="<?php echo esc_attr( get_the_date( 'c' ) ); ?>">
                            <?php echo esc_html( get_the_date() ); ?>
                        </time>
                    </a>
                </div>

                <?php
                the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
                ?>

			</header><!-- .entry-header -->

            <?php if ( !empty( $post->post_content ) ) : ?>
			<?php if ( is_search() ) : ?>
				<div class="entry-summary">
					<?php
					the_excerpt();
					?>
				</div><!-- .entry-summary -->
			<?php else : ?>
				<div class="entry-content">
				<?php
					the_content( esc_html__( 'Read More', 'acebeat' ) );
				?>
				</div><!-- .entry-content -->
			<?php endif; //is_search
        endif; // content check
        ?>
		</div><!-- eof .item-content -->
	</article><!-- #post-## -->
<?php endif;  //is singular