<?php
/**
 * The default template for displaying quote content
 *
 * Used for both single and index/archive/search.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$show_post_thumbnail = ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) ? false : true;

$post_thumbnail = get_the_post_thumbnail( get_the_ID() );
$additional_post_class = ( $post_thumbnail ) ? 'bg_teaser after_cover darkgrey_bg' : '';

//single item layout
if ( is_singular() ) : ?>
    <article id="post-<?php the_ID(); ?>" <?php post_class( 'vertical-item content-padding big-padding with_background rounded overflow_hidden' ); ?>>
		<?php acebeat_post_thumbnail(); ?>

        <div class="item-content">
			<?php if( function_exists( 'mwt_share_this' ) ) : ?>
                <header class="entry-header">

                    <div class="entry-meta small-text content-justify">
	                    <?php if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) ) : ?>
                            <span class="categories-links highlightlinks"><?php echo get_the_category_list( esc_html_x( ' ', 'Used between list items, there is a space after the comma.', 'acebeat' ) ); ?></span>

	                    <?php endif; ?>

	                    <?php
	                    if ( 'post' == get_post_type() ) {
		                    acebeat_posted_on( true );
	                    } ?>
                    </div>

                    <h1 class="entry-title"><?php the_title(); ?></h1>

                </header><!-- .entry-header -->
			<?php endif; ?>

	        <?php if ( !empty( $post->post_content ) ) : ?>
                <div class="entry-content">
			        <?php
			        the_content( esc_html__( 'Read More', 'acebeat' ) );
			        ?>
                </div><!-- .entry-content -->
	        <?php endif; // content check ?>

			<?php
			the_tags( '<div class="entry-meta"><span class="tag-links categories-links theme_buttons small_buttons inverse">', ' ', '</span></div>' );

			wp_link_pages( array(
				'before'      => '<div class="page-links highlightlinks topmargin_30"><span class="page-links-title">' . esc_html__( 'Pages:', 'acebeat' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
			) );
			?>
        </div>

	    <?php if ( function_exists( 'mwt_share_this' ) ) : ?>
            <footer class="entry-meta small-text greylinks bottom_color_border">
                <div class="content-justify">
                    <div>
                        <span>Share:</span>
                        <span>
                            <?php acebeat_share_this( true ); ?>
                        </span>
                    </div>

				    <?php if ( function_exists( 'mwt_show_post_views_count' ) ) : ?>
                        <span>
                        <i class="fa fa-eye rightpadding_5" aria-hidden="true"></i>
                        <span class="value"><?php acebeat_show_post_views_count(); ?></span>
                    </span>
				    <?php endif; ?>
                </div>
            </footer>
	    <?php endif; ?>

    </article><!-- #post-## -->
	<?php acebeat_list_authors(); ?>
<?php
//eof single page layout
//blog feed layout
else: ?>
	<article
		id="post-<?php the_ID(); ?>" <?php post_class( 'ds vertical-item content-padding big-padding with_background rounded overflow_hidden text-center ' . $additional_post_class ); ?>>
		<?php
		echo empty ( $post_thumbnail ) ? '<div class="bg_overlay"></div>' : '';
		echo wp_kses_post ( $post_thumbnail );
		?>

		<div class="item-content">

            <header class="entry-header">

                <div class="entry-meta small-text content-justify">
					<?php if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) ) : ?>

                        <span class="categories-links highlightlinks"><?php echo get_the_category_list( esc_html_x( ' ', 'Used between list items, there is a space after the comma.', 'acebeat' ) ); ?></span>

					<?php endif; ?>

	                <?php
	                if ( 'post' == get_post_type() ) { ?>
                        <span class="darklinks">
		                    <?php acebeat_posted_on( true ); ?>
                        </span>
	                <?php } ?>
                </div>

            </header><!-- .entry-header -->

            <div class="entry-content">
                <?php
                //hidding "more link" in content
                the_content( esc_html__( 'Read More', 'acebeat' ) );
                the_title( '<h3 class="entry-title bottommargin_0"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
                ?>
            </div><!-- .entry-content -->

		</div><!-- eof .item-content -->
	</article><!-- #post-## -->
<?php endif;  //is singular