<?php
/**
 * The default template for displaying link content
 *
 * Used for both single and index/archive/search.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$show_post_thumbnail = ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) ? false : true;

//single item layout
if ( is_singular() ) : ?>

	<article id="post-<?php the_ID(); ?>" <?php post_class( 'vertical-item content-padding big-padding with_background rounded overflow_hidden ' ); ?>>
		<?php acebeat_post_thumbnail(); ?>

        <div class="item-content">
            <header class="entry-header">

                <div class="entry-meta small-text content-justify">
					<?php if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) ) : ?>

                        <span class="categories-links highlightlinks"><?php echo get_the_category_list( esc_html_x( ' ', 'Used between list items, there is a space after the comma.', 'acebeat' ) ); ?></span>

					<?php endif; ?>

					<?php
					if ( 'post' == get_post_type() ) {
						acebeat_posted_on( true );
					} ?>
                </div>

                <h1 class="entry-title"><?php the_title(); ?></h1>

            </header><!-- .entry-header -->

	        <?php if ( !empty( $post->post_content ) ) : ?>
                <div class="entry-content">
			        <?php
			        the_content( esc_html__( 'Read More', 'acebeat' ) );
			        ?>
                </div><!-- .entry-content -->
	        <?php endif; // content check ?>

			<?php
			the_tags( '<div class="tag-links topmargin_30">', ' ', '</div>' );

			wp_link_pages( array(
				'before'      => '<div class="page-links highlightlinks topmargin_30"><span class="page-links-title">' . esc_html__( 'Pages:', 'acebeat' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
			) );
			?>
        </div>

		<?php if ( function_exists( 'mwt_share_this' ) ) : ?>
            <footer class="entry-meta small-text greylinks bottom_color_border">
                <div class="content-justify">
                    <div>
                        <span>Share:</span>
                        <span>
                            <?php acebeat_share_this( true ); ?>
                        </span>
                    </div>

					<?php if ( function_exists( 'mwt_show_post_views_count' ) ) : ?>
                        <span>
                        <i class="fa fa-eye rightpadding_5" aria-hidden="true"></i>
                        <span class="value"><?php acebeat_show_post_views_count(); ?></span>
                    </span>
					<?php endif; ?>
                </div>
            </footer>
		<?php endif; ?>

	</article><!-- #post-## -->
	<?php acebeat_list_authors(); ?>
<?php
//eof single page layout
//blog feed layout
else:
	?>
	<article id="post-<?php the_ID(); ?>" <?php post_class( 'vertical-item content-padding big-padding with_background rounded overflow_hidden ' ); ?>>
        <div class="item-content entry-content">

            <header class="entry-header">

				<?php if ( is_sticky() && is_home() && ! is_paged() ) {
					echo '<div class="featured-post grey"><i class="rt-icon2-clip highlight"></i>' . esc_html__( ' Sticky: ', 'acebeat' ) . '</div>';
				} ?>

                <div class="entry-meta small-text content-justify">
					<?php if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) ) : ?>

                        <span class="categories-links highlightlinks"><?php echo get_the_category_list( esc_html_x( ' ', 'Used between list items, there is a space after the comma.', 'acebeat' ) ); ?></span>

					<?php endif; ?>

					<?php
					if ( 'post' == get_post_type() ) {
						acebeat_posted_on( true );
					} ?>
                </div>

				<?php
				the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
				?>

            </header><!-- .entry-header -->

	        <?php if ( !empty( $post->post_content ) ) : ?>
		        <?php if ( is_search() ) : ?>
                    <div class="entry-summary">
				        <?php the_excerpt(); ?>
                    </div><!-- .entry-summary -->
		        <?php else : ?>
                    <div class="entry-content">
				        <?php
				        //hidding "more link" in content
				        the_content( esc_html__( 'Read More', 'acebeat' ) );

				        wp_link_pages( array(
					        'before'      => '<div class="page-links highlightlinks topmargin_30"><span class="page-links-title">' . esc_html__( 'Pages:', 'acebeat' ) . '</span>',
					        'after'       => '</div>',
					        'link_before' => '<span>',
					        'link_after'  => '</span>',
				        ) );
				        ?>

                    </div><!-- .entry-content -->

		        <?php endif; //is_search
	        endif; // content check
	        ?>

        </div><!-- eof .item-content -->

        <footer class="entry-meta entry-footer small-text greylinks bottom_color_border">
            <div class="inline-content">
				<?php
				printf( '<a href="%1$s"><i class="fa fa-user rightpadding_5" aria-hidden="true"></i><span>%2$s</span></a>',
					esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
					get_the_author()
				);
				?>

				<?php if ( comments_open() ) : ?>
                    <a href="<?php comments_link(); ?>">
                        <i class="fa fa-comment rightpadding_5" aria-hidden="true"></i>
                        <span class="value"><?php comments_number( "0", "1", "%" ); ?></span>
                    </a>
				<?php else: ?>
                    <span>
                    <i class="fa fa-comment rightpadding_5" aria-hidden="true"></i>
                    <span><?php echo esc_html__( 'Closed', 'acebeat' ); ?></span>
                </span>
				<?php endif; ?>
				<?php if ( function_exists( 'mwt_show_post_views_count' ) ) : ?>
                    <span>
                    <i class="fa fa-eye rightpadding_5" aria-hidden="true"></i>
                    <span class="value"><?php acebeat_show_post_views_count(); ?></span>
                </span>
				<?php endif; ?>
            </div>
        </footer>

	</article><!-- #post-## -->
<?php endif;  //is singular