<?php
/**
 * The default template for displaying event content
 *
 * Used for both single and index/archive/search.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$show_post_thumbnail = ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) ? false : true;

//single item layout
if ( is_singular() ) :
	//part of template for single event layout is overriden in framework-customizations/extensions/events/views/single.php
	?>

	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<?php acebeat_post_thumbnail(); ?>

		<header class="entry-header">

			<div class="entry-meta item-meta">
				<?php if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) && acebeat_categorized_blog() ) : ?>
					<span
						class="categories-links"><?php echo get_the_category_list( esc_html_x( ' ', 'Used between list items, there is a space after the comma.', 'acebeat' ) ); ?></span>
					<?php
				endif;

				if ( 'post' == get_post_type() ) {
					acebeat_posted_on();
				}
				?>
			</div><!-- .entry-meta -->

			<h1 class="entry-title"><?php the_title(); ?></h1>

		</header><!-- .entry-header -->

		<div class="entry-content">
			<?php
			the_content( esc_html__( 'Read More', 'acebeat' ) );
			?>
		</div><!-- .entry-content -->

		<?php the_tags( '<footer class="entry-meta"><span class="tag-links categories-links theme_buttons small_buttons color1">', ' ', '</span></footer>' ); ?>

		<?php
		wp_link_pages( array(
			'before'      => '<div class="page-links topmargin_30"><span class="page-links-title">' . esc_html__( 'Pages:', 'acebeat' ) . '</span>',
			'after'       => '</div>',
			'link_before' => '<span>',
			'link_after'  => '</span>',
		) );
		?>

	</article><!-- #post-## -->

	<?php
//eof single page layout
//blog feed layout
else:
	$options = ( function_exists( 'fw_get_db_post_option' ) ) ? fw_get_db_post_option( $post->ID, fw()->extensions->get( 'events' )->get_event_option_id() ) : false;

	//layout for events in feed is always two columns if it has a featured image
	$small_layout = ( ! $show_post_thumbnail ) ? false : true;
	if ( $small_layout ) : //additional markup for small layout post
		?>

		<article id="post-<?php the_ID(); ?>" <?php post_class( 'with_background rounded overflow_hidden ' ); ?>>
		<div class="side-item side-md content-padding">
		<div class="row">
		<?php acebeat_post_thumbnail( $small_layout ); ?>
		<div class="col-md-7">

	<?php else : //standard layout markup ?>
		<article id="post-<?php the_ID(); ?>" <?php post_class( 'vertical-item content-padding with_background rounded overflow_hidden' ); ?>>
		<?php
		acebeat_post_thumbnail();
	endif; //small_format check
	?>
	<div class="item-content entry-content">
		<header class="entry-header bottommargin_20">
			<?php
			the_title( '<h4 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h4>' );

			if ( $options ): ?>
				<div class="entry-meta content-justify greylinks small-text">
					<?php
					if ( ! empty( $options['event_children'][0] ) ) :
						if ( $options['event_children'][0]['event_date_range']['from'] ) : ?>
                            <span class="rightpadding_20">
                            <i class="fa fa-calendar highlight rightpadding_5" aria-hidden="true"></i>
							<?php
							echo esc_html( $options['event_children'][0]['event_date_range']['from'] ); ?>
							</span>
						<?php endif;
					endif;

					if ( $options['event_location']['venue'] ) : ?>
                        <span>
                            <i class="fa fa-map-marker highlight rightpadding_5" aria-hidden="true"></i>
	                        <?php echo esc_html( $options['event_location']['venue'] ); ?>
                        </span>
					<?php endif; ?>
				</div>
			<?php endif; //$options check 
			?>
		</header><!-- .entry-header -->

		<?php if ( is_search() ) : ?>
			<div class="entry-summary">
				<?php the_excerpt(); ?>
			</div><!-- .entry-summary -->
		<?php else : ?>
			<div class="entry-content">
				<?php
				//hidding "more link" in content
				the_content( esc_html__( 'Read More', 'acebeat' ) );

				//categories
				if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) && acebeat_categorized_blog() ) :
					?>
					<div
						class="categories-links topmargin_20"><?php echo get_the_category_list( esc_html_x( ' ', 'Used between list items, there is a space after the comma.', 'acebeat' ) ); ?></div>
				<?php endif; //categories

				wp_link_pages( array(
					'before'      => '<div class="page-links topmargin_30"><span class="page-links-title">' . esc_html__( 'Pages:', 'acebeat' ) . '</span>',
					'after'       => '</div>',
					'link_before' => '<span>',
					'link_after'  => '</span>',
				) );
				?>
			</div><!-- .entry-content -->
		<?php endif; ?>

		<?php

		//not showing tags in feed
		//the_tags( '', '' ); 
		?>
	</div><!-- eof .item-content -->
    <footer class="entry-meta entry-footer small-text greylinks bottom_color_border">
        <div class="inline-content">
			<?php
			printf( '<a href="%1$s"><i class="fa fa-user rightpadding_5" aria-hidden="true"></i><span>%2$s</span></a>',
				esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
				get_the_author()
			);
			?>

			<?php if ( comments_open() ) : ?>
                <a href="<?php comments_link(); ?>">
                    <i class="fa fa-comment rightpadding_5" aria-hidden="true"></i>
                    <span class="value"><?php comments_number( "0", "1", "%" ); ?></span>
                </a>
			<?php else: ?>
                <span>
                    <i class="fa fa-comment rightpadding_5" aria-hidden="true"></i>
                    <span><?php echo esc_html__( 'Comments closed', 'acebeat' ); ?></span>
                </span>
			<?php endif; ?>
			<?php if ( function_exists( 'mwt_show_post_views_count' ) ) : ?>
                <span>
                    <i class="fa fa-eye rightpadding_5" aria-hidden="true"></i>
                    <span class="value"><?php acebeat_show_post_views_count(); ?></span>
                </span>
			<?php endif; ?>
        </div>
    </footer>
	<?php if ( $small_layout ) : //additional markup for small format post  ?>
	</div><!-- eof .col-md-6 -->
	</div><!-- eof .row -->
	</div><!-- eof .side-item -->
<?php endif; //small_format 
	?>
	</article><!-- #post-## -->

<?php endif;  //is singular ?>