<?php

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}


//remove page title in shop page
add_filter( 'woocommerce_show_page_title', 'acebeat_filter_remove_shop_title_in_content' );
if ( ! function_exists( 'acebeat_filter_remove_shop_title_in_content' ) ) :
	function acebeat_filter_remove_shop_title_in_content() {
		return false;
	}
endif;

//remove wrappers
remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );
remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10 );

//wrap in col-sm- and .columns-2 all products on shop page
add_action( 'woocommerce_before_shop_loop', 'acebeat_action_echo_div_wraps_before_shop_loop' );
if ( ! function_exists( 'acebeat_action_echo_div_wraps_before_shop_loop' ) ) :
	function acebeat_action_echo_div_wraps_before_shop_loop() {
		$column_classes = acebeat_get_columns_classes();
		$columns_amount = ( $column_classes[ 'main_column_class' ] === 'col-xs-12' ) ? 3 : 2;
		echo '<div id="content_products" class="' . esc_attr( $column_classes[ 'main_column_class' ] ) . '">';
		if ( function_exists( 'wc_get_loop_prop' ) ) {
			echo '<div class="columns-' . esc_attr( wc_get_loop_prop( 'columns' ) ) . '">';
		} else {
			echo '<div class="columns-' . $columns_amount . '">';
		}
		echo '<div class="form-inline content-justify vertical-center">';
	}
endif;

//before shop loop - removing breadcrumbs and results count
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
//wrapping sort form in div and adding view toggle button
add_action( 'woocommerce_before_shop_loop', 'acebeat_action_before_shop_loop_wrap_form', 15 );
if ( ! function_exists( 'acebeat_action_before_shop_loop_wrap_form' ) ) :
	function acebeat_action_before_shop_loop_wrap_form() {
		echo '<div class="storefront-sorting">';
	}
endif;

if ( ! function_exists( 'acebeat_action_before_shop_loop_wrap_form_close_first' ) ) :
	function acebeat_action_before_shop_loop_wrap_form_close_first() {
		woocommerce_result_count();
	}
endif;

add_action( 'woocommerce_before_shop_loop', 'acebeat_action_before_shop_loop_wrap_form_close_first', 10 );

if ( ! function_exists( 'acebeat_action_before_shop_loop_wrap_form_close_second' ) ) :
	function acebeat_action_before_shop_loop_wrap_form_close_second() {
		echo '</div>';
		echo '</div>';
	}
endif;

add_action( 'woocommerce_before_shop_loop', 'acebeat_action_before_shop_loop_wrap_form_close_second', 40 );

//start loop - adding classes to products ul
if ( ! function_exists( 'woocommerce_product_loop_start' ) ) :
	function woocommerce_product_loop_start( $echo = true ) {
		//id products is necessary for scripts

		$html                                    = '<ul class="products list-unstyled">';
		$GLOBALS[ 'woocommerce_loop' ][ 'loop' ] = 0;
		if ( $echo ) {
			echo wp_kses_post( $html );
		} else {
			return $html;
		}
	}
endif;

//loop pagination
//closing main column and getting sidebar if exist
remove_action( 'woocommerce_after_shop_loop', 'woocommerce_pagination' );
add_action( 'woocommerce_after_shop_loop', 'acebeat_action_echo_div_columns_after_shop_loop' );
if ( ! function_exists( 'acebeat_action_echo_div_columns_after_shop_loop' ) ):
	function acebeat_action_echo_div_columns_after_shop_loop() {
		echo '</div><!-- eof .columns-2 -->';
		$pagination_html = acebeat_bootstrap_paginate_links();
		if ( $pagination_html ) {
			echo '<div class="text-center">';
			echo wp_kses_post( $pagination_html );
			echo '</div>';
		}
		echo '</div><!-- eof #content_products -->';
		$column_classes = acebeat_get_columns_classes();
		if ( $column_classes[ 'sidebar_class' ] ): ?>
			<!-- main aside sidebar -->
			<aside class="<?php echo esc_attr( $column_classes[ 'sidebar_class' ] ); ?>">
				<?php get_sidebar(); ?>
			</aside>
			<!-- eof main aside sidebar -->
			<?php
		endif;
	}
endif;

// single product in shop loop
remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
//start of loop item
add_action( 'woocommerce_before_shop_loop_item', 'acebeat_action_echo_markup_before_shop_loop_item' );
if ( ! function_exists( 'acebeat_action_echo_markup_before_shop_loop_item' ) ):
	function acebeat_action_echo_markup_before_shop_loop_item() {
		echo '<div class="vertical-item content-padding with_background rounded bottom_color_border text-center">';
		echo '<div class="item-media">';

		woocommerce_template_loop_product_link_open();
	}
endif;

add_action( 'woocommerce_before_shop_loop_item_title', 'acebeat_action_echo_markup_before_shop_loop_item_title' );
if ( ! function_exists( 'acebeat_action_echo_markup_before_shop_loop_item_title' ) ):
	function acebeat_action_echo_markup_before_shop_loop_item_title() {
		woocommerce_template_loop_product_link_close();
		echo '</div> <!-- eof .item-media -->';
		echo '<div class="item-content with_border bottom_rounded">';

		echo '<div class="item-meta small-text content-justify vertical-center">';
            woocommerce_template_loop_price();
		    woocommerce_template_loop_rating();
		echo '</div>';

		woocommerce_template_loop_product_link_open();
	}
endif;

add_action( 'woocommerce_after_shop_loop_item_title', 'acebeat_action_echo_markup_after_shop_loop_item_title' );
if ( ! function_exists( 'acebeat_action_echo_markup_after_shop_loop_item_title' ) ):
	function acebeat_action_echo_markup_after_shop_loop_item_title() {
		woocommerce_template_loop_product_link_close();


		//product short description
		global $post;
		echo apply_filters( 'woocommerce_short_description', $post->post_excerpt );

		woocommerce_template_loop_add_to_cart( array( 'class' => 'add_to_cart_button theme_button inverse' ) );
	}
endif;

//end of loop item
add_action( 'woocommerce_after_shop_loop_item', 'acebeat_action_echo_markup_after_shop_loop_item' );
if ( ! function_exists( 'acebeat_action_echo_markup_after_shop_loop_item' ) ):
	function acebeat_action_echo_markup_after_shop_loop_item() {
		echo '</div> <!-- eof .item-content -->';
		echo '</div> <!-- eof .vertical-item -->';
	}
endif;

//single product view
//single product image and summary layout
//wrap in col-sm- and .columns-2 all products on shop page
add_action( 'woocommerce_before_single_product', 'acebeat_action_echo_div_columns_before_single_product' );
if ( ! function_exists( 'acebeat_action_echo_div_columns_before_single_product' ) ):
	function acebeat_action_echo_div_columns_before_single_product() {
		$column_classes = acebeat_get_columns_classes();
		echo '<div id="content_product" class="' . esc_attr( $column_classes[ 'main_column_class' ] ) . '">';
	}
endif;

add_action( 'woocommerce_after_single_product', 'acebeat_action_echo_div_columns_after_single_product' );
if ( ! function_exists( 'acebeat_action_echo_div_columns_after_single_product' ) ):
	function acebeat_action_echo_div_columns_after_single_product() {
		echo '</div> <!-- eof .col- -->';
		$column_classes = acebeat_get_columns_classes();
		if ( $column_classes[ 'sidebar_class' ] ): ?>
			<!-- main aside sidebar -->
			<aside class="<?php echo esc_attr( $column_classes[ 'sidebar_class' ] ); ?>">
				<?php get_sidebar(); ?>
			</aside>
			<!-- eof main aside sidebar -->
			<?php
		endif;
	}
endif;

remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );
//add_action('woocommerce_product_thumbnails', 'woocommerce_show_product_sale_flash', 9 );
add_filter( 'woocommerce_single_product_image_html', 'acebeat_filter_put_onsale_span_in_main_image' );
if ( ! function_exists( 'acebeat_filter_put_onsale_span_in_main_image' ) ):
	function acebeat_filter_put_onsale_span_in_main_image( $html ) {
		return $html . woocommerce_show_product_sale_flash();
	}
endif;

add_action( 'woocommerce_product_thumbnails', 'acebeat_action_echo_closing_div_before_single_product_thumbnails', 9 );
if ( ! function_exists( 'acebeat_action_echo_closing_div_before_single_product_thumbnails' ) ):
	function acebeat_action_echo_closing_div_before_single_product_thumbnails() {
		echo '</div><!--eof .images -->';
		echo '<div class="thumbnails-wrap">';
	}
endif;

add_action( 'woocommerce_before_single_product_summary', 'acebeat_action_echo_div_columns_before_single_product_summary', 9 );
if ( ! function_exists( 'acebeat_action_echo_div_columns_before_single_product_summary' ) ):
	function acebeat_action_echo_div_columns_before_single_product_summary() {
		echo '<div class="row">';
		echo '<div class="col-sm-6">';
	}
endif;

add_action( 'woocommerce_before_single_product_summary', 'acebeat_action_echo_div_close_first_column_before_single_product_summary', 21 );
if ( ! function_exists( 'acebeat_action_echo_div_close_first_column_before_single_product_summary' ) ):
	function acebeat_action_echo_div_close_first_column_before_single_product_summary() {
		echo '</div><!-- eof .col-sm- with single product images -->';
		echo '<div class="col-sm-6">';
	}
endif;

add_action( 'woocommerce_after_single_product_summary', 'acebeat_action_echo_div_close_columns_after_single_product_summary', 9 );
if ( ! function_exists( 'acebeat_action_echo_div_close_columns_after_single_product_summary' ) ):
	function acebeat_action_echo_div_close_columns_after_single_product_summary() {
		echo '</div> <!--eof .col-sm- .summary -->';
		echo '</div> <!--eof .row -->';
	}
endif;

//elements in single product summary
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );

add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 15 );
add_action( 'woocommerce_single_product_summary', 'acebeat_action_echo_template_single_meta', 20 );
if ( ! function_exists( 'acebeat_action_echo_template_single_meta' ) ):
	function acebeat_action_echo_template_single_meta() {
		echo '<div class="small-text weight-black greylinks">';
		woocommerce_template_single_meta();
		echo '</div>';
	}
endif;

add_action( 'woocommerce_before_add_to_cart_button', 'acebeat_action_echo_open_div_before_add_to_cart_button' );
if ( ! function_exists( 'acebeat_action_echo_open_div_before_add_to_cart_button' ) ):
	function acebeat_action_echo_open_div_before_add_to_cart_button() {
		if ( function_exists( 'mwt_share_this' ) ) {
			acebeat_share_this( true );
		}
		echo '<div class="content-justify vertical-center">';
	}
endif;

add_action( 'woocommerce_after_add_to_cart_button', 'acebeat_action_echo_open_div_after_add_to_cart_button' );
if ( ! function_exists( 'acebeat_action_echo_open_div_after_add_to_cart_button' ) ):
	function acebeat_action_echo_open_div_after_add_to_cart_button() {
		echo '</div>';
	}
endif;

//account navigation
add_action( 'woocommerce_before_account_navigation', 'acebeat_action_woocommerce_before_account_navigation' );
if ( ! function_exists( 'acebeat_action_woocommerce_before_account_navigation' ) ):
	function acebeat_action_woocommerce_before_account_navigation() {
		echo '<div class="small-text darklinks">';
	}
endif;

add_action( 'woocommerce_after_account_navigation', 'acebeat_action_woocommerce_after_account_navigation' );
if ( ! function_exists( 'acebeat_action_woocommerce_after_account_navigation' ) ):
	function acebeat_action_woocommerce_after_account_navigation() {
		echo '</div><!-- eof theme_buttons -->';
	}
endif;