<?php if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}
/**
 * Include static files: javascript and css
 */

//removing default font awesome css style - we using our "fonts.css" file which contain font awesome
wp_deregister_style( 'fw-font-awesome' );

//Add Theme Fonts
wp_enqueue_style(
	'acebeat-icon-fonts',
	ACEBEAT_THEME_URI . '/css/fonts.css',
	array(),
	ACEBEAT_THEME_VERSION
);

if ( is_admin_bar_showing() ) {
	//Add Frontend admin styles
	wp_register_style(
		'acebeat-admin_bar',
		ACEBEAT_THEME_URI . '/css/admin-frontend.css',
		array(),
		ACEBEAT_THEME_VERSION
	);
	wp_enqueue_style( 'acebeat-admin_bar' );
}

//styles and scripts below only for frontend: if in dashboard - exit
if ( is_admin() ) {
	return;
}

/**
 * Enqueue scripts and styles for the front end.
 */
// Add theme google font, used in the main stylesheet.
wp_enqueue_style(
	'acebeat-font',
	acebeat_google_font_url(),
	array(),
	ACEBEAT_THEME_VERSION
);

if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
	wp_enqueue_script( 'comment-reply' );
}

if ( is_singular() && wp_attachment_is_image() ) {
	wp_enqueue_script(
		'acebeat-keyboard-image-navigation',
		ACEBEAT_THEME_URI . '/js/keyboard-image-navigation.js',
		array( 'jquery' ),
		ACEBEAT_THEME_VERSION
	);
}

//plugins theme script
wp_enqueue_script(
	'acebeat-modernizr',
	ACEBEAT_THEME_URI . '/js/vendor/modernizr-2.6.2.min.js',
	false,
	'2.6.2',
	false
);

//plugins theme script
wp_enqueue_script(
	'acebeat-compressed',
	ACEBEAT_THEME_URI . '/js/compressed.js',
	array( 'jquery' ),
	ACEBEAT_THEME_VERSION,
	true
);
//custom plugins theme script
wp_enqueue_script(
	'acebeat-plugins',
	ACEBEAT_THEME_URI . '/js/plugins.js',
	array( 'jquery' ),
	ACEBEAT_THEME_VERSION,
	true
);


//getting theme color scheme number
$color_scheme_number = function_exists( 'fw_get_db_customizer_option' ) ? fw_get_db_customizer_option( 'color_scheme_number' ) : '';

//if WooCommerce - remove prettyPhoto - we have one in "compressed.js"
if ( class_exists( 'WooCommerce' ) ) :
	wp_dequeue_script( 'prettyPhoto' );
	wp_dequeue_script( 'prettyPhoto-init' );
	wp_deregister_style( 'woocommerce_prettyPhoto_css' );

	// Add Theme Woo Styles and Scripts
	wp_enqueue_style(
		'acebeat-woo',
		ACEBEAT_THEME_URI . '/css/woo' . esc_attr( $color_scheme_number ) . '.css',
		array(),
		ACEBEAT_THEME_VERSION
	);

	wp_enqueue_script(
		'acebeat-woo',
		ACEBEAT_THEME_URI . '/js/woo.js',
		array( 'jquery' ),
		ACEBEAT_THEME_VERSION,
		true
	);
endif; //WooCommerce

//main theme script
wp_enqueue_script(
	'acebeat-main',
	ACEBEAT_THEME_URI . '/js/main.js',
	array( 'jquery' ),
	ACEBEAT_THEME_VERSION,
	true
);

//if AccessPress is active
if ( class_exists( 'SC_Class' ) ) :
	wp_deregister_style( 'fontawesome-css' );
	wp_deregister_style( 'apsc-frontend-css' );
	wp_enqueue_style(
		'acebeat-accesspress',
		ACEBEAT_THEME_URI . '/css/accesspress.css',
		array(),
		ACEBEAT_THEME_VERSION
	);
endif; //AccessPress

//Add Theme Booked Styles
if( class_exists('booked_plugin')) {
	wp_dequeue_style('booked-styles');
	wp_dequeue_style('booked-responsive');
	wp_enqueue_style(
		'acebeat-booked',
		ACEBEAT_THEME_URI . '/css/booked' . esc_attr( $color_scheme_number ) . '.css',
		array(),
		'1.0.1'
	);
}//Booked


// Add Theme stylesheet.
wp_enqueue_style( 'acebeat-css-style', get_stylesheet_uri() );

// Add Bootstrap Style
wp_enqueue_style(
	'bootstrap',
	ACEBEAT_THEME_URI . '/css/bootstrap.min.css',
	array(),
	ACEBEAT_THEME_VERSION
);

// Add Animations Style
wp_enqueue_style(
	'acebeat-animations',
	ACEBEAT_THEME_URI . '/css/animations.css',
	array(),
	ACEBEAT_THEME_VERSION
);

// Add Theme Style
wp_enqueue_style(
	'acebeat-main',
	ACEBEAT_THEME_URI . '/css/main' . esc_attr( $color_scheme_number ) . '.css',
	array(),
	ACEBEAT_THEME_VERSION
);
wp_add_inline_style( 'acebeat-main', acebeat_add_font_styles_in_head() );