<?php if (!defined('FW')) {
	die('Forbidden');
}
/**
 * Framework options
 *
 * @var array $options Fill this array with options to generate framework settings form in WordPress customizer
 */

//find fw_ext
$shortcodes_extension = fw()->extensions->get('shortcodes');
$header_social_icons  = array();
if (!empty($shortcodes_extension)) {
	$header_social_icons = $shortcodes_extension->get_shortcode('icons_social')->get_options();
}

$slider_extension = fw()->extensions->get('slider');
$choices = '';
if (!empty($slider_extension)) {
	$choices = $slider_extension->get_populated_sliders_choices();
}

//adding empty value to disable slider
$choices['0'] = esc_html__('No Slider', 'acebeat');

$options = array(
	'logo_section'    => array(
		'title'   => esc_html__('Site Logo', 'acebeat'),
		'options' => array(
			'logo_image'             => array(
				'type'        => 'upload',
				'value'       => array(),
				'attr'        => array('class' => 'logo_image-class', 'data-logo_image' => 'logo_image'),
				'label'       => esc_html__('Main logo image that appears in header', 'acebeat'),
				'desc'        => esc_html__('Select your logo', 'acebeat'),
				'help'        => esc_html__('Choose image to display as a site logo', 'acebeat'),
				'images_only' => true,
				'files_ext'   => array('png', 'jpg', 'jpeg', 'gif'),
			),
			'logo_text'              => array(
				'type'  => 'text',
				'value' => 'Acebeat',
				'attr'  => array('class' => 'logo_text-class', 'data-logo_text' => 'logo_text'),
				'label' => esc_html__('Logo Text', 'acebeat'),
				'desc'  => esc_html__('Text that appears if logo image not set', 'acebeat'),
				'help'  => esc_html__('Type your text to show it in logo', 'acebeat'),
			),
			'footer_logo_image'             => array(
				'type'        => 'upload',
				'value'       => array(),
				'attr'        => array('class' => 'logo_image-class', 'data-logo_image' => 'logo_image'),
				'label'       => esc_html__('Logo image that appears in footer', 'acebeat'),
				'desc'        => esc_html__('Select your logo', 'acebeat'),
				'help'        => esc_html__('Choose image to display in footer', 'acebeat'),
				'images_only' => true,
				'files_ext'   => array('png', 'jpg', 'jpeg', 'gif'),
			),
		),
	),
	'layout'          => array(
		'title'   => esc_html__('Theme Layout', 'acebeat'),
		'options' => array(
			'layout' => array(
				'type'    => 'multi-picker',
				'value'   => 'wide',
				'attr'    => array('class' => 'theme-layout-class', 'data-theme-layout' => 'layout'),
				'label'   => esc_html__('Theme layout', 'acebeat'),
				'desc'    => esc_html__('Wide or Boxed layout', 'acebeat'),
				'picker'  => array(
					'boxed' => array(
						'type'         => 'switch',
						'value'        => '',
						'label'        => false,
						'desc'         => false,
						'left-choice'  => array(
							'value' => '',
							'label' => esc_html__('Wide', 'acebeat'),
						),
						'right-choice' => array(
							'value' => 'boxed_options',
							'label' => esc_html__('Boxed', 'acebeat'),
						),
					),
				),
				'choices' => array(
					'boxed_options' => array(
						'body_background_image' => array(
							'type'        => 'upload',
							'value'       => '',
							'label'       => esc_html__('Body background image', 'acebeat'),
							'help'        => esc_html__('Choose body background image if needed.', 'acebeat'),
							'images_only' => true,
						),
						'body_cover'            => array(
							'type'         => 'switch',
							'value'        => '',
							'label'        => esc_html__('Parallax background', 'acebeat'),
							'desc'         => esc_html__('Enable full width background for body', 'acebeat'),
							'left-choice'  => array(
								'value' => '',
								'label' => esc_html__('No', 'acebeat'),
							),
							'right-choice' => array(
								'value' => 'yes',
								'label' => esc_html__('Yes', 'acebeat'),
							),
						),
					),
				),

			),
		),
	),
	'version'         => array(
		'title'   => esc_html__('Theme Variant', 'acebeat'),
		'options' => array(
			'version' => array(
				'type'    => 'radio',
				'value'   => 'light',
				'attr'    => array('class' => 'theme-layout-class', 'data-theme-layout' => 'layout'),
				'label'   => esc_html__('Theme Version', 'acebeat'),
				'desc'    => esc_html__('Light or dark version', 'acebeat'),
				'help'    => esc_html__('Select one of predefined versions', 'acebeat'),
				'choices' => array( // Note: Avoid bool or int keys http://bit.ly/1cQgVzk
					'light' => esc_html__('Light', 'acebeat'),
					'dark'  => esc_html__('Dark', 'acebeat'),
				),
				// Display choices inline instead of list
				'inline'  => true,
			),
		),
	),
	'color_scheme_number'     => array(
		'title'   => esc_html__('Theme Color Scheme', 'acebeat'),
		'options' => array(
			'color_scheme_number' => array(
				'type'    => 'image-picker',
				'value'   => '',
				'label'   => esc_html__('Color scheme', 'acebeat'),
				'desc'    => esc_html__('Select one of predefined theme main colors', 'acebeat'),
				'choices' => array(
					'' => ACEBEAT_THEME_URI . '/img/theme-options/color_scheme1.png',
					'2' => ACEBEAT_THEME_URI . '/img/theme-options/color_scheme2.png',
					'3' => ACEBEAT_THEME_URI . '/img/theme-options/color_scheme3.png',
				),
				'blank'   => false, // (optional) if true, image can be deselected
			),

		),
	),
	'blog_posts' => array(
		'title'   => esc_html__('Theme Blog', 'acebeat'),
		'options' => array(
			'blog_slider_switch' => array(
				'type'    => 'multi-picker',
				'label'   => false,
				'desc'    => false,
				'picker'  => array(
					'blog_slider_enabled' => array(
						'type'         => 'switch',
						'value'        => '',
						'label'        => esc_html__('Post slider', 'acebeat'),
						'desc'         => esc_html__('Enable slider on blog page', 'acebeat'),
						'left-choice'  => array(
							'value' => '',
							'label' => esc_html__('No', 'acebeat'),
						),
						'right-choice' => array(
							'value' => 'yes',
							'label' => esc_html__('Yes', 'acebeat'),
						),
					),
				),
				'choices' => array(
					'yes' => array(
						'slider_id' => array(
							'type'    => 'select',
							'value'   => '',
							'label'   => esc_html__('Select Slider', 'acebeat'),
							'choices' => $choices
						),
					),
				),
			),
		)
	),
	'topline'     => array(
		'title'   => esc_html__('Theme Top line', 'acebeat'),
		'options' => array(

			'tl_visible'   => array(
				'type'  => 'switch',
				'value' => true,
				'label' => esc_html__('Show Top line', 'acebeat'),
				'left-choice' => array(
					'value' => false,
					'label' => esc_html__('No', 'acebeat'),
				),
				'right-choice' => array(
					'value' => true,
					'label' => esc_html__('Yes', 'acebeat'),
				),
			),
			'tl_left_teaser'    => array(
				'type'  => 'multi',
				'value' => array(
					'icon' => 'fa fa-clock-o',
					'text' => 'Opening Hours: Weekdays 8.00-20.00',
					'link' => ''
				),
				'label' => esc_html__('Left Teaser', 'acebeat'),
				'inner-options'    => array(
					'icon'       => array(
						'type'  => 'icon',
						'label' => esc_html__('Icon', 'acebeat'),
						'set'   => 'rt-icons-2',
					),
					'text'  => array(
						'type'  => 'text',
					),
				)
			),
		)
	),
	'toplogo'     => array(
		'title'   => esc_html__('Theme Top logo', 'acebeat'),
		'options' => array(
			'toplogo_teasers' => array(
				'type'  => 'addable-box',
				'label' => esc_html__('Top logo teasers', 'acebeat'),
				'desc'  => esc_html__('Chose icon and enter teaser text', 'acebeat'),
				'template'    => '{{=teaser_text}}',
				'box-options' => array(
					'teaser_icon' => array(
						'type' => 'icon-v2',
						'label' => esc_html__('Icon', 'acebeat'),
					),
					'teaser_text' => array(
						'type' => 'text',
						'label' => esc_html__('Teaser text', 'acebeat'),
					),
					'teaser_text_link' => array(
						'type' => 'text',
						'label' => esc_html__('Teaser link', 'acebeat'),
					),
				),
			),
		)
	),
	'headers'     => array(
		'title'   => esc_html__('Theme Header', 'acebeat'),
		'options' => array(

			'header'       => array(
				'type'    => 'image-picker',
				'value'   => '1',
				'attr'    => array(
					'class'    => 'header-thumbnail',
					'data-foo' => 'header',
				),
				'label'   => esc_html__('Template Header', 'acebeat'),
				'desc'    => esc_html__('Select one of predefined theme headers', 'acebeat'),
				'help'    => esc_html__('You can select one of predefined theme headers', 'acebeat'),
				'choices' => array(
					'1' => ACEBEAT_THEME_URI . '/img/theme-options/header1.png',
					'2' => ACEBEAT_THEME_URI . '/img/theme-options/header2.png',
					'3' => ACEBEAT_THEME_URI . '/img/theme-options/header3.png',
					'4' => ACEBEAT_THEME_URI . '/img/theme-options/header4.png',
					'10' => ACEBEAT_THEME_URI . '/img/theme-options/header10.png',
					'21' => ACEBEAT_THEME_URI . '/img/theme-options/header21.png',
					'22' => ACEBEAT_THEME_URI . '/img/theme-options/header22.png',
					'23' => ACEBEAT_THEME_URI . '/img/theme-options/header23.png',
					'24' => ACEBEAT_THEME_URI . '/img/theme-options/header24.png',
				),
				'blank'   => false, // (optional) if true, image can be deselected
			),
			'header_phone' => array(
				'type'  => 'text',
				'value' => esc_html__('1(800)555-12-34', 'acebeat'),
				'label' => esc_html__('Phone number', 'acebeat'),
				'desc'  => esc_html__('Number to appear in header', 'acebeat'),
				'help'  => esc_html__('Not all headers display this info', 'acebeat'),
			),
			'header_email' => array(
				'type'  => 'text',
				'value' => esc_html__('info@company.com', 'acebeat'),
				'label' => esc_html__('Email', 'acebeat'),
				'desc'  => esc_html__('Email to appear in header', 'acebeat'),
				'help'  => esc_html__('Not all headers display this info', 'acebeat'),
			),
			$header_social_icons,
			'header_button_label' => array(
				'type'  => 'text',
				'value' => esc_html__('Buy Tickets', 'acebeat'),
				'label' => esc_html__('Header Button Label', 'acebeat'),
				'help'  => esc_html__('Button that appear in header', 'acebeat'),
			),
			'header_button_link' => array(
				'type'  => 'text',
				'value' => esc_html__('index.php/contact', 'acebeat'),
				'label' => esc_html__('Header Button Link', 'acebeat'),
				'help'  => esc_html__('Button that appear in header', 'acebeat'),
			),
		),
	),
	'breadcrumbs'     => array(
		'title'   => esc_html__('Theme Title Section', 'acebeat'),
		'options' => array(

			'breadcrumbs' => array(
				'type'    => 'image-picker',
				'value'   => '1',
				'attr'    => array(
					'class'    => 'breadcrumbs-thumbnail',
					'data-foo' => 'breadcrumbs',
				),
				'label'   => esc_html__('Page title sections with optional breadcrumbs', 'acebeat'),
				'desc'    => esc_html__('Select one of predefined page title sections. Install Unyson Breadcrumbs extension to display breadcrumbs', 'acebeat'),
				'help'    => esc_html__('You can select one of predefined theme title sections', 'acebeat'),
				'choices' => array(
					'1' => ACEBEAT_THEME_URI . '/img/theme-options/breadcrumbs1.png',
					'2' => ACEBEAT_THEME_URI . '/img/theme-options/breadcrumbs2.png',
					'3' => ACEBEAT_THEME_URI . '/img/theme-options/breadcrumbs3.png',
					'4' => ACEBEAT_THEME_URI . '/img/theme-options/breadcrumbs4.png',
					'5' => ACEBEAT_THEME_URI . '/img/theme-options/breadcrumbs5.png',
				),
				'blank'   => false, // (optional) if true, image can be deselected
			),

		),
	),
	'footer'          => array(
		'title'   => esc_html__('Theme Footer', 'acebeat'),
		'options' => array(

			'footer' => array(
				'type'    => 'image-picker',
				'value'   => '1',
				'attr'    => array(
					'class'    => 'footer-thumbnail',
					'data-foo' => 'footer',
				),
				'label'   => esc_html__('Page footer', 'acebeat'),
				'desc'    => esc_html__('Select one of predefined page footers.', 'acebeat'),
				'help'    => esc_html__('You can select one of predefined theme footers', 'acebeat'),
				'choices' => array(
					'1' => ACEBEAT_THEME_URI . '/img/theme-options/footer1.png',
					'2' => ACEBEAT_THEME_URI . '/img/theme-options/footer2.png',
				),
				'blank'   => false, // (optional) if true, image can be deselected
			),

		),
	),
	'copyrights'      => array(
		'title'   => esc_html__('Theme Copyrights', 'acebeat'),
		'options' => array(

			'copyrights'      => array(
				'type'    => 'image-picker',
				'value'   => '1',
				'attr'    => array(
					'class'    => 'copyrights-thumbnail',
					'data-foo' => 'copyrights',
				),
				'label'   => esc_html__('Page copyrights', 'acebeat'),
				'desc'    => esc_html__('Select one of predefined page copyrights.', 'acebeat'),
				'help'    => esc_html__('You can select one of predefined theme copyrights', 'acebeat'),
				'choices' => array(
					'1' => ACEBEAT_THEME_URI . '/img/theme-options/copyrights1.png',
					'2' => ACEBEAT_THEME_URI . '/img/theme-options/copyrights2.png',
				),
				'blank'   => false, // (optional) if true, image can be deselected
			),
			'copyrights_text' => array(
				'type'  => 'textarea',
				'value' => '&copy; Copyright 2017 All Rights Reserved',
				'label' => esc_html__('Copyrights text', 'acebeat'),
				'desc'  => esc_html__('Please type your copyrights text', 'acebeat'),
			)

		),
	),
	'fonts_panel'     => array(
		'title'   => esc_html__('Theme Fonts', 'acebeat'),
		'options' => array(
			'body_fonts_section' => array(
				'title'   => esc_html__('Font for body', 'acebeat'),
				'options' => array(
					'body_font_picker_switch' => array(
						'type'    => 'multi-picker',
						'label'   => false,
						'desc'    => false,
						'picker'  => array(
							'main_font_enabled' => array(
								'type'         => 'switch',
								'value'        => '',
								'label'        => esc_html__('Enable', 'acebeat'),
								'desc'         => esc_html__('Enable custom body font', 'acebeat'),
								'left-choice'  => array(
									'value' => '',
									'label' => esc_html__('Disabled', 'acebeat'),
								),
								'right-choice' => array(
									'value' => 'main_font_options',
									'label' => esc_html__('Enabled', 'acebeat'),
								),
							),
						),
						'choices' => array(
							'main_font_options' => array(
								'main_font' => array(
									'type'       => 'typography-v2',
									'value'      => array(
										'family'         => 'Roboto',
										// For standard fonts, instead of subset and variation you should set 'style' and 'weight'.
										// 'style' => 'italic',
										// 'weight' => 700,
										'subset'         => 'latin-ext',
										'variation'      => 'regular',
										'size'           => 14,
										'line-height'    => 24,
										'letter-spacing' => 0,
										'color'          => '#0000ff'
									),
									'components' => array(
										'family'         => true,
										// 'style', 'weight', 'subset', 'variation' will appear and disappear along with 'family'
										'size'           => true,
										'line-height'    => true,
										'letter-spacing' => true,
										'color'          => false
									),
									'attr'       => array('class' => 'custom-class', 'data-foo' => 'bar'),
									'label'      => esc_html__('Custom font', 'acebeat'),
									'desc'       => esc_html__('Select custom font for headings', 'acebeat'),
									'help'       => esc_html__('You should enable using custom heading fonts above at first', 'acebeat'),
								),
							),
						),
					),
				),
			),

			'headings_fonts_section' => array(
				'title'   => esc_html__('Font for headings', 'acebeat'),
				'options' => array(
					'h_font_picker_switch' => array(
						'type'    => 'multi-picker',
						'label'   => false,
						'desc'    => false,
						'picker'  => array(
							'h_font_enabled' => array(
								'type'         => 'switch',
								'value'        => '',
								'label'        => esc_html__('Enable', 'acebeat'),
								'desc'         => esc_html__('Enable custom heading font', 'acebeat'),
								'left-choice'  => array(
									'value' => '',
									'label' => esc_html__('Disabled', 'acebeat'),
								),
								'right-choice' => array(
									'value' => 'h_font_options',
									'label' => esc_html__('Enabled', 'acebeat'),
								),
							),
						),
						'choices' => array(
							'h_font_options' => array(
								'h_font' => array(
									'type'       => 'typography-v2',
									'value'      => array(
										'family'         => 'Roboto',
										// For standard fonts, instead of subset and variation you should set 'style' and 'weight'.
										// 'style' => 'italic',
										// 'weight' => 700,
										'subset'         => 'latin-ext',
										'variation'      => 'regular',
										'size'           => 28,
										'line-height'    => '100%',
										'letter-spacing' => 0,
										'color'          => '#0000ff'
									),
									'components' => array(
										'family'         => true,
										// 'style', 'weight', 'subset', 'variation' will appear and disappear along with 'family'
										'size'           => false,
										'line-height'    => false,
										'letter-spacing' => true,
										'color'          => false
									),
									'attr'       => array('class' => 'custom-class', 'data-foo' => 'bar'),
									'label'      => esc_html__('Custom font', 'acebeat'),
									'desc'       => esc_html__('Select custom font for headings', 'acebeat'),
									'help'       => esc_html__('You should enable using custom heading fonts above at first', 'acebeat'),
								),
							),
						),
					),
				),
			),

		),
	),
	'preloader_panel' => array(
		'title' => esc_html__('Theme Preloader', 'acebeat'),

		'options' => array(
			'preloader_enabled' => array(
				'type'         => 'switch',
				'value'        => '1',
				'label'        => esc_html__('Enable Preloader', 'acebeat'),
				'left-choice'  => array(
					'value' => '1',
					'label' => esc_html__('Enabled', 'acebeat'),
				),
				'right-choice' => array(
					'value' => '0',
					'label' => esc_html__('Disabled', 'acebeat'),
				),
			),

			'preloader_image' => array(
				'type'        => 'upload',
				'value'       => '',
				'label'       => esc_html__('Custom preloader image', 'acebeat'),
				'help'        => esc_html__('GIF image recommended. Recommended maximum preloader width 150px, maximum preloader height 150px.', 'acebeat'),
				'images_only' => true,
			),


		),
	),
	'share_buttons'   => array(
		'title' => esc_html__('Theme Share Buttons', 'acebeat'),

		'options' => array(
			'share_facebook'    => array(
				'type'         => 'switch',
				'value'        => '1',
				'label'        => esc_html__('Enable Facebook Share Button', 'acebeat'),
				'left-choice'  => array(
					'value' => '1',
					'label' => esc_html__('Enabled', 'acebeat'),
				),
				'right-choice' => array(
					'value' => '0',
					'label' => esc_html__('Disabled', 'acebeat'),
				),
			),
			'share_twitter'     => array(
				'type'         => 'switch',
				'value'        => '1',
				'label'        => esc_html__('Enable Twitter Share Button', 'acebeat'),
				'left-choice'  => array(
					'value' => '1',
					'label' => esc_html__('Enabled', 'acebeat'),
				),
				'right-choice' => array(
					'value' => '0',
					'label' => esc_html__('Disabled', 'acebeat'),
				),
			),
			'share_pinterest'   => array(
				'type'         => 'switch',
				'value'        => '1',
				'label'        => esc_html__('Enable Pinterest Share Button', 'acebeat'),
				'left-choice'  => array(
					'value' => '1',
					'label' => esc_html__('Enabled', 'acebeat'),
				),
				'right-choice' => array(
					'value' => '0',
					'label' => esc_html__('Disabled', 'acebeat'),
				),
			),
			'share_linkedin'    => array(
				'type'         => 'switch',
				'value'        => '1',
				'label'        => esc_html__('Enable LinkedIn Share Button', 'acebeat'),
				'left-choice'  => array(
					'value' => '1',
					'label' => esc_html__('Enabled', 'acebeat'),
				),
				'right-choice' => array(
					'value' => '0',
					'label' => esc_html__('Disabled', 'acebeat'),
				),
			),
			'share_tumblr'      => array(
				'type'         => 'switch',
				'value'        => '1',
				'label'        => esc_html__('Enable Tumblr Share Button', 'acebeat'),
				'left-choice'  => array(
					'value' => '1',
					'label' => esc_html__('Enabled', 'acebeat'),
				),
				'right-choice' => array(
					'value' => '0',
					'label' => esc_html__('Disabled', 'acebeat'),
				),
			),
			'share_reddit'      => array(
				'type'         => 'switch',
				'value'        => '1',
				'label'        => esc_html__('Enable Reddit Share Button', 'acebeat'),
				'left-choice'  => array(
					'value' => '1',
					'label' => esc_html__('Enabled', 'acebeat'),
				),
				'right-choice' => array(
					'value' => '0',
					'label' => esc_html__('Disabled', 'acebeat'),
				),
			),

		),
	),

);
