<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$id = uniqid( 'testimonials-' );

//fw_print($atts['testimonials_layout']);

switch ( $atts['testimonials_layout']['layout'] ):
	case 'flexslider': ?>
		<div class="flexslider testimonials-slider"
            data-nav="false"
        >
			<ul class="slides">
				<?php foreach ( $atts['testimonials'] as $testimonial ): ?>
					<li>
                        <blockquote class="with_padding text-center rounded">
							<?php
							$author_image_url = ! empty( $testimonial['author_avatar']['url'] )
								? $testimonial['author_avatar']['url']
								: fw_get_framework_directory_uri( '/static/img/no-image.png' );
							?>
                            <img src="<?php echo esc_attr( $author_image_url ); ?>"
                                 alt="<?php echo esc_attr( $testimonial['author_name'] ); ?>"/>
							<?php echo esc_html( $testimonial['content'] ); ?>
                            <cite>
                                <span class="highlight author"><?php echo esc_html( $testimonial['author_name'] ); ?></span>
                                <span class="highlight2">
                                    <?php echo esc_html( $testimonial['author_job'] ); ?>
                                </span>
								<?php echo esc_html( $testimonial['author_job'] && $testimonial['site_name'] ) ? ', ' : ''; ?>
								<?php if ( $testimonial['site_url'] ) : ?>
                                <a href="<?php echo esc_url( $testimonial['site_url'] ); ?>">
									<?php endif; //site_url ?>
									<?php echo esc_html( $testimonial['site_name'] ); ?>
									<?php if ( $testimonial['site_url'] ) : ?>
                                </a>
							<?php endif; //site_url ?>
                            </cite>
                        </blockquote>
					</li>
				<?php endforeach; ?>
			</ul>
		</div>
		<?php
		break; //eof big flexslider layout

	//default bootstrap layout
	default: ?>
        <div class="owl-carousel testimonials-owl-carousel"
             data-responsive-lg="<?php echo esc_attr( $atts['testimonials_layout']['owlcarousel']['responsive_lg'] ); ?>"
             data-responsive-md="<?php echo esc_attr( $atts['testimonials_layout']['owlcarousel']['responsive_md'] ); ?>"
             data-responsive-sm="<?php echo esc_attr( $atts['testimonials_layout']['owlcarousel']['responsive_sm'] ); ?>"
             data-responsive-xs="<?php echo esc_attr( $atts['testimonials_layout']['owlcarousel']['responsive_xs'] ); ?>"
             data-dots="true"
             data-nav="false"
        >

	        <?php
            foreach ( $atts['testimonials'] as $testimonial ):
                ?>
                <blockquote class="text-center">
                    <div class="item-meta topmargin_0">
	                    <?php
	                    $author_image_url = ! empty( $testimonial['author_avatar']['url'] )
		                    ? $testimonial['author_avatar']['url']
		                    : fw_get_framework_directory_uri( '/static/img/no-image.png' );
	                    ?>
                        <div class="avatar">
                            <img src="<?php echo esc_attr( $author_image_url ); ?>"
                                 alt="<?php echo esc_attr( $testimonial['author_name'] ); ?>"/>
                        </div>

                        <?php if ( $testimonial['author_first_name'] ) : ?>
                            <h2 class="section_header topmargin_0">
                                <span class="small-text highlight"><?php echo esc_html( $testimonial['author_first_name'] ); ?></span>
                                <?php echo esc_html( $testimonial['author_last_name'] ); ?>
                            </h2>
                        <?php endif; ?>
                        <?php if ( $testimonial['star_rating']['show_star_rating'] ) :
                            $stars_value = $testimonial['star_rating']['stars']['stars_value'];
                            $stars_width = (float)$testimonial['star_rating']['stars']['stars_value'] * 20;
                        ?>
                        <div>
                            <div class="star-rating" title="Rated <?php echo esc_attr( $stars_value ); ?> out of 5">
                            <span style="width:<?php echo esc_attr( $stars_width ); ?>%">
                                <strong class="rating"><?php echo esc_html( $stars_value ); ?></strong> out of 5
                            </span>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
	                <?php echo esc_html( $testimonial['content'] ); ?>
                </blockquote>
	        <?php
            endforeach; ?>

        </div>
        <?php
		break; //eof bootstrap layout
endswitch;

