<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'testimonials_layout' => array(
		'type'    => 'multi-picker',
		'value'   => array(
			'layout'  => 'owlcarousel',
		),
		'label'   => false,
		'desc'    => false,
		'picker'  => array(
			'layout' => array(
				'type'    => 'select',
				'value'   => 'owlcarousel',
				'label'   => esc_html__( 'Testimonials Layout', 'acebeat' ),
				'desc'    => esc_html__( 'Select one of predefined testimonials layout', 'acebeat' ),
				'choices' => array(
					'owlcarousel'  => esc_html__( 'Owl Carousel', 'acebeat' ),
					'flexslider' => esc_html__( 'Big FlexSlider Carousel', 'acebeat' ),
				),
			),
		),
		'choices'  => array(
			'owlcarousel'  => array(
				'responsive_lg' => array(
					'type'        => 'select',
					'value'       => '3',
					'label'       => esc_html__( 'Items count on <1200px', 'acebeat' ),
					'choices'     => array(
						'4' => '4',
						'3' => '3',
						'2' => '2',
						'1' => '1',
					),
					'no-validate' => false,
				),
				'responsive_md' => array(
					'type'        => 'select',
					'value'       => '2',
					'label'       => esc_html__( 'Items count on 992px-1200px', 'acebeat' ),
					'choices'     => array(
						'4' => '4',
						'3' => '3',
						'2' => '2',
						'1' => '1',
					),
					'no-validate' => false,
				),
				'responsive_sm' => array(
					'type'        => 'select',
					'value'       => '2',
					'label'       => esc_html__( 'Items count on 768px-992px', 'acebeat' ),
					'choices'     => array(
						'3' => '3',
						'2' => '2',
						'1' => '1',

					),
					'no-validate' => false,
				),
				'responsive_xs' => array(
					'type'        => 'select',
					'value'       => '1',
					'label'       => esc_html__( 'Items count on >768px', 'acebeat' ),
					'choices'     => array(
						'2' => '2',
						'1' => '1',
					),
					'no-validate' => false,
				),
			),
			'flexslider' =>  array(),
		)
	),
	'testimonials'        => array(
		'label'         => esc_html__( 'Testimonials', 'acebeat' ),
		'popup-title'   => esc_html__( 'Add/Edit Testimonial', 'acebeat' ),
		'desc'          => esc_html__( 'Here you can add, remove and edit your Testimonials.', 'acebeat' ),
		'type'          => 'addable-popup',
		'template'      => '{{=author_name}}',
		'popup-options' => array(
			'content'       => array(
				'label' => esc_html__( 'Quote', 'acebeat' ),
				'desc'  => esc_html__( 'Enter the testimonial here', 'acebeat' ),
				'type'  => 'textarea',
			),
			'author_avatar' => array(
				'label' => esc_html__( 'Image', 'acebeat' ),
				'desc'  => esc_html__( 'Either upload a new, or choose an existing image from your media library', 'acebeat' ),
				'type'  => 'upload',
			),
			'author_first_name'   => array(
				'label' => esc_html__( 'First Name', 'acebeat' ),
				'desc'  => esc_html__( 'Enter the Name of the Person to quote', 'acebeat' ),
				'type'  => 'text'
			),
			'author_last_name'   => array(
				'label' => esc_html__( 'Last Name', 'acebeat' ),
				'desc'  => esc_html__( 'Enter the Name of the Person to quote', 'acebeat' ),
				'type'  => 'text'
			),
			'author_job'    => array(
				'label' => esc_html__( 'Position', 'acebeat' ),
				'desc'  => esc_html__( 'Can be used for a job description', 'acebeat' ),
				'type'  => 'text'
			),
			'site_name'     => array(
				'label' => esc_html__( 'Website Name', 'acebeat' ),
				'desc'  => esc_html__( 'Linktext for the above Link', 'acebeat' ),
				'type'  => 'text'
			),
			'site_url'      => array(
				'label' => esc_html__( 'Website Link', 'acebeat' ),
				'desc'  => esc_html__( 'Link to the Persons website', 'acebeat' ),
				'type'  => 'text'
			),
			'star_rating' => array(
				'type'    => 'multi-picker',
				'value'   => '',
				'picker'  => array(
					'show_star_rating' => array(
						'type'         => 'switch',
						'label'        => esc_html__( 'Show star rating', 'acebeat' ),
						'left-choice'  => array(
							'value' => '',
							'label' => esc_html__( 'No', 'acebeat' ),
						),
						'right-choice' => array(
							'value' => 'stars',
							'label' => esc_html__( 'Yes', 'acebeat' ),
						),
					),
				),
				'choices' => array(
					''       => array(),
					'stars' => array(
						'stars_value' => array(
							'type'    => 'select',
							'value'   => '5.0',
							'label'   => esc_html__( 'Star rating', 'acebeat' ),
							'choices' => array(
								'1.0'  => esc_html__( '1.0', 'acebeat' ),
								'1.5'  => esc_html__( '1.5', 'acebeat' ),
								'2.0'  => esc_html__( '2.0', 'acebeat' ),
								'2.5'  => esc_html__( '2.5', 'acebeat' ),
								'3.0'  => esc_html__( '3.0', 'acebeat' ),
								'3.5'  => esc_html__( '3.5', 'acebeat' ),
								'4.0'  => esc_html__( '4.0', 'acebeat' ),
								'4.5'  => esc_html__( '4.5', 'acebeat' ),
								'5.0'  => esc_html__( '5.0', 'acebeat' ),
							)
						)
					),
				),
			)
		)
	)
);