<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$teaser = fw_ext( 'shortcodes' )->get_shortcode( 'teaser' );

$options = array(
	'tabs'       => array(
		'type'          => 'addable-popup',
		'label'         => esc_html__( 'Tabs', 'acebeat' ),
		'popup-title'   => esc_html__( 'Add/Edit Tabs', 'acebeat' ),
		'desc'          => esc_html__( 'Create your tabs', 'acebeat' ),
		'template'      => '{{=tab_title}}',
		'popup-options' => array(
			'tab_title'           => array(
				'type'  => 'text',
				'label' => esc_html__( 'Title', 'acebeat' )
			),
			'tab_columns_width'   => array(
				'type'    => 'select',
				'label'   => esc_html__( 'Column width in tab content', 'acebeat' ),
				'value'   => 'col-sm-4',
				'desc'    => esc_html__( 'Choose teaser width inside tab content', 'acebeat' ),
				'choices' => array(
					'col-sm-12' => esc_html__( '1/1', 'acebeat' ),
					'col-sm-6'  => esc_html__( '1/2', 'acebeat' ),
					'col-sm-4'  => esc_html__( '1/3', 'acebeat' ),
					'col-sm-3'  => esc_html__( '1/4', 'acebeat' ),
				),
			),
			'tab_columns_padding' => array(
				'type'    => 'select',
				'value'   => 'columns_padding_15',
				'label'   => esc_html__( 'Column paddings', 'acebeat' ),
				'desc'    => esc_html__( 'Choose columns horizontal paddings value', 'acebeat' ),
				'choices' => array(
					'columns_padding_0'  => esc_html__( '0', 'acebeat' ),
					'columns_padding_1'  => esc_html__( '1 px', 'acebeat' ),
					'columns_padding_2'  => esc_html__( '2 px', 'acebeat' ),
					'columns_padding_5'  => esc_html__( '5 px', 'acebeat' ),
					'columns_padding_15' => esc_html__( '15 px - default', 'acebeat' ),
					'columns_padding_25' => esc_html__( '25 px', 'acebeat' ),
				),
			),
			'tab_teasers'         => array(
				'type'          => 'addable-popup',
				'label'         => esc_html__( 'Teasers in tabs', 'acebeat' ),
				'popup-title'   => esc_html__( 'Add/Edit Teasers in tabs', 'acebeat' ),
				'desc'          => esc_html__( 'Create your teasers in tabs', 'acebeat' ),
				'template'      => '{{=title}}',
				'popup-options' => $teaser->get_options(),

			),
		),

	),
	'top_border' => array(
		'type'         => 'switch',
		'value'        => '',
		'label'        => esc_html__( 'Top color border', 'acebeat' ),
		'desc'         => esc_html__( 'Add top color border to tab content', 'acebeat' ),
		'left-choice'  => array(
			'value' => '',
			'label' => esc_html__( 'No top border', 'acebeat' ),
		),
		'right-choice' => array(
			'value' => 'top-color-border',
			'label' => esc_html__( 'Color top border', 'acebeat' ),
		),
	),
	'id'         => array( 'type' => 'unique' ),
);