<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'tabs'       => array(
		'type'          => 'addable-popup',
		'label'         => esc_html__( 'Tabs', 'acebeat' ),
		'popup-title'   => esc_html__( 'Add/Edit Tabs', 'acebeat' ),
		'desc'          => esc_html__( 'Create your tabs', 'acebeat' ),
		'template'      => '{{=tab_title}}',
		'popup-options' => array(
			'tab_title'          => array(
				'type'  => 'text',
				'label' => esc_html__( 'Tab Title', 'acebeat' )
			),
			'tab_content'        => array(
				'type'  => 'wp-editor',
				'label' => esc_html__( 'Tab Content', 'acebeat' ),
			),
			'tab_featured_image' => array(
				'type'        => 'upload',
				'value'       => '',
				'label'       => esc_html__( 'Tab Featured Image', 'acebeat' ),
				'image'       => esc_html__( 'Featured image for your tab', 'acebeat' ),
				'help'        => esc_html__( 'Image for your tab. It appears on the top of your tab content', 'acebeat' ),
				'images_only' => true,
			),
			'tab_icon'           => array(
				'type'  => 'icon',
				'label' => esc_html__( 'Icon in tab title', 'acebeat' ),
				'set'   => 'rt-icons-2',
			),
		),
	),
	'small_tabs' => array(
		'type'         => 'switch',
		'value'        => '',
		'label'        => esc_html__( 'Small Tabs', 'acebeat' ),
		'desc'         => esc_html__( 'Decrease tabs size', 'acebeat' ),
		'left-choice'  => array(
			'value' => '',
			'label' => esc_html__( 'No', 'acebeat' ),
		),
		'right-choice' => array(
			'value' => 'small-tabs',
			'label' => esc_html__( 'Yes', 'acebeat' ),
		),
	),
	'top_border' => array(
		'type'         => 'switch',
		'value'        => '',
		'label'        => esc_html__( 'Top color border', 'acebeat' ),
		'desc'         => esc_html__( 'Add top color border to tab content', 'acebeat' ),
		'left-choice'  => array(
			'value' => '',
			'label' => esc_html__( 'No top border', 'acebeat' ),
		),
		'right-choice' => array(
			'value' => 'top-color-border',
			'label' => esc_html__( 'Color top border', 'acebeat' ),
		),
	),
	'id'         => array( 'type' => 'unique' ),
);