<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'heading_align' => array(
		'type'    => 'select',
		'value'   => 'text-left',
		'label'   => esc_html__( 'Text alignment', 'acebeat' ),
		'desc'    => esc_html__( 'Select heading text alignment', 'acebeat' ),
		'choices' => array(
			''   => esc_html__( 'Left', 'acebeat' ),
			'text-center' => esc_html__( 'Center', 'acebeat' ),
			'text-right'  => esc_html__( 'Right', 'acebeat' ),
		),
	),
	'headings'      => array(
		'type'        => 'addable-box',
		'value'       => '',
		'label'       => esc_html__( 'Headings', 'acebeat' ),
		'desc'        => esc_html__( 'Choose a tag and text inside it', 'acebeat' ),
		'box-options' => array(
			'heading_tag'            => array(
				'type'    => 'select',
				'value'   => 'h3',
				'label'   => esc_html__( 'Heading tag', 'acebeat' ),
				'desc'    => esc_html__( 'Select a tag for your ', 'acebeat' ),
				'choices' => array(
					'h3' => esc_html__( 'H3 tag', 'acebeat' ),
					'h2' => esc_html__( 'H2 tag', 'acebeat' ),
					'h4' => esc_html__( 'H4 tag', 'acebeat' ),
					'h5' => esc_html__( 'H5 tag', 'acebeat' ),
					'h6' => esc_html__( 'H6 tag', 'acebeat' ),
					'p'  => esc_html__( 'P tag', 'acebeat' ),

				),
			),
			'heading_text'           => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__( 'Heading text', 'acebeat' ),
				'desc'  => esc_html__( 'Text to appear in slide layer', 'acebeat' ),
			),
			'heading_text_color'     => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Heading text color', 'acebeat' ),
				'desc'    => esc_html__( 'Select a color for your text in layer', 'acebeat' ),
				'choices' => array(
					''           => esc_html__( 'Inherited', 'acebeat' ),
					'highlight'  => esc_html__( 'Theme accent color', 'acebeat' ),
					'grey'       => esc_html__( 'Dark grey theme color', 'acebeat' ),
					'black'      => esc_html__( 'Dark theme color', 'acebeat' ),

				),
			),
			'heading_text_weight'    => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Heading text weight', 'acebeat' ),
				'desc'    => esc_html__( 'Select a weight for your text in layer', 'acebeat' ),
				'choices' => array(
					''     => esc_html__( 'Normal', 'acebeat' ),
					'bold' => esc_html__( 'Bold', 'acebeat' ),
					'thin' => esc_html__( 'Thin', 'acebeat' ),

				),
			),
			'heading_text_transform' => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Heading text transform', 'acebeat' ),
				'desc'    => esc_html__( 'Select a weight for your text in layer', 'acebeat' ),
				'choices' => array(
					''                => esc_html__( 'None', 'acebeat' ),
					'text-lowercase'  => esc_html__( 'Lowercase', 'acebeat' ),
					'text-uppercase'  => esc_html__( 'Uppercase', 'acebeat' ),
					'text-capitalize' => esc_html__( 'Capitalize', 'acebeat' ),

				),
			),
		),
		'template'    => '{{- heading_text }}',
	)
);
