<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(

	'tab_main_options' => array(
		'type' => 'tab',
		'title' => esc_html__('Main Options', 'acebeat'),
		'options' => array(
			'is_fullwidth'     => array(
				'label' => esc_html__( 'Full Width', 'acebeat' ),
				'type'  => 'switch',
			),

			'background_color' => array(
				'type'    => 'select',
				'value'   => 'ls',
				'label'   => esc_html__( 'Background color', 'acebeat' ),
				'desc'    => esc_html__( 'Select background color', 'acebeat' ),
				'help'    => esc_html__( 'Select one of predefined background colors', 'acebeat' ),
				'choices' => array(
					'ls'             => esc_html__( 'Light', 'acebeat' ),
					'ls ms'          => esc_html__( 'Light Grey', 'acebeat' ),
					'cs grey'        => esc_html__( 'Grey', 'acebeat' ),
					'ds ms'          => esc_html__( 'Dark Grey', 'acebeat' ),
					'ds'             => esc_html__( 'Dark', 'acebeat' ),
					'cs'             => esc_html__( 'Main color', 'acebeat' ),
					'cs gradient'    => esc_html__( 'Color Gradient color', 'acebeat' ),
				),
			),
			'top_padding'      => array(
				'type'    => 'select',
				'value'   => 'section_padding_top_50',
				'label'   => esc_html__( 'Top padding', 'acebeat' ),
				'desc'    => esc_html__( 'Choose top padding value', 'acebeat' ),
				'choices' => array(
					'section_padding_top_0'   => esc_html__( '0', 'acebeat' ),
					'section_padding_top_5'   => esc_html__( '5 px', 'acebeat' ),
					'section_padding_top_15'  => esc_html__( '15 px', 'acebeat' ),
					'section_padding_top_25'  => esc_html__( '25 px', 'acebeat' ),
					'section_padding_top_30'  => esc_html__( '30 px', 'acebeat' ),
					'section_padding_top_40'  => esc_html__( '40 px', 'acebeat' ),
					'section_padding_top_50'  => esc_html__( '50 px', 'acebeat' ),
					'section_padding_top_65'  => esc_html__( '65 px', 'acebeat' ),
					'section_padding_top_75'  => esc_html__( '75 px', 'acebeat' ),
					'section_padding_top_100' => esc_html__( '100 px', 'acebeat' ),
					'section_padding_top_130' => esc_html__( '130 px', 'acebeat' ),
					'section_padding_top_150' => esc_html__( '150 px', 'acebeat' ),
				),
			),
			'bottom_padding'   => array(
				'type'    => 'select',
				'value'   => 'section_padding_bottom_50',
				'label'   => esc_html__( 'Bottom padding', 'acebeat' ),
				'desc'    => esc_html__( 'Choose bottom padding value', 'acebeat' ),
				'choices' => array(
					'section_padding_bottom_0'   => esc_html__( '0', 'acebeat' ),
					'section_padding_bottom_5'   => esc_html__( '5 px', 'acebeat' ),
					'section_padding_bottom_15'  => esc_html__( '15 px', 'acebeat' ),
					'section_padding_bottom_25'  => esc_html__( '25 px', 'acebeat' ),
					'section_padding_bottom_30'  => esc_html__( '30 px', 'acebeat' ),
					'section_padding_bottom_40'  => esc_html__( '40 px', 'acebeat' ),
					'section_padding_bottom_50'  => esc_html__( '50 px', 'acebeat' ),
					'section_padding_bottom_65'  => esc_html__( '65 px', 'acebeat' ),
					'section_padding_bottom_75'  => esc_html__( '75 px', 'acebeat' ),
					'section_padding_bottom_100' => esc_html__( '100 px', 'acebeat' ),
					'section_padding_bottom_130' => esc_html__( '130 px', 'acebeat' ),
					'section_padding_bottom_150' => esc_html__( '150 px', 'acebeat' ),
				),
			),
			'columns_padding'  => array(
				'type'    => 'select',
				'value'   => 'columns_padding_15',
				'label'   => esc_html__( 'Column paddings', 'acebeat' ),
				'desc'    => esc_html__( 'Choose columns horizontal paddings value', 'acebeat' ),
				'choices' => array(
					'columns_padding_0'  => esc_html__( '0', 'acebeat' ),
					'columns_padding_1'  => esc_html__( '1 px', 'acebeat' ),
					'columns_padding_2'  => esc_html__( '2 px', 'acebeat' ),
					'columns_padding_5'  => esc_html__( '5 px', 'acebeat' ),
					'columns_padding_15' => esc_html__( '15 px - default', 'acebeat' ),
					'columns_padding_25' => esc_html__( '25 px', 'acebeat' ),
				),
			),
			'columns_top_margin'  => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Column Top Margin', 'acebeat' ),
				'desc'    => esc_html__( 'Choose columns top margin value', 'acebeat' ),
				'choices' => array(
					'columns_margin_top_0'  => esc_html__( '0 px', 'acebeat' ),
					''  => esc_html__( '10 px  - default', 'acebeat' ),
					'columns_margin_top_20'  => esc_html__( '20 px', 'acebeat' ),
					'columns_margin_top_30'  => esc_html__( '30 px', 'acebeat' ),
					'columns_margin_top_40'  => esc_html__( '40 px', 'acebeat' ),
				),
			),
			'columns_bottom_margin'  => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Column Bottom Margin', 'acebeat' ),
				'desc'    => esc_html__( 'Choose columns bottom margin value', 'acebeat' ),
				'choices' => array(
					'columns_margin_bottom_0'  => esc_html__( '0 px', 'acebeat' ),
					''  => esc_html__( '10 px  - default', 'acebeat' ),
					'columns_margin_bottom_20'  => esc_html__( '20 px', 'acebeat' ),
					'columns_margin_bottom_30'  => esc_html__( '30 px', 'acebeat' ),
					'columns_margin_bottom_40'  => esc_html__( '40 px', 'acebeat' ),
				),
			),
			'background_image' => array(
				'label'   => esc_html__( 'Background Image', 'acebeat' ),
				'desc'    => esc_html__( 'Please select the background image', 'acebeat' ),
				'type'    => 'background-image',
				'choices' => array(//	in future may will set predefined images
				)
			),
			'background_cover' => array(
				'label' => esc_html__( 'Background Cover', 'acebeat' ),
				'type'  => 'switch',
			),
			'parallax'         => array(
				'label' => esc_html__( 'Parallax', 'acebeat' ),
				'type'  => 'switch',
			),
			'is_table'         => array(
				'label' => esc_html__( 'Vertical align content', 'acebeat' ),
				'desc'  => esc_html__( 'Align columns content vertically on wide screens', 'acebeat' ),
				'type'  => 'switch',
			),

			'section_id' => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__('ID attribute', 'acebeat'),
				'desc'  => esc_html__('Add ID attribute to section. Useful for single page menu', 'acebeat'),
			),
		),
	),

	'tab_onehalf_media_options' => array(
		'type' => 'tab',
		'title' => esc_html__('One half width Media', 'acebeat'),
		'options' => array(
			'side_media_image' => array(
				'type'  => 'upload',
				'value' => array(),
				'label' => esc_html__('Side media image', 'acebeat'),
				'desc'  => esc_html__('Select image that you want to appear as one half side image', 'acebeat'),
				'images_only' => true,
			),
			'side_media_link' => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__('Link to your side media', 'acebeat'),
				'desc'  => esc_html__('You can add a link to your side media. If YouTube link will be provided, video will play in LightBox', 'acebeat'),
			),
			'side_media_video' => array(
				'type'    => 'oembed',
				'value'   => '',
				'label'   => esc_html__( 'Video', 'acebeat' ),
				'desc'    => esc_html__( 'Adds video player. Works only when side media image is set', 'acebeat' ),
				'help'    => esc_html__( 'Leave blank if no needed', 'acebeat' ),
				'preview' => array(
					'width'      => 278, // optional, if you want to set the fixed width to iframe
					'height'     => 185, // optional, if you want to set the fixed height to iframe
					/**
					 * if is set to false it will force to fit the dimensions,
					 * because some widgets return iframe with aspect ratio and ignore applied dimensions
					 */
					'keep_ratio' => true
				),
			),
			'side_media_position'  => array(
				'type'  => 'switch',
				'value' => 'cover_left',
				'label' => esc_html__('Media position', 'acebeat'),
				'desc'  => esc_html__('Left or right media position', 'acebeat'),
				'left-choice' => array(
					'value' => 'cover_left',
					'label' => esc_html__('Left', 'acebeat'),
				),
				'right-choice' => array(
					'value' => 'cover_right',
					'label' => esc_html__('Right', 'acebeat'),
				),
			),
		),

	),

);
