<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

/**
 * @var $atts The shortcode attributes
 */

?>
<ul class="price-table style1">
	<?php if( ! empty( $atts['title']) ) : ?>
	<li class="plan-name">
		<h3><?php echo wp_kses_post( $atts['title'] ); ?></h3>
	</li>
	<?php endif; ?>
	<li class="plan-price">
	<?php if( ! empty( $atts['currency']) ) : ?>
		<span><?php echo wp_kses_post( $atts['currency'] ); ?></span>
	<?php endif; ?>
	<?php if( ! empty( $atts['price']) ) : ?>
		<span><?php echo wp_kses_post( $atts['price'] ); ?></span>
	<?php endif; ?>
	<?php if( ! empty( $atts['price_after']) ) : ?>
		<p><?php echo wp_kses_post( $atts['price_after'] ); ?></p>
	<?php endif; ?>
	</li>
	<?php if( ! empty( $atts['features']) ) : ?>
	<li class="features-list">
		<ul>
		<?php foreach( ( $atts['features']) as $feature ) : ?>
			<li class="<?php echo esc_attr( $feature['feature_checked'] ); ?>">
				<?php echo wp_kses_post( $feature['feature_name'] ); ?>
			</li>
		<?php endforeach; ?>
		</ul>
	</li>
	<?php endif; ?>
	<li class="call-to-action">
	<?php
		$wide_button = ( ! empty( $atts['wide_button'] ) ? 'wide_button' : '' )
	?>
		<a href="<?php echo esc_url( $atts['link'] ) ?>" target="<?php echo esc_attr( $atts['target'] ) ?>"
		   class="<?php echo esc_attr( $atts['color'] . ' ' . $wide_button ); ?>">
			<span><?php echo esc_html( $atts['label'] ); ?></span>
		</a>
	</li>
</ul>
