<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}
/**
 * Shortcode Posts - vertical item layout type 2
 */

$terms          = get_the_terms( get_the_ID(), 'category' );
$filter_classes = '';
foreach ( $terms as $term ) {
	$filter_classes .= ' filter-' . $term->slug;
}

$show_post_thumbnail = ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) ? false : true;

?>
<article <?php post_class( "vertical-item content-padding with_background rounded overflow_hidden text-center " . $filter_classes ); ?>>
    <?php acebeat_post_thumbnail(); ?>
	<div class="item-content">
        <header class="entry-header">

            <div class="entry-meta small-text content-justify">
		        <?php if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) ) : ?>

                    <span class="categories-links highlightlinks"><?php echo get_the_category_list( esc_html_x( ' ', 'Used between list items, there is a space after the comma.', 'acebeat' ) ); ?></span>

		        <?php endif; ?>
	            <?php
	            if ( 'post' == get_post_type() ) {
		            acebeat_posted_on( true );
	            } ?>
            </div>

			<?php
			the_title( '<h4 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h4>' );
			?>

        </header><!-- .entry-header -->
        <div class="entry-content content-3lines-ellipsis">
			<?php the_excerpt(); ?>
        </div><!-- .entry-content -->
	</div>

    <footer class="entry-footer inline-content greylinks small-text bottom_color_border">
	    <?php
	    printf( '<a href="%1$s"><i class="fa fa-user rightpadding_5" aria-hidden="true"></i><span>%2$s</span></a>',
		    esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
		    get_the_author()
	    );
	    ?>

	    <?php if ( comments_open() ) : ?>
            <a href="<?php comments_link(); ?>">
                <i class="fa fa-comment rightpadding_5" aria-hidden="true"></i>
                <span class="value"><?php comments_number( "0", "1", "%" ); ?></span>
            </a>
	    <?php else: ?>
            <span>
                <i class="fa fa-comment rightpadding_5" aria-hidden="true"></i>
                <span><?php echo esc_html__( 'Closed', 'acebeat' ); ?></span>
            </span>
	    <?php endif; ?>
	    <?php if ( function_exists( 'mwt_show_post_views_count' ) ) : ?>
            <span>
                <i class="fa fa-eye rightpadding_5" aria-hidden="true"></i>
                <span class="value"><?php acebeat_show_post_views_count(); ?></span>
            </span>
	    <?php endif; ?>
    </footer>

</article><!-- eof vertical-item -->
