<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'number'        => array(
		'type'       => 'slider',
		'value'      => 6,
		'properties' => array(
			'min'  => 1,
			'max'  => 12,
			'step' => 1, // Set slider step. Always > 0. Could be fractional.

		),
		'label'      => esc_html__( 'Items number', 'acebeat' ),
		'desc'       => esc_html__( 'Number of posts to display', 'acebeat' ),
	),
	'margin'        => array(
		'label'   => esc_html__( 'Horizontal item margin (px)', 'acebeat' ),
		'desc'    => esc_html__( 'Select horizontal item margin', 'acebeat' ),
		'value'   => '30',
		'type'    => 'select',
		'choices' => array(
			'0'  => esc_html__( '0', 'acebeat' ),
			'1'  => esc_html__( '1px', 'acebeat' ),
			'2'  => esc_html__( '2px', 'acebeat' ),
			'10' => esc_html__( '10px', 'acebeat' ),
			'30' => esc_html__( '30px', 'acebeat' ),
		)
	),
	'layout'        => array(
		'label'   => esc_html__( 'Post Layout', 'acebeat' ),
		'desc'    => esc_html__( 'Choose post layout', 'acebeat' ),
		'value'   => 'carousel',
		'type'    => 'select',
		'choices' => array(
			'carousel' => esc_html__( 'Carousel', 'acebeat' ),
			'isotope'  => esc_html__( 'Masonry Grid', 'acebeat' ),
		)
	),
	'item_layout'   => array(
		'label'   => esc_html__( 'Item layout', 'acebeat' ),
		'desc'    => esc_html__( 'Choose Item layout', 'acebeat' ),
		'value'   => 'item-regular',
		'type'    => 'select',
		'choices' => array(
			'item-horizontal'    => esc_html__( 'Horizontal item', 'acebeat' ),
			'item-vertical' => esc_html__( 'Vertical item with excerpt', 'acebeat' ),
			'item-vertical2' => esc_html__( 'Vertical item', 'acebeat' ),
		)
	),
	'responsive_lg' => array(
		'label'   => esc_html__( 'Columns on large screens', 'acebeat' ),
		'desc'    => esc_html__( 'Select items number on wide screens (>1200px)', 'acebeat' ),
		'value'   => '4',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'acebeat' ),
			'2' => esc_html__( '2', 'acebeat' ),
			'3' => esc_html__( '3', 'acebeat' ),
			'4' => esc_html__( '4', 'acebeat' ),
			'6' => esc_html__( '6', 'acebeat' ),
		)
	),
	'responsive_md' => array(
		'label'   => esc_html__( 'Columns on middle screens', 'acebeat' ),
		'desc'    => esc_html__( 'Select items number on middle screens (>992px)', 'acebeat' ),
		'value'   => '3',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'acebeat' ),
			'2' => esc_html__( '2', 'acebeat' ),
			'3' => esc_html__( '3', 'acebeat' ),
			'4' => esc_html__( '4', 'acebeat' ),
			'6' => esc_html__( '6', 'acebeat' ),
		)
	),
	'responsive_sm' => array(
		'label'   => esc_html__( 'Columns on small screens', 'acebeat' ),
		'desc'    => esc_html__( 'Select items number on small screens (>768px)', 'acebeat' ),
		'value'   => '2',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'acebeat' ),
			'2' => esc_html__( '2', 'acebeat' ),
			'3' => esc_html__( '3', 'acebeat' ),
			'4' => esc_html__( '4', 'acebeat' ),
			'6' => esc_html__( '6', 'acebeat' ),
		)
	),
	'responsive_xs' => array(
		'label'   => esc_html__( 'Columns on extra small screens', 'acebeat' ),
		'desc'    => esc_html__( 'Select items number on extra small screens (<767px)', 'acebeat' ),
		'value'   => '1',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'acebeat' ),
			'2' => esc_html__( '2', 'acebeat' ),
			'3' => esc_html__( '3', 'acebeat' ),
			'4' => esc_html__( '4', 'acebeat' ),
			'6' => esc_html__( '6', 'acebeat' ),
		)
	),
	'show_filters'  => array(
		'type'         => 'switch',
		'value'        => false,
		'label'        => esc_html__( 'Show filters', 'acebeat' ),
		'desc'         => esc_html__( 'Hide or show categories filters', 'acebeat' ),
		'left-choice'  => array(
			'value' => false,
			'label' => esc_html__( 'No', 'acebeat' ),
		),
		'right-choice' => array(
			'value' => true,
			'label' => esc_html__( 'Yes', 'acebeat' ),
		),
	),
	'cat' => array(
		'type'  => 'multi-select',
		'label' => esc_html__('Select categories', 'acebeat'),
		'desc'  => esc_html__('You can select one or more categories', 'acebeat'),
		'population' => 'taxonomy',
		'source' => 'category',
		'prepopulate' => 10,
		'limit' => 100,
	)
);