<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}
//get social icons to add in item:
$icon = fw_ext( 'shortcodes' )->get_shortcode( 'icon' );
//get social icons to add in item:
$icons_social = fw_ext( 'shortcodes' )->get_shortcode( 'icons_social' );

$options = array(
	'title'      => array(
		'type'  => 'text',
		'label' => esc_html__( 'Title of the Box', 'acebeat' ),
	),
	'title_tag'  => array(
		'type'    => 'select',
		'value'   => 'h3',
		'label'   => esc_html__( 'Title Tag', 'acebeat' ),
		'choices' => array(
			'h2' => esc_html__( 'H2', 'acebeat' ),
			'h3' => esc_html__( 'H3', 'acebeat' ),
			'h4' => esc_html__( 'H4', 'acebeat' ),
		)
	),
	'content'    => array(
		'type'          => 'wp-editor',
		'label'         => esc_html__( 'Item text', 'acebeat' ),
		'desc'          => esc_html__( 'Enter desired item content', 'acebeat' ),
		'size'          => 'small', // small, large
		'editor_height' => 400,
	),
	'item_style' => array(
		'type'    => 'select',
		'label'   => esc_html__( 'Item Box Style', 'acebeat' ),
		'choices' => array(
			''                                => esc_html__( 'Default (no border or background)', 'acebeat' ),
			'content-padding with_border'     => esc_html__( 'Bordered', 'acebeat' ),
			'content-padding with_background' => esc_html__( 'Muted Background', 'acebeat' ),
			'content-padding ls ms'           => esc_html__( 'Grey background', 'acebeat' ),
			'content-padding ds'              => esc_html__( 'Darkgrey background', 'acebeat' ),
			'content-padding ds ms'           => esc_html__( 'Dark background', 'acebeat' ),
			'content-padding cs'              => esc_html__( 'Main color background', 'acebeat' ),
			'full-padding with_border'        => esc_html__( 'Bordered with Padding', 'acebeat' ),
			'full-padding with_background'    => esc_html__( 'Muted Background with Padding', 'acebeat' ),
			'full-padding ls ms'              => esc_html__( 'Grey background with Padding', 'acebeat' ),
			'full-padding ds'                 => esc_html__( 'Darkgrey background with Padding', 'acebeat' ),
			'full-padding ds ms'              => esc_html__( 'Dark background with Padding', 'acebeat' ),
			'full-padding cs'                 => esc_html__( 'Main color background with Padding', 'acebeat' ),
		)
	),
	'link'       => array(
		'type'  => 'text',
		'value' => '',
		'label' => esc_html__( 'Item link', 'acebeat' ),
		'desc'  => esc_html__( 'Link on title and optional button', 'acebeat' ),
	),
	'item_image' => array(
		'type'        => 'upload',
		'value'       => '',
		'label'       => esc_html__( 'Item Image', 'acebeat' ),
		'image'       => esc_html__( 'Image for your item. Not all item layouts show image', 'acebeat' ),
		'help'        => 'Image for your item. Image can appear as an element, or background or even can be hidden depends from chosen item type',
		'images_only' => true,
	),
	'text_align' => array(
		'type'    => 'select',
		'label'   => esc_html__( 'Text Alignment', 'acebeat' ),
		'choices' => array(
			'text-left'   => esc_html__( 'Left', 'acebeat' ),
			'text-center' => esc_html__( 'Center', 'acebeat' ),
			'text-right'  => esc_html__( 'Right', 'acebeat' ),
		)
	),
	'icons'      => array(
		'type'            => 'addable-box',
		'value'           => '',
		'label'           => esc_html__( 'Additional info', 'acebeat' ),
		'desc'            => esc_html__( 'Add icons with title and text', 'acebeat' ),
		'box-options'     => $icon->get_options(),
		'add-button-text' => esc_html__( 'Add New', 'acebeat' ),
		'template'        => '{{=title}}',
		'sortable'        => true,
	),
	$icons_social->get_options(),

);