<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}
/**
 * @var array $atts
 */

$icon = isset( $atts['icon'] ) ? $atts['icon'] : false;
$title = isset( $atts['title'] ) ? $atts['title'] : false;
$content = isset( $atts['content'] ) ? $atts['content'] : false;
$link = isset( $atts['link'] ) ? $atts['link'] : false;
$butotn_text = isset( $atts['button_text'] ) ? $atts['button_text'] : false;
$wide_button = ( ! empty( $atts['teaser_button']['button']['wide_button'] ) ? 'min_width_button' : '' )

?>
<div class="teaser hover_icon with_padding big-padding with_border rounded text-center <?php echo esc_attr( $atts['highlighted'] ); ?>">

	<?php if ( $icon ) : ?>
        <div class="teaser_icon size_big highlight">
            <i class="<?php echo esc_attr( $icon ); ?>"></i>
        </div>
	<?php endif; //$icon_style check
	?>

    <?php if ( $title ) : ?>
        <h4 class="topmargin_20 hover-color2">
            <?php if ( $link ) : ?>
                <a href="<?php echo esc_url( $link ); ?>" target="<?php echo esc_attr( $atts['teaser_button']['button']['target'] ) ?>" >
                    <?php echo esc_html( $title ); ?>
                </a>
            <?php endif; ?>
        </h4>
    <?php endif; ?>

	<?php if ( $content ) : ?>
        <p class="content-3lines-ellipsis">
            <?php echo esc_html( $content ); ?>
        </p>
	<?php endif; ?>

    <?php if ( $atts['teaser_button']['show_button'] && $link ) : ?>
        <p class="topmargin_30 bottommargin_0">
            <a href="<?php echo esc_url( $atts['teaser_button']['button']['link'] ) ?>" target="<?php echo esc_attr( $atts['teaser_button']['button']['target'] ) ?>"
               class="<?php echo esc_attr( $atts['teaser_button']['button']['color'] . ' ' . $wide_button ); ?>">
                <span><?php echo esc_html( $atts['teaser_button']['button']['label'] ); ?></span>
            </a>
        </p>
    <?php endif; ?>

    <?php if ( $atts['highlighted'] ) : ?>
    <span class="bottom_corners"></span>
    <?php endif; ?>

</div><!-- eof .vertical-item -->
