<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'social_icons' => array(
		'type'            => 'addable-box',
		'value'           => '',
		'label'           => esc_html__( 'Social Buttons', 'acebeat' ),
		'desc'            => esc_html__( 'Optional social buttons', 'acebeat' ),
		'template'        => '{{=icon}}',
		'box-options'     => array(
			'icon'       => array(
				'type'  => 'icon',
				'label' => esc_html__( 'Social Icon', 'acebeat' ),
				'set'   => 'social-icons',
			),
			'icon_class' => array(
				'type'        => 'select',
				'value'       => '',
				'label'       => esc_html__( 'Icon type', 'acebeat' ),
				'desc'        => esc_html__( 'Select one of predefined social button types', 'acebeat' ),
				'choices'     => array(
					''                                    => esc_html__( 'Default', 'acebeat' ),
					'border-icon'                         => esc_html__( 'Simple Bordered Icon', 'acebeat' ),
					'border-icon rounded-icon'            => esc_html__( 'Rounded Bordered Icon', 'acebeat' ),
					'bg-icon'                             => esc_html__( 'Simple Background Icon', 'acebeat' ),
					'bg-icon rounded-icon'                => esc_html__( 'Rounded Background Icon', 'acebeat' ),
					'color-icon bg-icon'                  => esc_html__( 'Color Light Background Icon', 'acebeat' ),
					'color-icon bg-icon rounded-icon'     => esc_html__( 'Color Light Background Rounded Icon', 'acebeat' ),
					'color-icon'                          => esc_html__( 'Color Icon', 'acebeat' ),
					'color-icon border-icon'              => esc_html__( 'Color Bordered Icon', 'acebeat' ),
					'color-icon border-icon rounded-icon' => esc_html__( 'Rounded Color Bordered Icon', 'acebeat' ),
					'color-bg-icon'                       => esc_html__( 'Color Background Icon', 'acebeat' ),
					'color-bg-icon rounded-icon'          => esc_html__( 'Rounded Color Background Icon', 'acebeat' ),

				),
				/**
				 * Allow save not existing choices
				 * Useful when you use the select to populate it dynamically from js
				 */
				'no-validate' => false,
			),
			'icon_url'   => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__( 'Icon Link', 'acebeat' ),
				'desc'  => esc_html__( 'Provide a URL to your icon', 'acebeat' ),
			)
		),
		'limit'           => 0, // limit the number of boxes that can be added
		'add-button-text' => esc_html__( 'Add', 'acebeat' ),
		'sortable'        => true,
	),


);