<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

/**
 * @var array $atts
 */

if ( $atts['title'] || $atts['text'] ) :
	?>
	<div class="media small-teaser">
		<?php if ( $atts['icon'] ): ?>
			<div class="media-left">
				<i class="<?php echo esc_attr( $atts['icon'] . ' ' . $atts['icon_style'] ); ?>"></i>
			</div>
		<?php endif; //icon 
		?>
		<div class="media-body">
        <?php if ( !empty( $atts['title'] ) ) {?>
            <h5 class="text-uppercase">
                <?php echo wp_kses_post( $atts['title'] ); ?>
            </h5>
        <?php } //title ?>
			<?php echo wp_kses_post( $atts['text'] ); ?>
		</div>
	</div>
	<?php
//only icon
else:
	?>
	<span class="theme-icon">
	<i class="<?php echo esc_attr( $atts['icon'] . ' ' . $atts['icon_style'] ); ?>"></i>
</span>
	<?php
endif;