<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}
/**
 * Shortcode Posts - regular item layout
 */

$event_meta = fw_get_db_post_option( get_the_ID(), fw()->extensions->get( 'events' )->get_event_option_id() );

$event_date = $event_meta['event_children'][0]['event_date_range'];
$event_location = !empty( $event_meta['event_location']['venue'] ) ? $event_meta['event_location']['venue'] : $event_meta['event_location']['address'];
$time_start = date( get_option('time_format'), strtotime( $event_date['from']) );
$time_end = date( get_option('time_format'), strtotime( $event_date['to']) );

//has thumbnail layout
if ( get_the_post_thumbnail() ) : ?>
    <article <?php post_class( 'vertical-item content-absolute hover-entry-content text-center' ) ?>>
        <div class="item-media top_rounded overflow_hidden">
	        <?php the_post_thumbnail( 'acebeat-small-width' ) ?>
        </div>
        <div class="item-content ds">
            <h4 class="entry-title bottommargin_0">
                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
            </h4>
            <div class="media small-media small-text grey inline-block margin_0 hover-hidden">
                <div class="media-left">
                    <i class="fa fa-calendar cons-width highlight" aria-hidden="true"></i>
                </div>
                <div class="media-body">
                    <?php echo date( get_option('date_format'), strtotime( $event_date['from']) ); ?>
                </div>
            </div>
            <div class="entry-content grey">

                <div class="entry-meta small-text text-left">
                    <div class="content-justify">
                        <div class="media small-media inline-block margin_0">
                            <div class="media-left">
                                <i class="fa fa-calendar cons-width highlight" aria-hidden="true"></i>
                            </div>
                            <div class="media-body">
	                            <?php echo date( get_option('date_format'), strtotime( $event_date['from']) ); ?>
                            </div>
                        </div>
	                    <?php if ( !empty( $time_start ) ) : ?>
                        <div class="media small-media inline-block margin_0">
                            <div class="media-left">
                                <i class="fa fa-clock-o cons-width highlight" aria-hidden="true"></i>
                            </div>
                            <div class="media-body">
	                            <?php echo esc_html( $time_start  ); ?>
                            </div>
                        </div>
	                    <?php endif; ?>
                    </div>
	                <?php if ( !empty( $event_location ) ) : ?>
                    <div class="media small-media margin_0">
                        <div class="media-left">
                            <i class="fa fa-map-marker cons-width highlight" aria-hidden="true"></i>
                        </div>
                        <div class="media-body">
	                        <?php echo esc_html( $event_location ); ?>
                        </div>
                    </div>
	                <?php endif; ?>
                </div>
                <div class="topmargin_20">
                    <a href="<?php the_permalink(); ?>" class="theme_button inverse"><?php echo esc_html__( 'Read More', 'acebeat' ); ?></a>
                </div>
            </div>
        </div>
    </article>
	<?php
//no featured image
else :
	?>
    <article <?php post_class( 'vertical-item content-padding ds rounded text-center' ) ?>>
        <div class="item-content">
            <h4 class="entry-title">
                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
            </h4>
            <div class="entry-content grey">

                <div class="entry-meta small-text text-left">
                    <div class="content-justify">
                        <div class="media small-media inline-block margin_0">
                            <div class="media-left">
                                <i class="fa fa-calendar cons-width highlight" aria-hidden="true"></i>
                            </div>
                            <div class="media-body">
								<?php echo date( get_option('date_format'), strtotime( $event_date['from']) ); ?>
                            </div>
                        </div>
						<?php if ( !empty( $time_start ) ) : ?>
                            <div class="media small-media inline-block margin_0">
                                <div class="media-left">
                                    <i class="fa fa-clock-o cons-width highlight" aria-hidden="true"></i>
                                </div>
                                <div class="media-body">
									<?php echo esc_html( $time_start  ); ?>
                                </div>
                            </div>
						<?php endif; ?>
                    </div>
					<?php if ( !empty( $event_location ) ) : ?>
                        <div class="media small-media margin_0">
                            <div class="media-left">
                                <i class="fa fa-map-marker cons-width highlight" aria-hidden="true"></i>
                            </div>
                            <div class="media-body">
								<?php echo esc_html( $event_location ); ?>
                            </div>
                        </div>
					<?php endif; ?>
                </div>
                <div class="topmargin_20">
                    <a href="<?php the_permalink(); ?>" class="theme_button inverse"><?php echo esc_html__( 'Read More', 'acebeat' ); ?></a>
                </div>
            </div>
        </div>
    </article>
	<?php
endif;
?>