<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$events = fw()->extensions->get( 'events' );
if ( empty( $events ) ) {
	return;
}

$options = array(
	'layout'        => array(
		'label'   => esc_html__( 'Events Layout', 'acebeat' ),
		'desc'    => esc_html__( 'Choose events layout', 'acebeat' ),
		'value'   => 'isotope',
		'type'    => 'select',
		'choices' => array(
			'carousel' => esc_html__( 'Carousel', 'acebeat' ),
			'isotope'  => esc_html__( 'Masonry Grid', 'acebeat' ),
		)
	),
	'number'        => array(
		'type'       => 'slider',
		'value'      => 6,
		'properties' => array(
			'min'  => 1,
			'max'  => 12,
			'step' => 1, // Set slider step. Always > 0. Could be fractional.

		),
		'label'      => esc_html__( 'Items number', 'acebeat' ),
		'desc'       => esc_html__( 'Number of portfolio events to display', 'acebeat' ),
	),
	'margin'        => array(
		'label'   => esc_html__( 'Horizontal item margin (px)', 'acebeat' ),
		'desc'    => esc_html__( 'Select horizontal item margin', 'acebeat' ),
		'value'   => '30',
		'type'    => 'select',
		'choices' => array(
			'0'  => esc_html__( '0', 'acebeat' ),
			'1'  => esc_html__( '1px', 'acebeat' ),
			'2'  => esc_html__( '2px', 'acebeat' ),
			'10' => esc_html__( '10px', 'acebeat' ),
			'30' => esc_html__( '30px', 'acebeat' ),
		)
	),
	'responsive_lg' => array(
		'label'   => esc_html__( 'Columns on wide screens', 'acebeat' ),
		'desc'    => esc_html__( 'Select items number on wide screens (>=1200px)', 'acebeat' ),
		'value'   => '4',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'acebeat' ),
			'2' => esc_html__( '2', 'acebeat' ),
			'3' => esc_html__( '3', 'acebeat' ),
			'4' => esc_html__( '4', 'acebeat' ),
			'5' => esc_html__( '5', 'acebeat' ),
			'6' => esc_html__( '6', 'acebeat' ),
		)
	),
	'responsive_md' => array(
		'label'   => esc_html__( 'Columns on middle screens', 'acebeat' ),
		'desc'    => esc_html__( 'Select items number on middle screens (>=992px)', 'acebeat' ),
		'value'   => '3',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'acebeat' ),
			'2' => esc_html__( '2', 'acebeat' ),
			'3' => esc_html__( '3', 'acebeat' ),
			'4' => esc_html__( '4', 'acebeat' ),
			'5' => esc_html__( '5', 'acebeat' ),
			'6' => esc_html__( '6', 'acebeat' ),
		)
	),
	'responsive_sm' => array(
		'label'   => esc_html__( 'Columns on small screens', 'acebeat' ),
		'desc'    => esc_html__( 'Select items number on small screens (>=768px)', 'acebeat' ),
		'value'   => '2',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'acebeat' ),
			'2' => esc_html__( '2', 'acebeat' ),
			'3' => esc_html__( '3', 'acebeat' ),
			'4' => esc_html__( '4', 'acebeat' ),
			'5' => esc_html__( '5', 'acebeat' ),
		)
	),
	'responsive_xs' => array(
		'label'   => esc_html__( 'Columns on extra small screens', 'acebeat' ),
		'desc'    => esc_html__( 'Select items number on extra small screens (>=500px)', 'acebeat' ),
		'value'   => '1',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'acebeat' ),
			'2' => esc_html__( '2', 'acebeat' ),
			'3' => esc_html__( '3', 'acebeat' ),
			'4' => esc_html__( '4', 'acebeat' ),
		)
	),
	'responsive_xxs' => array(
		'label'   => esc_html__( 'Columns on extra small screens', 'acebeat' ),
		'desc'    => esc_html__( 'Select items number on extra small screens (<500px)', 'acebeat' ),
		'value'   => '1',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'acebeat' ),
			'2' => esc_html__( '2', 'acebeat' ),
			'3' => esc_html__( '3', 'acebeat' ),
			'4' => esc_html__( '4', 'acebeat' ),
		)
	),
);