<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

if ( ! fw()->extensions->get( 'event' ) ) {
	return;
}


class FW_Shortcode_Events extends FW_Shortcode {
	protected function _render( $atts, $content = null, $tag = '' ) {
		if ( ! isset( $atts['layout'] ) ) {
			return $this->get_error_msg();
		}



		$posts = $this->fw_get_posts_with_info( array(
			'sort'  => 'post_date',
			'items' => $atts['number'],
		) );

		$view_path = $this->locate_path( '/views/' . $atts['layout'] . '.php' );

		return fw_render_view( $view_path, array(
				'atts'  => $atts,
				'posts' => $posts,
			)
		);

	}

	/**
	 * @param array $args
	 *
	 * @return WP_Query
	 */
	public function fw_get_posts_with_info( $args = array() ) {
		$next_event_post_ids_list = $this->fw_get_next_event_id();

		$defaults = array(
			'sort'        => 'recent',
			'items'       => 5,
			'image_post'  => true,
			'date_post'   => true,
			'date_format' => 'F jS, Y',
			'post_type'   => 'fw-event',


		);

		extract( wp_parse_args( $args, $defaults ) );

		$query = new WP_Query( array(
			'post_type'           => $post_type,
			'orderby'             => 'post__in',
			'order '              => 'DESC',
			'ignore_sticky_posts' => true,
			'posts_per_page'      => $items,
			'post__in'            => $next_event_post_ids_list
		) );

		//wp reset query removed

		return $query;
	}

	private function get_error_msg() {
		return '<p>' . esc_html__( 'No view found', 'acebeat' ) . '</p>';
	}

	/**
	 * @return array - next event post_id
	 */
	public function fw_get_next_event_id() {

		$next_event_child_post_query = new WP_Query( array(
			'posts_per_page'      => 0,
			'post_status'		  => 'publish',
			'post_type'           => 'fw-event-search',
			'orderby'             => 'event-from-date',
			'order'               => 'ASC',
			'meta_query' => array(
				array(
					'key'=> 'event-from-date',
					'value' => time(),
					'compare' => '>'
				),
			)
		) );

		$next_event_post_ids = [];

		foreach ( $next_event_child_post_query->posts as $event ) {
			array_push( $next_event_post_ids, $event->post_parent );
		}

		return $next_event_post_ids;
	}
}