<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$custom_column_classes = array(
	'custom_classes'    => array(
		'type'  => 'text',
		'label' => esc_html__( 'Custom column classes', 'acebeat' ),
		'desc'  => esc_html__( 'Enter custom column classes', 'acebeat' ),
	),
);

$options = array(
	'column_align'     => array(
		'type'    => 'select',
		'value'   => '',
		'label'   => esc_html__( 'Text alignment in column', 'acebeat' ),
		'desc'    => esc_html__( 'Select text alignment inside your column', 'acebeat' ),
		'choices' => array(
			''            => esc_html__( 'Inherit', 'acebeat' ),
			'text-left'   => esc_html__( 'Left', 'acebeat' ),
			'text-center' => esc_html__( 'Center', 'acebeat' ),
			'text-right'  => esc_html__( 'Right', 'acebeat' ),
		),
	),
	'column_padding'   => array(
		'type'    => 'select',
		'value'   => '',
		'label'   => esc_html__( 'Column padding', 'acebeat' ),
		'desc'    => esc_html__( 'Select optional internal column paddings', 'acebeat' ),
		'choices' => array(
			''           => esc_html__( 'No padding', 'acebeat' ),
			'padding_10' => esc_html__( '10px', 'acebeat' ),
			'padding_20' => esc_html__( '20px', 'acebeat' ),
			'padding_30' => esc_html__( '30px', 'acebeat' ),
			'padding_40' => esc_html__( '40px', 'acebeat' ),
            'with_padding' => esc_html__( 'Theme style padding', 'acebeat' ),

		),
	),
	'background_color' => array(
		'type'    => 'select',
		'value'   => '',
		'label'   => esc_html__( 'Background color', 'acebeat' ),
		'desc'    => esc_html__( 'Select background color', 'acebeat' ),
		'help'    => esc_html__( 'Select one of predefined background colors', 'acebeat' ),
		'choices' => array(
			''               => esc_html__( 'Transparent (No Background)', 'acebeat' ),
			'with_background'=> esc_html__( 'Highlight', 'acebeat' ),
			'muted_background'=> esc_html__( 'Muted', 'acebeat' ),
			'ds ms'          => esc_html__( 'Dark Grey', 'acebeat' ),
			'ds'             => esc_html__( 'Dark', 'acebeat' ),
			'cs'             => esc_html__( 'Main color', 'acebeat' ),
			'cs main_color2' => esc_html__( 'Second Main color', 'acebeat' ),
		),
	),
	'column_animation' => array(
		'type'    => 'select',
		'value'   => '',
		'label'   => esc_html__( 'Animation type', 'acebeat' ),
		'desc'    => esc_html__( 'Select one of predefined animations', 'acebeat' ),
		'choices' => array(
			''               => esc_html__( 'None', 'acebeat' ),
			'slideDown'      => esc_html__( 'slideDown', 'acebeat' ),
			'scaleAppear'    => esc_html__( 'scaleAppear', 'acebeat' ),
			'fadeInLeft'     => esc_html__( 'fadeInLeft', 'acebeat' ),
			'fadeInUp'       => esc_html__( 'fadeInUp', 'acebeat' ),
			'fadeInRight'    => esc_html__( 'fadeInRight', 'acebeat' ),
			'fadeInDown'     => esc_html__( 'fadeInDown', 'acebeat' ),
			'fadeIn'         => esc_html__( 'fadeIn', 'acebeat' ),
			'slideRight'     => esc_html__( 'slideRight', 'acebeat' ),
			'slideUp'        => esc_html__( 'slideUp', 'acebeat' ),
			'slideLeft'      => esc_html__( 'slideLeft', 'acebeat' ),
			'expandUp'       => esc_html__( 'expandUp', 'acebeat' ),
			'slideExpandUp'  => esc_html__( 'slideExpandUp', 'acebeat' ),
			'expandOpen'     => esc_html__( 'expandOpen', 'acebeat' ),
			'bigEntrance'    => esc_html__( 'bigEntrance', 'acebeat' ),
			'hatch'          => esc_html__( 'hatch', 'acebeat' ),
			'tossing'        => esc_html__( 'tossing', 'acebeat' ),
			'pulse'          => esc_html__( 'pulse', 'acebeat' ),
			'floating'       => esc_html__( 'floating', 'acebeat' ),
			'bounce'         => esc_html__( 'bounce', 'acebeat' ),
			'pullUp'         => esc_html__( 'pullUp', 'acebeat' ),
			'pullDown'       => esc_html__( 'pullDown', 'acebeat' ),
			'stretchLeft'    => esc_html__( 'stretchLeft', 'acebeat' ),
			'stretchRight'   => esc_html__( 'stretchRight', 'acebeat' ),
			'fadeInUpBig'    => esc_html__( 'fadeInUpBig', 'acebeat' ),
			'fadeInDownBig'  => esc_html__( 'fadeInDownBig', 'acebeat' ),
			'fadeInLeftBig'  => esc_html__( 'fadeInLeftBig', 'acebeat' ),
			'fadeInRightBig' => esc_html__( 'fadeInRightBig', 'acebeat' ),
			'slideInDown'    => esc_html__( 'slideInDown', 'acebeat' ),
			'slideInLeft'    => esc_html__( 'slideInLeft', 'acebeat' ),
			'slideInRight'   => esc_html__( 'slideInRight', 'acebeat' ),
			'moveFromLeft'   => esc_html__( 'moveFromLeft', 'acebeat' ),
			'moveFromRight'  => esc_html__( 'moveFromRight', 'acebeat' ),
			'moveFromBottom' => esc_html__( 'moveFromBottom', 'acebeat' ),
		),
	),
	'custom_column' => array(
		'type'    => 'multi-picker',
		'label'   => false,
		'desc'    => false,
		'picker'  => array(
			'custom' => array(
				'type'         => 'switch',
				'label'        => esc_html__( 'Custom column layout', 'acebeat' ),
				'desc'        => esc_html__( 'Set your own column classes. It overrides other options. Use it only if you know what are you doing', 'acebeat' ),
				'left-choice'  => array(
					'value' => '',
					'label' => esc_html__( 'No', 'acebeat' ),
				),
				'right-choice' => array(
					'value' => 'custom_cl',
					'label' => esc_html__( 'Yes', 'acebeat' ),
				),
			),
		),
		'choices' => array(
			''       => array(),
			'custom_cl' => $custom_column_classes,
		),
        'show_borders' => true,
	)

);
