<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'label'       => array(
		'label' => esc_html__( 'Button Label', 'acebeat' ),
		'desc'  => esc_html__( 'This is the text that appears on your button', 'acebeat' ),
		'type'  => 'text',
		'value' => 'Submit'
	),
	'link'        => array(
		'label' => esc_html__( 'Button Link', 'acebeat' ),
		'desc'  => esc_html__( 'Where should your button link to', 'acebeat' ),
		'type'  => 'text',
		'value' => '#'
	),
	'target'      => array(
		'type'         => 'switch',
		'label'        => esc_html__( 'Open Link in New Window', 'acebeat' ),
		'desc'         => esc_html__( 'Select here if you want to open the linked page in a new window', 'acebeat' ),
		'right-choice' => array(
			'value' => '_blank',
			'label' => esc_html__( 'Yes', 'acebeat' ),
		),
		'left-choice'  => array(
			'value' => '_self',
			'label' => esc_html__( 'No', 'acebeat' ),
		),
	),
	'color'       => array(
		'label'   => esc_html__( 'Button Color', 'acebeat' ),
		'desc'    => esc_html__( 'Choose a type for your button', 'acebeat' ),
		'type'    => 'select',
		'choices' => array(
			'theme_button'         => esc_html__( 'Default', 'acebeat' ),
			'theme_button inverse' => esc_html__( 'Inverse', 'acebeat' ),
			'theme_button color1'  => esc_html__( 'Color', 'acebeat' ),
			'simple_link'          => esc_html__( 'Just link', 'acebeat' ),
			'more-link'            => esc_html__( 'Read More link', 'acebeat' ),
		)
	),
	'wide_button' => array(
		'type'  => 'switch',
		'label' => esc_html__( 'Wide button', 'acebeat' ),
		'desc'  => esc_html__( 'Switch to create wider button', 'acebeat' ),
	),
	'video_button' => array(
		'type'  => 'switch',
		'label' => esc_html__( 'Video Popup Button', 'acebeat' ),
		'desc'  => esc_html__( 'Round play button that triggers popup video', 'acebeat' ),
	),
);