<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
} ?>
<?php

$slider_background = isset( $data['settings']['extra']['slider_background'] ) ? $data['settings']['extra']['slider_background'] : '';

if ( isset( $data['slides'] ) ): ?>
	<section class="intro_section page_mainslider <?php echo esc_attr( $slider_background ); ?>">
		<div class="flexslider vertical-nav"
             data-dots="true"
             data-nav="true"
        >
			<ul class="slides">
				<?php foreach ( $data['slides'] as $id => $slide ):
				$slide_align      = isset( $slide['extra']['slide_align'] ) ? $slide['extra']['slide_align'] : false;
				$slide_layers     = isset( $slide['extra']['slide_layers'] ) ? $slide['extra']['slide_layers'] : false;

				$slide_buttons          = isset( $slide['extra']['slide_buttons'] ) ? $slide['extra']['slide_buttons'] : false;
				$slide_button_animation = isset( $slide['extra']['slide_button_animation'] ) ? $slide['extra']['slide_button_animation'] : false;
				?>
				<li class="<?php echo esc_attr( $slide_align ); ?>">
					<img src="<?php echo esc_attr( $slide['src'] ); ?>" alt="<?php echo esc_attr( $slide['title'] ) ?>">
					<div class="container">
						<div class="row">
							<div class="col-sm-12">
								<div class="slide_description_wrapper">
									<?php if ( $slide_layers || $slide_buttons ) : ?>
									<div class="slide_description">
                                        <?php
                                            foreach ( $slide_layers as $layer ):
                                            ?>
                                            <div class="intro-layer" data-animation="<?php echo esc_attr( $layer['layer_animation'] ); ?>">
                                                <<?php echo esc_html( $layer['layer_tag'] ); ?>
                                                class="<?php echo esc_attr( $layer['layer_text_color'] ); ?> <?php echo esc_attr( $layer['layer_text_weight'] ); ?> <?php echo esc_attr( $layer['layer_text_transform'] ); ?>">
                                                    <?php echo wp_kses_post( $layer['layer_text'] ) ?>
                                                </<?php echo esc_html( $layer['layer_tag'] ); ?>>
                                            </div>
                                            <?php
                                            endforeach;
                                            if ( !empty( $slide_buttons ) ) : ?>
                                                <div class="intro-layer" data-animation="<?php echo esc_attr( $slide_button_animation ); ?>">
                                                    <p class="topmargin_25 inline-content vertical-margin">
                                                        <?php foreach( $slide_buttons as $button ) : ?>
                                                            <a href="<?php echo esc_url( $button['button_link'] ); ?>"
                                                               class="min_width_button wide_button <?php echo esc_attr( $button['button_type'] ); ?>"><?php echo esc_html( $button['button_text'] ); ?>
                                                            </a>
                                                        <?php endforeach; ?>
                                                    </p>
                                                </div>
                                            <?php endif; ?>
                                    </div> <!-- eof .slide_description -->
                                    <?php endif; ?>
                                </div> <!-- eof .slide_description_wrapper -->
                            </div> <!-- eof .col-* -->
                        </div><!-- eof .row -->
                    </div><!-- eof .container -->
                </li>
		<?php endforeach; ?>
		    </ul>
		</div> <!-- eof flexslider -->
	</section> <!-- eof intro_section -->
<?php endif; ?>