<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(

	'slide_align'      => array(
		'type'        => 'select',
		'value'       => 'text-left',
		'label'       => esc_html__( 'Slide text alignment', 'acebeat' ),
		'desc'        => esc_html__( 'Select slide text alignment', 'acebeat' ),
		'choices'     => array(
			'text-left'   => esc_html__( 'Left', 'acebeat' ),
			'text-center' => esc_html__( 'Center', 'acebeat' ),
			'text-right'  => esc_html__( 'Right', 'acebeat' ),
		),
		/**
		 * Allow save not existing choices
		 * Useful when you use the select to populate it dynamically from js
		 */
		'no-validate' => false,
	),
	'slide_layers'     => array(
		'type'        => 'addable-box',
		'value'       => '',
		'label'       => esc_html__( 'Slide Layers', 'acebeat' ),
		'desc'        => esc_html__( 'Choose a tag and text inside it', 'acebeat' ),
		'box-options' => array(
			'layer_tag'            => array(
				'type'    => 'select',
				'value'   => 'h3',
				'label'   => esc_html__( 'Layer tag', 'acebeat' ),
				'desc'    => esc_html__( 'Select a tag for your ', 'acebeat' ),
				'choices' => array(
					'h3' => esc_html__( 'H3 tag', 'acebeat' ),
					'h2' => esc_html__( 'H2 tag', 'acebeat' ),
					'h4' => esc_html__( 'H4 tag', 'acebeat' ),
					'h5' => esc_html__( 'H5 tag', 'acebeat' ),
					'p'  => esc_html__( 'P tag', 'acebeat' ),

				),
			),
			'layer_animation'      => array(
				'type'    => 'select',
				'value'   => 'fadeIn',
				'label'   => esc_html__( 'Animation type', 'acebeat' ),
				'desc'    => esc_html__( 'Select one of predefined animations', 'acebeat' ),
				'choices' => array(
					''               => esc_html__( 'Default', 'acebeat' ),
					'slideDown'      => esc_html__( 'slideDown', 'acebeat' ),
					'scaleAppear'    => esc_html__( 'scaleAppear', 'acebeat' ),
					'fadeInLeft'     => esc_html__( 'fadeInLeft', 'acebeat' ),
					'fadeInUp'       => esc_html__( 'fadeInUp', 'acebeat' ),
					'fadeInRight'    => esc_html__( 'fadeInRight', 'acebeat' ),
					'fadeInDown'     => esc_html__( 'fadeInDown', 'acebeat' ),
					'fadeIn'         => esc_html__( 'fadeIn', 'acebeat' ),
					'slideRight'     => esc_html__( 'slideRight', 'acebeat' ),
					'slideUp'        => esc_html__( 'slideUp', 'acebeat' ),
					'slideLeft'      => esc_html__( 'slideLeft', 'acebeat' ),
					'expandUp'       => esc_html__( 'expandUp', 'acebeat' ),
					'slideExpandUp'  => esc_html__( 'slideExpandUp', 'acebeat' ),
					'expandOpen'     => esc_html__( 'expandOpen', 'acebeat' ),
					'bigEntrance'    => esc_html__( 'bigEntrance', 'acebeat' ),
					'hatch'          => esc_html__( 'hatch', 'acebeat' ),
					'tossing'        => esc_html__( 'tossing', 'acebeat' ),
					'pulse'          => esc_html__( 'pulse', 'acebeat' ),
					'floating'       => esc_html__( 'floating', 'acebeat' ),
					'bounce'         => esc_html__( 'bounce', 'acebeat' ),
					'pullUp'         => esc_html__( 'pullUp', 'acebeat' ),
					'pullDown'       => esc_html__( 'pullDown', 'acebeat' ),
					'stretchLeft'    => esc_html__( 'stretchLeft', 'acebeat' ),
					'stretchRight'   => esc_html__( 'stretchRight', 'acebeat' ),
					'fadeInUpBig'    => esc_html__( 'fadeInUpBig', 'acebeat' ),
					'fadeInDownBig'  => esc_html__( 'fadeInDownBig', 'acebeat' ),
					'fadeInLeftBig'  => esc_html__( 'fadeInLeftBig', 'acebeat' ),
					'fadeInRightBig' => esc_html__( 'fadeInRightBig', 'acebeat' ),
					'slideInDown'    => esc_html__( 'slideInDown', 'acebeat' ),
					'slideInLeft'    => esc_html__( 'slideInLeft', 'acebeat' ),
					'slideInRight'   => esc_html__( 'slideInRight', 'acebeat' ),
					'moveFromLeft'   => esc_html__( 'moveFromLeft', 'acebeat' ),
					'moveFromRight'  => esc_html__( 'moveFromRight', 'acebeat' ),
					'moveFromBottom' => esc_html__( 'moveFromBottom', 'acebeat' ),
				),
			),
			'layer_text'           => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__( 'Layer text', 'acebeat' ),
				'desc'  => esc_html__( 'Text to appear in slide layer', 'acebeat' ),
			),
			'layer_text_color'     => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Layer text color', 'acebeat' ),
				'desc'    => esc_html__( 'Select a color for your text in layer', 'acebeat' ),
				'choices' => array(
					''           => esc_html__( 'Inherited', 'acebeat' ),
					'highlight'  => esc_html__( 'First theme main color', 'acebeat' ),
					'highlight2' => esc_html__( 'Second theme main color', 'acebeat' ),
					'grey'       => esc_html__( 'Dark grey theme color', 'acebeat' ),
					'black'      => esc_html__( 'Dark theme color', 'acebeat' ),

				),
			),
			'layer_text_weight'    => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Layer text weight', 'acebeat' ),
				'desc'    => esc_html__( 'Select a weight for your text in layer', 'acebeat' ),
				'choices' => array(
					''     => esc_html__( 'Normal', 'acebeat' ),
					'bold' => esc_html__( 'Bold', 'acebeat' ),
					'thin' => esc_html__( 'Thin', 'acebeat' ),

				),
			),
			'layer_text_transform' => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Layer text transform', 'acebeat' ),
				'desc'    => esc_html__( 'Select a text transformation for your layer', 'acebeat' ),
				'choices' => array(
					''                => esc_html__( 'None', 'acebeat' ),
					'text-lowercase'  => esc_html__( 'Lowercase', 'acebeat' ),
					'text-uppercase'  => esc_html__( 'Uppercase', 'acebeat' ),
					'text-capitalize' => esc_html__( 'Capitalize', 'acebeat' ),

				),
			),
		),
		'template'    => esc_html__( 'Slider Layer', 'acebeat' ),

		'limit'           => 5, // limit the number of boxes that can be added
		'add-button-text' => esc_html__( 'Add', 'acebeat' ),
//		'sortable' => true,
	),

	'slide_buttons'     => array(
		'type'        => 'addable-box',
		'value'       => '',
		'label'       => esc_html__( 'Slide Buttons', 'acebeat' ),
		'desc'        => esc_html__( 'Choose a button, link for it and text inside it', 'acebeat' ),
		'box-options' => array(
			'button_type'     => array(
				'type'        => 'select',
				'value'       => '',
				'label'       => esc_html__( 'Slide button', 'acebeat' ),
				'desc'        => esc_html__( 'Select slide button. Leave empty if no button needed', 'acebeat' ),
				'choices'     => array(
					'theme_button'         => esc_html__( 'Default', 'acebeat' ),
					'theme_button inverse' => esc_html__( 'Inverse', 'acebeat' ),
					'theme_button color1'  => esc_html__( 'Color', 'acebeat' ),
					'simple_link'          => esc_html__( 'Just link', 'acebeat' ),
				),
				/**
				 * Allow save not existing choices
				 * Useful when you use the select to populate it dynamically from js
				 */
				'no-validate' => false,
			),
			'button_text'      => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__( 'Slide button text', 'acebeat' ),
				'desc'  => esc_html__( 'Text in button', 'acebeat' ),
			),
			'button_link'      => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__( 'Slide button link', 'acebeat' ),
				'desc'  => esc_html__( 'Paste a link', 'acebeat' ),
			),
		),
		'template'    => esc_html__( 'Slider Button', 'acebeat' ),
		'limit'           => 5, // limit the number of boxes that can be added
		'add-button-text' => esc_html__( 'Add', 'acebeat' ),
	),
	'slide_button_animation' => array(
		'type'    => 'select',
		'value'   => 'fadeIn',
		'label'   => esc_html__( 'Buttons animation type', 'acebeat' ),
		'desc'    => esc_html__( 'Select one of predefined animations', 'acebeat' ),
		'choices' => array(
			''               => esc_html__( 'Default', 'acebeat' ),
			'slideDown'      => esc_html__( 'slideDown', 'acebeat' ),
			'scaleAppear'    => esc_html__( 'scaleAppear', 'acebeat' ),
			'fadeInLeft'     => esc_html__( 'fadeInLeft', 'acebeat' ),
			'fadeInUp'       => esc_html__( 'fadeInUp', 'acebeat' ),
			'fadeInRight'    => esc_html__( 'fadeInRight', 'acebeat' ),
			'fadeInDown'     => esc_html__( 'fadeInDown', 'acebeat' ),
			'fadeIn'         => esc_html__( 'fadeIn', 'acebeat' ),
			'slideRight'     => esc_html__( 'slideRight', 'acebeat' ),
			'slideUp'        => esc_html__( 'slideUp', 'acebeat' ),
			'slideLeft'      => esc_html__( 'slideLeft', 'acebeat' ),
			'expandUp'       => esc_html__( 'expandUp', 'acebeat' ),
			'slideExpandUp'  => esc_html__( 'slideExpandUp', 'acebeat' ),
			'expandOpen'     => esc_html__( 'expandOpen', 'acebeat' ),
			'bigEntrance'    => esc_html__( 'bigEntrance', 'acebeat' ),
			'hatch'          => esc_html__( 'hatch', 'acebeat' ),
			'tossing'        => esc_html__( 'tossing', 'acebeat' ),
			'pulse'          => esc_html__( 'pulse', 'acebeat' ),
			'floating'       => esc_html__( 'floating', 'acebeat' ),
			'bounce'         => esc_html__( 'bounce', 'acebeat' ),
			'pullUp'         => esc_html__( 'pullUp', 'acebeat' ),
			'pullDown'       => esc_html__( 'pullDown', 'acebeat' ),
			'stretchLeft'    => esc_html__( 'stretchLeft', 'acebeat' ),
			'stretchRight'   => esc_html__( 'stretchRight', 'acebeat' ),
			'fadeInUpBig'    => esc_html__( 'fadeInUpBig', 'acebeat' ),
			'fadeInDownBig'  => esc_html__( 'fadeInDownBig', 'acebeat' ),
			'fadeInLeftBig'  => esc_html__( 'fadeInLeftBig', 'acebeat' ),
			'fadeInRightBig' => esc_html__( 'fadeInRightBig', 'acebeat' ),
			'slideInDown'    => esc_html__( 'slideInDown', 'acebeat' ),
			'slideInLeft'    => esc_html__( 'slideInLeft', 'acebeat' ),
			'slideInRight'   => esc_html__( 'slideInRight', 'acebeat' ),
			'moveFromLeft'   => esc_html__( 'moveFromLeft', 'acebeat' ),
			'moveFromRight'  => esc_html__( 'moveFromRight', 'acebeat' ),
			'moveFromBottom' => esc_html__( 'moveFromBottom', 'acebeat' ),
		),
	),
);