<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'main' => array(
		'type'    => 'box',
		'title'   => '',
		'options' => array(
			'id'       => array(
				'type' => 'unique',
			),
			'builder'  => array(
				'type'    => 'tab',
				'title'   => esc_html__( 'Form Fields', 'acebeat' ),
				'options' => array(
					'form' => array(
						'label'        => false,
						'type'         => 'form-builder',
						'value'        => array(
							'json' => apply_filters( 'fw:ext:forms:builder:load-item:form-header-title', true )
								? json_encode( array(
									array(
										'type'      => 'form-header-title',
										'shortcode' => 'form_header_title',
										'width'     => '',
										'options'   => array(
											'title'    => '',
											'subtitle' => '',
										)
									)
								) )
								: '[]'
						),
						'fixed_header' => true,
					),
				),
			),
			'settings' => array(
				'type'    => 'tab',
				'title'   => esc_html__( 'Settings', 'acebeat' ),
				'options' => array(
					'settings-options' => array(
						'title'   => esc_html__( 'Contact Form Options', 'acebeat' ),
						'type'    => 'tab',
						'options' => array(
							'background_color'    => array(
								'type'    => 'select',
								'value'   => 'ls',
								'label'   => esc_html__( 'Form Background color', 'acebeat' ),
								'desc'    => esc_html__( 'Select background color', 'acebeat' ),
								'help'    => esc_html__( 'Select one of predefined background colors', 'acebeat' ),
								'choices' => array(
									''                              => esc_html__( 'No background', 'acebeat' ),
									'with_padding muted_background' => esc_html__( 'Muted', 'acebeat' ),
									'with_padding with_border'      => esc_html__( 'With Border', 'acebeat' ),
									'with_padding ls'               => esc_html__( 'Light', 'acebeat' ),
									'with_padding ls ms'            => esc_html__( 'Light Grey', 'acebeat' ),
									'with_padding ds'               => esc_html__( 'Dark Grey', 'acebeat' ),
									'with_padding ds ms'            => esc_html__( 'Dark', 'acebeat' ),
									'with_padding cs'               => esc_html__( 'Main color', 'acebeat' ),
									'with_padding cs main_color2'   => esc_html__( 'Second Main color', 'acebeat' ),
								),
							),
							'columns_padding'     => array(
								'type'    => 'select',
								'value'   => 'columns_padding_15',
								'label'   => esc_html__( 'Column paddings in form', 'acebeat' ),
								'desc'    => esc_html__( 'Choose columns horizontal paddings value', 'acebeat' ),
								'choices' => array(
									'columns_padding_15' => esc_html__( '15 px - default', 'acebeat' ),
									'columns_padding_0'  => esc_html__( '0', 'acebeat' ),
									'columns_padding_1'  => esc_html__( '1 px', 'acebeat' ),
									'columns_padding_2'  => esc_html__( '2 px', 'acebeat' ),
									'columns_padding_5'  => esc_html__( '5 px', 'acebeat' ),
									'columns_padding_10'  => esc_html__( '10 px', 'acebeat' ),
								),
							),
							'input_text_center'     => array(
								'type'  => 'switch',
								'value' => '',
								'attr'  => array( 'class' => 'custom-class', 'data-foo' => 'bar' ),
								'label' => esc_html__('Input Text Center', 'acebeat'),
								'desc'  => esc_html__('Center Text in Form Fields', 'acebeat'),
								'left-choice' => array(
									'value' => '',
									'label' => esc_html__('No', 'acebeat'),
								),
								'right-choice' => array(
									'value' => 'input-text-center',
									'label' => esc_html__('Yes', 'acebeat'),
								),
							),
							'form_email_settings' => array(
								'type'    => 'group',
								'options' => array(
									'email_to' => array(
										'type'  => 'text',
										'label' => esc_html__( 'Email To', 'acebeat' ),
										'help'  => esc_html__( 'We recommend you to use an email that you verify often', 'acebeat' ),
										'desc'  => esc_html__( 'The form will be sent to this email address.', 'acebeat' ),
									),
								),
							),
							'form_text_settings'  => array(
								'type'    => 'group',
								'options' => array(
									'subject-group'       => array(
										'type'    => 'group',
										'options' => array(
											'subject_message' => array(
												'type'  => 'text',
												'label' => esc_html__( 'Subject Message', 'acebeat' ),
												'desc'  => esc_html__( 'This text will be used as subject message for the email', 'acebeat' ),
												'value' => esc_html__( 'Contact Form', 'acebeat' ),
											),
										)
									),
									'submit-button-group' => array(
										'type'    => 'group',
										'options' => array(
											'submit_button_text' => array(
												'type'  => 'text',
												'label' => esc_html__( 'Submit Button', 'acebeat' ),
												'desc'  => esc_html__( 'This text will appear in submit button', 'acebeat' ),
												'value' => esc_html__( 'Send', 'acebeat' ),
											),
											'reset_button_text'  => array(
												'type'  => 'text',
												'label' => esc_html__( 'Reset Button', 'acebeat' ),
												'desc'  => esc_html__( 'This text will appear in reset button. Leave blank if reset button not needed', 'acebeat' ),
												'value' => esc_html__( 'Clear', 'acebeat' ),
											),
										)
									),
									'success-group'       => array(
										'type'    => 'group',
										'options' => array(
											'success_message' => array(
												'type'  => 'text',
												'label' => esc_html__( 'Success Message', 'acebeat' ),
												'desc'  => esc_html__( 'This text will be displayed when the form will successfully send', 'acebeat' ),
												'value' => esc_html__( 'Message sent!', 'acebeat' ),
											),
										)
									),
									'failure_message'     => array(
										'type'  => 'text',
										'label' => esc_html__( 'Failure Message', 'acebeat' ),
										'desc'  => esc_html__( 'This text will be displayed when the form will fail to be sent', 'acebeat' ),
										'value' => esc_html__( 'Oops something went wrong.', 'acebeat' ),
									),
								),
							),
						)
					),
					'mailer-options'   => array(
						'title'   => esc_html__( 'Mailer Options', 'acebeat' ),
						'type'    => 'tab',
						'options' => array(
							'mailer' => array(
								'label' => false,
								'type'  => 'mailer'
							)
						)
					)
				),
			),
		),
	)
);