<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}
get_header();
global $post;
$options        = fw_get_db_post_option( $post->ID, fw()->extensions->get( 'events' )->get_event_option_id() );
$column_classes = acebeat_get_columns_classes();

$option_events =  fw_get_db_post_option( $post->ID );
$gallery_images =  $option_events['post-featured-gallery'];
?>
    <div id="content" class="<?php echo esc_attr( $column_classes['main_column_class'] ); ?>">
		<?php
		// Start the Loop.
		while ( have_posts() ) : the_post(); ?>
            <article
                    id="post-<?php the_ID(); ?>" <?php post_class( 'event-single vertical-item content-padding big-padding with_background rounded overflow_hidden' ); ?>>
				<?php if ( ! empty( $gallery_images ) ) : ?>
                    <div class="item-media entry-thumbnail bottommargin_40">
                        <div class="owl-carousel"
                             data-items="1"
                             data-responsive-xs="1"
                             data-responsive-sm="1"
                             data-responsive-md="1"
                             data-responsive-lg="1"
                             data-nav="true"
                             data-dots="true"
                        >

							<?php foreach ( $gallery_images as $image ) : ?>
                                <div>
                                    <img src="<?php echo esc_url($image['url']) ?>" alt="<?php echo esc_attr($post->title); ?>">
                                </div>
							<?php endforeach; ?>
                        </div>
                    </div>
					<?php
				else:
					acebeat_post_thumbnail();
				endif;
				?>
                <div class="item-content">

                    <div class="entry-content">

                        <h1 class="entry-title"><?php the_title(); ?></h1>

                        <!-- additional information about event -->
                        <div class="event-info bottommargin_30">
                            <p class="event-place">
								<?php
								if ( $options['event_location']['location'] ) : ?>
                                    <strong class="grey"><?php esc_html_e( 'Place', 'acebeat' ) ?>:</strong>
									<?php
									echo esc_html( $options['event_location']['location'] );
								endif;

								if ( $options['event_location']['venue'] ) :
									echo esc_html( ', ' . $options['event_location']['venue'] );
								endif;
								?>
                            </p><!-- .event-place-->
							<?php

							foreach ( $options['event_children'] as $key => $row ) : ?>
								<?php if ( empty( $row['event_date_range']['from'] ) or empty( $row['event_date_range']['to'] ) ) : ?>
									<?php continue; ?>
								<?php endif; ?>
								<!--
                                <div class="pull-right">
                                    <button class="theme_button small_button color1"
                                            data-uri="<?php echo add_query_arg( array(
										        'row_id'   => $key,
										        'calendar' => 'google'
									        ), fw_current_url() ); ?>" type="button"><?php esc_html_e( 'Google Calendar',
											'acebeat' ) ?></button>
                                    <button class="theme_button small_button inverse" data-uri="<?php echo add_query_arg( array(
										'row_id'   => $key,
										'calendar' => 'ical'
									), fw_current_url() ); ?>" type="button"><?php esc_html_e( 'Ical Export',
											'acebeat' ) ?></button>
                                </div>
                                -->
                                <ul class="list-unstyled">
                                    <li><strong class="grey"><?php esc_html_e( 'Start', 'acebeat' ) ?>
                                            :</strong> <?php echo wp_kses_post ( $row['event_date_range']['from'] ); ?></li>
                                    <li><strong class="grey"><?php esc_html_e( 'End', 'acebeat' ) ?>
                                            :</strong> <?php echo wp_kses_post ( $row['event_date_range']['to'] ); ?></li>

                                </ul>
							<?php endforeach; ?>
                        </div>
                        <!-- .additional information about event -->

						<?php
						//tags
						echo get_the_term_list( $post->ID, 'fw-event-tag', '<span class="categories-links theme_buttons small_buttons inverse">', ' ', '</span>' );
						?>


						<?php the_content(); ?>

						<?php
						$map = fw_ext_events_render_map();
						if ( $map ):
							?>
                            <div class="event-map">
								<?php echo fw_ext_events_render_map(); ?>
                            </div>
							<?php
						endif; //map
						?>

						<?php do_action( 'acebeat_ext_events_after_content' ); ?>
                    </div><!-- .entry-content -->
                </div><!-- .item-content -->

                <footer class="entry-meta small-text greylinks bottom_color_border">
                    <div class="content-justify">
                        <div class="inline-content">
				            <?php
				            printf( '<a href="%1$s"><i class="fa fa-user rightpadding_5" aria-hidden="true"></i><span>%2$s</span></a>',
					            esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
					            get_the_author()
				            );
				            ?>

				            <?php if ( comments_open() ) : ?>
                                <a href="<?php comments_link(); ?>">
                                    <i class="fa fa-comment rightpadding_5" aria-hidden="true"></i>
                                    <span class="value"><?php comments_number( "0", "1", "%" ); ?></span>
                                </a>
				            <?php else: ?>
                                <span>
                        <i class="fa fa-comment rightpadding_5" aria-hidden="true"></i>
                        <span><?php echo esc_html__( 'Comments closed', 'acebeat' ); ?></span>
                    </span>
				            <?php endif; ?>
				            <?php if ( function_exists( 'mwt_show_post_views_count' ) ) : ?>
                                <span>
                            <i class="fa fa-eye rightpadding_5" aria-hidden="true"></i>
                            <span class="value"><?php acebeat_show_post_views_count(); ?></span>
                        </span>
				            <?php endif; ?>
                        </div>
			            <?php if ( function_exists( 'mwt_share_this' ) ) : ?>
                            <div>
                                <span>Share:</span>
                                <span>
                            <?php acebeat_share_this( true ); ?>
                        </span>
                            </div>
			            <?php endif; ?>
                    </div>
                </footer>

            </article>

			<?php
			// If comments are open or we have at least one comment, load up the comment template.
			if ( comments_open() || get_comments_number() ) {
				comments_template();
			}
		endwhile; ?>

    </div><!--eof #content -->
<?php if ( $column_classes['sidebar_class'] ): ?>
    <!-- main aside sidebar -->
    <aside class="<?php echo esc_attr( $column_classes['sidebar_class'] ); ?>">
		<?php get_sidebar(); ?>
    </aside>
    <!-- eof main aside sidebar -->
	<?php
endif;
get_footer();