<?php
/**
 * Leotheme
 *
 * NOTICE OF LICENSE
 *
 * Leo feature for prestashop 1.7: ajax cart, review, compare, wishlist at product list
 *
 * DISCLAIMER
 *
 *  @author    leotheme <leotheme@gmail.com>
 *  @copyright Leotheme
 *  @license   http://leotheme.com - prestashop template provider
 */
 
require_once(_PS_MODULE_DIR_.'leofeature/classes/LeoProductAttribute.php');
if(version_compare(Configuration::get('PS_VERSION_DB'), '9.0.0', '>='))
{
    require_once(_PS_MODULE_DIR_.'leofeature/classes/LeofeatureProduct9.php');
}else{
    require_once(_PS_MODULE_DIR_.'leofeature/classes/LeofeatureProduct.php');
}

if (!defined('_PS_VERSION_')) {
    # module validation
    exit;
}

class LeofeatureLeoProductAttributeModuleFrontController extends ModuleFrontController
{
    public function displayAjaxGetProductAttribute()
    {
        $id_product = (int)  Tools::getValue('id_product');
        $context = Context::getContext();
        $module = new Leofeature();
        // $id_product_attribute = LeoProductAttribute::getProductAttributesID($id_product, Tools::getValue('group'));
        $id_product_attribute = Product::getIdProductAttributeByIdAttributes(
                $id_product,
                Tools::getValue('group'),
                true
            );
        if (!$id_product_attribute) {
            $groups = Tools::getValue('group');
            $id_product_attribute = DB::getInstance()->getValue('SELECT pac.`id_product_attribute`
                FROM `'._DB_PREFIX_.'product_attribute_combination` pac
                INNER JOIN `'._DB_PREFIX_.'product_attribute` pa ON pa.id_product_attribute = pac.id_product_attribute
                WHERE id_product = '.(int)$id_product.' AND id_attribute='.(int)array_slice($groups,0,1)[0]);
        }
        //refresh
        $productsVariants = LeoProductAttribute::getProductCombinationsSeparatelly($id_product, $id_product_attribute);
        $group_add = [];
        foreach ($productsVariants as $key => &$value) {
            if ($value['attributes']) {
                if (isset($value['attributes'][$value['default']])) {
                    foreach ($value['attributes'] as $key_ => &$val) {
                        if (isset($groups[$key])) {
                            $val['selected'] = $groups[$key] == $key_ ? 1 : 0;
                        }
                    }
                }
                $value['id_attribute_group'] = $key;
                $group_add[] = $value;

            }
        }
        $refresh = $module->getRefreshAttr($group_add);
        $product = new Product ($id_product, false, $context->language->id);
        $product->loadStockData();
        
        $product_array = json_decode(  json_encode($product), true );
        $product_array['quantity'] = Product::getQuantity(
            $id_product, (int) $id_product_attribute, isset($product_array['cache_is_pack']) ? $product_array['cache_is_pack'] : null
        );
        $product_array['allow_oosp'] = Product::isAvailableWhenOutOfStock($product_array['out_of_stock']);


        $add_to_cart_url = null;
        if ($module->shouldEnableAddToCartButton($product_array)) {
            $add_to_cart_url = Context::getContext()->link->getAddToCartURL($id_product, $id_product_attribute);
        }
        
        $attribute_data = new LeofeatureProduct();
        $result = $attribute_data->getTemplateVarProduct2($id_product, $id_product_attribute);

        // get image/ image 2
        $image = '';
        $image2 = '';
        $attributes_groups = $product->getAttributesGroups($context->language->id);
        if (is_array($attributes_groups) && $attributes_groups) {
            $combination_images = $product->getCombinationImages($context->language->id);
            $combination_images = isset($combination_images[$id_product_attribute]) ? $combination_images[$id_product_attribute] : '';
            if ($combination_images && !Tools::getValue('multiple_image')) {
                $image = $context->link->getImageLink($product->link_rewrite, $result['images'][0]['id_image'], ImageType::getFormattedName('home'));
                if (Tools::getValue('image2') && isset($result['images'][1])) {
                    $image2 = $context->link->getImageLink($product->link_rewrite, $result['images'][1]['id_image'], ImageType::getFormattedName('home'));
                    
                }
            } elseif ($combination_images && Tools::getValue('multiple_image')) {
                foreach ($combination_images as $key => &$img) {
                    $img['image'] = $context->link->getImageLink($product->link_rewrite, $img['id_image'], ImageType::getFormattedName('home'));
                }
                $image = $combination_images;
            } else {
                $image = $result['cover']['bySize'][ImageType::getFormattedName('home')]['url'];
            }
        }

        $minimalQuantity = Db::getInstance()->getValue(
            'SELECT `minimal_quantity`
            FROM `' . _DB_PREFIX_ . 'product_attribute_shop` pas
            WHERE `id_shop` = ' . (int) Context::getContext()->shop->id . '
            AND `id_product_attribute` = ' . (int) $id_product_attribute
        );
        die(json_encode(array(
            'product_cover' => $result['cover'],
            'price_attribute'   => $module->renderPriceAttribute($result),
            'product_url' => Context::getContext()->link->getProductLink($id_product, null, null, null, $context->language->id, null, $id_product_attribute, false, false, true),
            'id_attr' => $id_product_attribute,
            'minimal_quantity' => $minimalQuantity,
            'refresh_attr' => isset($refresh) ? $refresh : '',
//            'add_to_cart_url' => Context::getContext()->link->getAddToCartURL($id_product, $id_product_attribute),
            'add_to_cart_url' => $add_to_cart_url,
            'image' => $image,
            'image2' => $image2,
        )));
        
    }
}

