<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Humani_Progress extends Elementor\Widget_Base {

    public function get_name() {
        return 'humani-progress';
    }

    public function get_title() {
        return esc_html__('Humani Progress', 'humani');
    }

    public function get_script_depends() {
        return ['humani-elementor-progress','chart'];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_general',
            [
                'label' => esc_html__('General', 'humani'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'type',
            [
                'label' => esc_html__('Type', 'humani'),
                'type' => Controls_Manager::SELECT,
                'default' => 'doughnut',
                'options' => [
                    'doughnut' => esc_html__('Doughnut', 'humani'),
                    'pie' => esc_html__('Pie', 'humani'),
                ],
            ]
        );

        $this->add_control(
            'description',
            [
                'label'   => esc_html__('Description', 'humani'),
                'default' => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore ',
                'type'    => Controls_Manager::TEXTAREA,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'name',
            [
                'label' => esc_html__('Name', 'humani'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => esc_html__('Chart Name', 'humani'),
                'default' => esc_html__('Chart Name', 'humani'),
            ]
        );
        $repeater->add_control(
            'number',
            [
                'label' => esc_html__('Nunber', 'humani'),
                'type' => Controls_Manager::NUMBER,
                'label_block' => true,
                'default' => '20',
            ]
        );
        $repeater->add_control(
            'color',
            [
                'label' => esc_html__('Color', 'humani'),
                'type' => Controls_Manager::COLOR,
                'label_block' => true,
                'default' => '#1f9a47',
            ]
        );
        $this->add_control(
            'chart_list',
            [
                'label' => 'Chart list',
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'name' => esc_html__('Emergency Services', 'humani'),
                        'number' => '40',
                        'color' => '#c18062',
                    ],
                    [
                        'name' => esc_html__('Housing, Psychosocial Support', 'humani'),
                        'number' => '30',
                        'color' => '#afc171',
                    ],
                    [
                        'name' => esc_html__('Urban Health & Research ', 'humani'),
                        'number' => '20',
                        'color' => '#6aaa8a',
                    ],
                    [
                        'name' => esc_html__('Fundraising & Administration', 'humani'),
                        'number' => '10',
                        'color' => '#91a6ce',
                    ],
                ],
                'title_field' => '<i class="fa fa-dot-circle-o" aria-hidden="true" style="color:{{{color}}}"></i> {{{ name }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_canvas',
            [
                'label' => esc_html__('Canvas', 'humani'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'width_canvas',
            [
                'label' => esc_html__('Canvas Size', 'humani'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 100,
                        'max' => 500,
                    ],
                ],
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chart-canvas' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'legend_indent',
            [
                'label' => esc_html__('Legend Indent', 'humani'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chart-legend' =>'padding-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'chart_description',
            [
                'label' => esc_html__('Description', 'humani'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'description_text_color',
            [
                'label'     => esc_html__('Color', 'humani'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .chart-description' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'description_typography',
                'selector' => '{{WRAPPER}} .chart-description',
            ]
        );

        $this->add_responsive_control(
            'description_space',
            [
                'label'     => esc_html__('Spacing', 'humani'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chart-description' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_icon',
            [
                'label' => esc_html__('icon', 'humani'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'icon_size',
            [
                'label' => esc_html__('Size', 'humani'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 14,
                ],
                'range' => [
                    'px' => [
                        'min' => 6,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_name',
            [
                'label' => esc_html__('Name', 'humani'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'name_color',
            [
                'label' => esc_html__('Name Color', 'humani'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chart-name' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'name_typography',
                'selector' => '{{WRAPPER}} .chart-name',
            ]
        );
        $this->add_control(
            'name_indent',
            [
                'label' => esc_html__('Name Indent', 'humani'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chart-name' => is_rtl() ? 'padding-right: {{SIZE}}{{UNIT}};' : 'padding-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_number',
            [
                'label' => esc_html__('Number', 'humani'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'number_color',
            [
                'label' => esc_html__('Number Color', 'humani'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chart-number' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'number_typography',
                'selector' => '{{WRAPPER}} .chart-number',
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $total = 0;
        $chart_settings = [];
        $chart_settings['type'][] = $settings['type'];
        foreach ($settings['chart_list'] as $item) {
            $chart_settings['name'][] = $item['name'];
            $chart_settings['color'][] = $item['color'];
            $chart_settings['number'][] = $item['number'];
            $total += $item['number'];
        }
        $this->add_render_attribute('canvas', 'data-settings', wp_json_encode($chart_settings));
        ?>
        <div class="elementor-chart-wrapper d-flex align-items-center">
            <div class="chart-canvas">
                <canvas width="500px" height="500px"
                        class="chart-area"<?php echo humani_elementor_get_render_attribute_string('canvas', $this) ?>></canvas>
            </div>

            <div class="chart-legend">
                <?php if (!empty($settings['description'])): ?>
                    <div class="chart-description"><?php echo sprintf('%s', $settings['description']); ?></div>
                <?php endif; ?>
                <ul <?php echo humani_elementor_get_render_attribute_string('chart_list', $this); ?>>
                    <?php foreach ($settings['chart_list'] as $index => $item): ?>
                        <li class="elementor-chart-list-item">
                            <i class="fa fa-circle" aria-hidden="true"
                               style="color: <?php echo esc_attr($item['color']) ?>"></i>
                            <span class="chart-name"><?php echo esc_html($item['name']); ?></span>
                            <span class="chart-line">-</span>
                            <span class="chart-number"><?php echo esc_html($this->check($total, $item['number']));?>&percnt;</span>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
        <?php
    }
    private function check($total, $number)
    {
        return ceil($number / $total * 100);
    }
}

$widgets_manager->register(new Humani_Progress());
