<?php
// Button
use Elementor\Controls_Manager;

add_action( 'elementor/element/hfe-search-button/section_button_style/before_section_end', function ($element, $args ) {

    $element->add_control(
		'button-border-radius',
		[
			'label'      => esc_html__('Border Radius', 'humani'),
			'type'       => Controls_Manager::DIMENSIONS,
			'size_units' => ['px', 'em', '%'],
			'selectors'  => [
				'{{WRAPPER}} .hfe-search-form__container .hfe-search-submit' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
			]
		]
	);

}, 10, 2 );

add_action( 'elementor/element/hfe-search-button/section_input_style/before_section_end', function ($element, $args ) {

	$element->add_responsive_control(
		'input_padding',
		[
			'label'      => esc_html__('Padding', 'humani'),
			'type'       => Controls_Manager::DIMENSIONS,
			'size_units' => ['px', 'em', '%'],
			'selectors'  => [
				'{{WRAPPER}} .hfe-search-form__container .hfe-search-form__input' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
			]
		]
	);

}, 10, 2 );
