(function ($) {
    "use strict";
    $(window).on('elementor/frontend/init', () => {
        elementorFrontend.hooks.addAction('frontend/element_ready/humani-progress.default', ($scope) => {

            let $canvas = $scope.find('.chart-area');
            let settings = $canvas.data('settings');
            new Chart($canvas.get(0), {
                type: settings.type,
                data: {
                    labels: settings.name,
                    datasets: [{
                        data: settings.number,
                        backgroundColor: settings.color,
                        borderWidth: 0,
                    }]
                },
                options: {
                    //cutoutPercentage: 60,
                    responsive: true,
                    legend: {
                        display: false,
                    },
                    tooltips: {
                        enabled: false,
                    },
                    title: {
                        display: false,
                    },
                },
            });
        });
    });
})(jQuery);
