<?php

namespace GiveRecurring\PaymentGateways\PayPalCommerce\PayPalHttpRequests;

use PayPalHttp\HttpRequest;

/**
 * @see https://developer.paypal.com/docs/api/subscriptions/v1/#subscriptions_activate
 * @since 2.12.0
 */
class ActivateSubscription extends HttpRequest
{
    /**
     * @since 2.12.0
     */
    public function __construct(array $headers, string $paypalSubscriptionId)
    {
        $endpoint = sprintf(
            '/v1/billing/subscriptions/%s/activate',
            $paypalSubscriptionId
        );

        parent::__construct($endpoint, 'POST');

        $this->headers = array_merge($this->headers, $headers);
        $this->body = wp_json_encode([
            'reason' => 'GiveWP confirmation to active subscription'
        ]);
    }
}
