<?php

namespace GiveRecurring\PaymentGatewayModules\Modules\Mollie\Webhooks;

use Give\Framework\Support\Facades\ActionScheduler\AsBackgroundJobs;
use GiveMollie\DataTransferObjects\MollieWebhookRequest;

/**
 * @since 2.7.0
 */
class MollieSubscriptionWebhookRequestHandler
{
    /**
     * @since 2.7.0
     */
    public function __invoke(MollieWebhookRequest $mollieWebhookRequest)
    {
        if ($this->isOneTimeDonation($mollieWebhookRequest)) {
            return;
        }

        switch ($mollieWebhookRequest->hookType) {
            case 'payments':
                if ($mollieWebhookRequest->payment->isPaid() && ! $mollieWebhookRequest->payment->hasRefunds() && ! $mollieWebhookRequest->payment->hasChargebacks()) {
                    $this->setSubscriptionFirstPaymentAsyncEvent($mollieWebhookRequest->payment->id);
                }
                break;
            case 'subscription':
                $this->setSubscriptionRenewalPaymentAsyncEvent(
                    $mollieWebhookRequest->payment->subscriptionId,
                    $mollieWebhookRequest->payment->id
                );
                break;
        }
    }

    /**
     * @since 2.7.0
     */
    private function isOneTimeDonation(MollieWebhookRequest $mollieWebhookRequest): bool
    {
        return 'payments' === $mollieWebhookRequest->hookType && ! $mollieWebhookRequest->payment->hasSequenceTypeFirst();
    }

    /**
     * @since 2.7.0
     */
    public function setSubscriptionFirstPaymentAsyncEvent(string $gatewayTransactionId)
    {
        $this->enqueueAsyncAction('givewp_mollie_event_subscription_first_donation',
            [$gatewayTransactionId]);
    }

    /**
     * @since 2.7.0
     */
    public function setSubscriptionRenewalPaymentAsyncEvent(
        string $gatewaySubscriptionId,
        string $gatewayTransactionId
    )
    {
        $this->enqueueAsyncAction('givewp_mollie_event_subscription_renewal_donation',
            [$gatewaySubscriptionId, $gatewayTransactionId]);
    }

    /**
     * @since 2.7.0
     */
    private function enqueueAsyncAction(string $hook, array $args)
    {
        AsBackgroundJobs::enqueueAsyncAction($hook, $args, 'give-recurring-mollie');
    }
}
