<?php

namespace GiveRecurring\PaymentGatewayModules\Modules\GoCardless\Actions;

use Exception;
use Give\Framework\PaymentGateways\Exceptions\PaymentGatewayException;
use Give\Subscriptions\Models\Subscription;

/**
 * @since 2.14.0
 */
class GetGoCardlessSubscriptionTransactions
{
    /**
     * @since 2.14.0
     *
     * @throws PaymentGatewayException
     */
    public function __invoke(Subscription $subscription, string $date = ''): array
    {
        if (empty($subscription->gatewaySubscriptionId)) {
            throw new PaymentGatewayException(
                sprintf(
                    __('Unable to get subscription transactions for #%s. Subscription does not have gatewaySubscriptionId.', 'give-gocardless'),
                    $subscription->id
                )
            );
        }

        $subscriptionArgs = [
            'subscription' => $subscription->gatewaySubscriptionId,
        ];

        $response = \Give_GoCardless_API::get_payments($subscriptionArgs);

        if (is_wp_error($response) || isset($response['error'])) {
            throw new PaymentGatewayException(sprintf(
                __('Error getting subscription transactions for #%s: %s - %s', 'give-gocardless'),
                $subscription->gatewaySubscriptionId,
                isset($response['error']['code']) ? $response['error']['code'] : $response->get_error_code(),
                isset($response['error']['message']) ? $response['error']['message'] : $response->get_error_message()
            ));
        }

        if (empty($response['payments'])) {
            return [];
        }

        $transactions = [];
        foreach ($response['payments'] as $payment) {
            // Collect GoCardless transaction data (following legacy logic exactly)
            $transactions[$payment['id']] = [
                'amount' => $payment['amount'] / 100,
                'date' => strtotime($payment['created_at']),
                'transaction_id' => $payment['id'],
            ];
        }

        return $transactions;
    }
}
